/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.common.env;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.zip.ZipFile;
import me.arasple.mc.trchat.taboolib.common.TabooLibCommon;
import me.arasple.mc.trchat.taboolib.common.env.ClassAppender;
import me.arasple.mc.trchat.taboolib.common.env.Dependency;
import me.arasple.mc.trchat.taboolib.common.env.DependencyDownloader;
import me.arasple.mc.trchat.taboolib.common.env.DependencyScope;
import me.arasple.mc.trchat.taboolib.common.env.JarRelocation;
import me.arasple.mc.trchat.taboolib.common.env.KotlinEnv;
import me.arasple.mc.trchat.taboolib.common.env.KotlinEnvNoRelocate;
import me.arasple.mc.trchat.taboolib.common.env.Repository;
import me.arasple.mc.trchat.taboolib.common.env.RuntimeDependencies;
import me.arasple.mc.trchat.taboolib.common.env.RuntimeDependency;
import me.arasple.mc.trchat.taboolib.common.env.RuntimeResource;
import me.arasple.mc.trchat.taboolib.common.env.RuntimeResources;
import org.jetbrains.annotations.NotNull;

public class RuntimeEnv {
    public static final RuntimeEnv ENV = new RuntimeEnv();
    private static final String ENV_FILE_NAME = "env.properties";
    private static final Properties ENV_PROPERTIES = new Properties();
    private static String defaultAssets = "assets";
    private static String defaultLibrary = "libs";
    private static String defaultRepositoryCentral = "https://maven.aliyun.com/repository/central";

    RuntimeEnv() {
        try {
            File env;
            File libs = new File("libs", "custom.txt");
            if (libs.exists()) {
                defaultLibrary = Files.readAllLines(libs.toPath(), StandardCharsets.UTF_8).get(0);
            }
            if ((env = new File(ENV_FILE_NAME)).exists()) {
                ENV_PROPERTIES.load(Files.newInputStream(Paths.get(ENV_FILE_NAME, new String[0]), new OpenOption[0]));
                defaultAssets = ENV_PROPERTIES.getProperty("assets", defaultAssets);
                defaultLibrary = ENV_PROPERTIES.getProperty("library", defaultLibrary);
                defaultRepositoryCentral = ENV_PROPERTIES.getProperty("repository-central", defaultRepositoryCentral);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public void setup() {
        try {
            this.loadDependency(KotlinEnv.class, true);
        }
        catch (NoClassDefFoundError ignored) {
            try {
                this.loadDependency(KotlinEnvNoRelocate.class, true);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
    }

    public void inject(@NotNull Class<?> clazz) {
        this.loadAssets(clazz);
        this.loadDependency(clazz, false);
    }

    public void loadAssets(@NotNull Class<?> clazz) {
        RuntimeResource[] resources = null;
        if (clazz.isAnnotationPresent(RuntimeResource.class)) {
            resources = (RuntimeResource[])clazz.getAnnotationsByType(RuntimeResource.class);
        } else {
            RuntimeResources annotation = clazz.getAnnotation(RuntimeResources.class);
            if (annotation != null) {
                resources = annotation.value();
            }
        }
        if (resources == null) {
            return;
        }
        for (RuntimeResource resource : resources) {
            this.loadAssets(resource.name(), resource.hash(), resource.value(), resource.zip());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAssets(String name2, String hash, String url, boolean zip) {
        block32: {
            File file = name2.isEmpty() ? new File(defaultAssets, hash.substring(0, 2) + "/" + hash) : new File(defaultAssets, name2);
            if (file.exists() && DependencyDownloader.readFileHash(file).equals(hash)) {
                return;
            }
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            TabooLibCommon.print("Downloading assets " + url.substring(url.lastIndexOf(47) + 1));
            try {
                if (zip) {
                    File cacheFile = new File(file.getParentFile(), file.getName() + ".zip");
                    Repository.downloadToFile(new URL(url + ".zip"), cacheFile);
                    try (ZipFile zipFile = new ZipFile(cacheFile);){
                        InputStream inputStream = zipFile.getInputStream(zipFile.getEntry(url.substring(url.lastIndexOf(47) + 1)));
                        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                            fileOutputStream.write(DependencyDownloader.readFully(inputStream));
                            break block32;
                        }
                    }
                    finally {
                        cacheFile.delete();
                    }
                }
                Repository.downloadToFile(new URL(url), file);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    public void loadDependency(@NotNull Class<?> clazz, boolean initiative) {
        File baseDir = new File(defaultLibrary);
        RuntimeDependency[] dependencies = null;
        if (clazz.isAnnotationPresent(RuntimeDependency.class)) {
            dependencies = (RuntimeDependency[])clazz.getAnnotationsByType(RuntimeDependency.class);
        } else {
            RuntimeDependencies annotation = clazz.getAnnotation(RuntimeDependencies.class);
            if (annotation != null) {
                dependencies = annotation.value();
            }
        }
        if (dependencies != null) {
            for (RuntimeDependency dependency : dependencies) {
                String test;
                if (dependency.initiative() && !initiative) continue;
                String string = test = dependency.test().startsWith("!") ? dependency.test().substring(1) : dependency.test();
                if (test.length() > 0 && ClassAppender.isExists(test)) continue;
                ArrayList<JarRelocation> relocation = new ArrayList<JarRelocation>();
                String[] relocate = dependency.relocate();
                if (relocate.length % 2 != 0) {
                    throw new IllegalArgumentException("unformatted relocate");
                }
                int i = 0;
                while (i + 1 < relocate.length) {
                    String pattern = relocate[i].startsWith("!") ? relocate[i].substring(1) : relocate[i];
                    String relocatePattern = relocate[i + 1].startsWith("!") ? relocate[i + 1].substring(1) : relocate[i + 1];
                    relocation.add(new JarRelocation(pattern, relocatePattern));
                    i += 2;
                }
                try {
                    String[] args = dependency.value().startsWith("!") ? dependency.value().substring(1).split(":") : dependency.value().split(":");
                    DependencyDownloader downloader = new DependencyDownloader(baseDir, relocation);
                    String repository = dependency.repository().isEmpty() ? defaultRepositoryCentral : (ENV_PROPERTIES.contains("repository-" + dependency.repository()) ? ENV_PROPERTIES.getProperty("repository-" + dependency.repository()) : dependency.repository());
                    downloader.addRepository(new Repository(repository));
                    downloader.setIgnoreOptional(dependency.ignoreOptional());
                    downloader.setIgnoreException(dependency.ignoreException());
                    downloader.setDependencyScopes(dependency.scopes());
                    File pomFile = new File(baseDir, String.format("%s/%s/%s/%s-%s.pom", args[0].replace('.', '/'), args[1], args[2], args[1], args[2]));
                    File pomShaFile = new File(pomFile.getPath() + ".sha1");
                    if (pomFile.exists() && pomShaFile.exists() && DependencyDownloader.readFile(pomShaFile).startsWith(DependencyDownloader.readFileHash(pomFile))) {
                        downloader.loadDependencyFromInputStream(pomFile.toPath().toUri().toURL().openStream());
                    } else {
                        String pom = String.format("%s/%s/%s/%s/%s-%s.pom", repository, args[0].replace('.', '/'), args[1], args[2], args[1], args[2]);
                        try {
                            TabooLibCommon.print(String.format("Downloading library %s:%s:%s", args[0], args[1], args[2]));
                            downloader.loadDependencyFromInputStream(new URL(pom).openStream());
                        }
                        catch (FileNotFoundException ex) {
                            if (ex.toString().contains("@kotlin_version@")) {
                                return;
                            }
                            throw ex;
                        }
                    }
                    Dependency current = new Dependency(args[0], args[1], args[2], DependencyScope.RUNTIME);
                    if (dependency.transitive()) {
                        downloader.injectClasspath(downloader.loadDependency(downloader.getRepositories(), current));
                        continue;
                    }
                    downloader.injectClasspath(Collections.singleton(current));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

