/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.common5;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import me.arasple.mc.trchat.taboolib.common.Isolated;
import org.jetbrains.annotations.NotNull;

@Isolated
public abstract class Baffle {
    public abstract void resetAll();

    public abstract void reset(String var1);

    public abstract void next(String var1);

    public abstract boolean hasNext(String var1, boolean var2);

    public void reset() {
        this.reset("*");
    }

    public void next() {
        this.next("*");
    }

    public boolean hasNext() {
        return this.hasNext("*");
    }

    public boolean hasNext(String id2) {
        return this.hasNext(id2, true);
    }

    @NotNull
    public static Baffle of(long duration, TimeUnit timeUnit) {
        return new BaffleTime(timeUnit.toMillis(duration));
    }

    @NotNull
    public static Baffle of(int count) {
        return new BaffleCounter(count);
    }

    public static class BaffleCounter
    extends Baffle {
        private final int count;
        private final Map<String, Integer> data = Maps.newConcurrentMap();

        public BaffleCounter(int count) {
            this.count = count;
        }

        @Override
        public void resetAll() {
            this.data.clear();
        }

        @Override
        public void reset(String id2) {
            this.data.remove(id2);
        }

        @Override
        public void next(String id2) {
            this.data.put(id2, this.data.computeIfAbsent(id2, a -> 0) + 1);
        }

        @Override
        public boolean hasNext(String id2, boolean update2) {
            int i = this.data.computeIfAbsent(id2, a -> 0);
            if (i < this.count) {
                if (update2) {
                    this.data.put(id2, i + 1);
                }
                return false;
            }
            if (update2) {
                this.data.put(id2, 0);
            }
            return true;
        }
    }

    public static class BaffleTime
    extends Baffle {
        private final long millis;
        private final Map<String, Long> data = Maps.newConcurrentMap();

        public BaffleTime(long millis) {
            this.millis = millis;
        }

        public long nextTime(String id2) {
            long result = this.data.get(id2) + this.millis - System.currentTimeMillis();
            return result >= 0L ? result : 0L;
        }

        @Override
        public void resetAll() {
            this.data.clear();
        }

        @Override
        public void reset(String id2) {
            this.data.remove(id2);
        }

        @Override
        public void next(String id2) {
            this.data.put(id2, System.currentTimeMillis());
        }

        @Override
        public boolean hasNext(String id2, boolean update2) {
            long time = this.data.getOrDefault(id2, 0L);
            if (time + this.millis < System.currentTimeMillis()) {
                if (update2) {
                    this.data.put(id2, System.currentTimeMillis());
                }
                return true;
            }
            return false;
        }
    }
}

