/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.library.kether;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import me.arasple.mc.trchat.taboolib.library.kether.QuestActionParser;
import me.arasple.mc.trchat.taboolib.library.kether.QuestContext;
import me.arasple.mc.trchat.taboolib.library.kether.QuestRegistry;

public class DefaultRegistry
implements QuestRegistry {
    private final Map<String, Map<String, QuestActionParser>> parsers = new HashMap<String, Map<String, QuestActionParser>>();
    private final Map<String, BiFunction<QuestContext.Frame, String, String>> processors = new HashMap<String, BiFunction<QuestContext.Frame, String, String>>();

    @Override
    public void registerAction(String namespace, String id2, QuestActionParser parser4) {
        this.parsers.computeIfAbsent(namespace, i -> new HashMap()).put(id2, parser4);
    }

    @Override
    public void registerAction(String id2, QuestActionParser parser4) {
        this.registerAction("kether", id2, parser4);
    }

    @Override
    public void registerStringProcessor(String id2, BiFunction<QuestContext.Frame, String, String> processor) {
        this.processors.put(id2, processor);
    }

    @Override
    public void unregisterAction(String id2) {
        this.unregisterAction("kether", id2);
    }

    @Override
    public void unregisterAction(String namespace, String id2) {
        Map map2 = this.parsers.computeIfAbsent(namespace, i -> new HashMap());
        if (id2.equals("*")) {
            map2.clear();
        } else {
            map2.remove(id2);
        }
    }

    @Override
    public Collection<String> getRegisteredActions(String namespace) {
        Map<String, QuestActionParser> map2 = this.parsers.get(namespace);
        return map2 == null ? Collections.emptyList() : Collections.unmodifiableCollection(map2.keySet());
    }

    @Override
    public Collection<String> getRegisteredActions() {
        return this.getRegisteredActions("kether");
    }

    @Override
    public Collection<String> getRegisteredNamespace() {
        return Collections.unmodifiableCollection(this.parsers.keySet());
    }

    @Override
    public Optional<QuestActionParser> getParser(String id2, String namespace) {
        Map<String, QuestActionParser> map2 = this.parsers.get(namespace);
        return map2 == null ? Optional.empty() : Optional.ofNullable(map2.get(id2));
    }

    @Override
    public Optional<QuestActionParser> getParser(String id2, List<String> namespace) {
        String[] domain = id2.split(":");
        if (domain.length == 2) {
            return this.getParser(domain[1], domain[0]);
        }
        for (String name2 : namespace) {
            Optional<QuestActionParser> optional = this.getParser(id2, name2);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    @Override
    public Optional<QuestActionParser> getParser(String id2) {
        return this.getParser(id2, "kether");
    }

    @Override
    public Optional<BiFunction<QuestContext.Frame, String, String>> getStringProcessor(String id2) {
        return Optional.ofNullable(this.processors.get(id2));
    }
}

