/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.library.kether.actions;

import java.util.concurrent.CompletableFuture;
import me.arasple.mc.trchat.taboolib.common5.Coerce;
import me.arasple.mc.trchat.taboolib.library.kether.ParsedAction;
import me.arasple.mc.trchat.taboolib.library.kether.QuestAction;
import me.arasple.mc.trchat.taboolib.library.kether.QuestActionParser;
import me.arasple.mc.trchat.taboolib.library.kether.QuestContext;
import me.arasple.mc.trchat.taboolib.library.kether.QuestService;
import org.jetbrains.annotations.NotNull;

final class RepeatAction
extends QuestAction<Void> {
    private final int time;
    private final ParsedAction<?> action;

    public RepeatAction(int time, ParsedAction<?> action) {
        this.time = time;
        this.action = action;
    }

    @Override
    public CompletableFuture<Void> process(@NotNull QuestContext.Frame frame) {
        int cur = Coerce.toInteger(frame.variables().get("times").orElse(0));
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.process(frame, future, cur);
        return future;
    }

    private void process(QuestContext.Frame frame, CompletableFuture<Void> future, int cur) {
        if (cur < this.time) {
            frame.newFrame(this.action).run().thenRunAsync(() -> {
                frame.variables().set("times", cur + 1);
                this.process(frame, future, cur + 1);
            }, frame.context().getExecutor());
        } else {
            frame.variables().set("times", null);
            future.complete(null);
        }
    }

    public static QuestActionParser parser(QuestService<?> service) {
        return QuestActionParser.of(resolver -> new RepeatAction(resolver.nextInt(), resolver.nextAction()));
    }
}

