/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.library.xseries;

import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Base64;
import java.util.UUID;
import me.arasple.mc.trchat.taboolib.common.reflect.Reflex;
import me.arasple.mc.trchat.taboolib.library.xseries.XMaterial;
import me.arasple.mc.trchat.taboolib.platform.util.ItemBuilder;
import org.apache.commons.lang3.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XSkull {
    protected static final MethodHandle PROFILE_GETTER;
    protected static final MethodHandle PROFILE_SETTER;
    private static final String VALUE_PROPERTY = "{\"textures\":{\"SKIN\":{\"url\":\"";
    private static final boolean SUPPORTS_UUID;
    private static final String TEXTURES = "https://textures.minecraft.net/texture/";

    @NotNull
    public static ItemStack getSkull(@NotNull UUID id2) {
        ItemStack head = XMaterial.PLAYER_HEAD.parseItem();
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        if (SUPPORTS_UUID) {
            meta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)id2));
        } else {
            meta.setOwner(id2.toString());
        }
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    @NotNull
    public static SkullMeta applySkin(@NotNull ItemMeta head, @NotNull OfflinePlayer identifier) {
        SkullMeta meta = (SkullMeta)head;
        if (SUPPORTS_UUID) {
            meta.setOwningPlayer(identifier);
        } else {
            meta.setOwner(identifier.getName());
        }
        return meta;
    }

    @NotNull
    public static SkullMeta applySkin(@NotNull ItemMeta head, @NotNull UUID identifier) {
        return XSkull.applySkin(head, Bukkit.getOfflinePlayer((UUID)identifier));
    }

    @NotNull
    public static SkullMeta applySkin(@NotNull ItemMeta head, @NotNull String identifier) {
        SkullMeta meta = (SkullMeta)head;
        if (XSkull.isUsername(identifier)) {
            return XSkull.applySkin(head, Bukkit.getOfflinePlayer((String)identifier));
        }
        if (identifier.contains("textures.minecraft.net")) {
            return XSkull.getValueFromTextures(meta, identifier);
        }
        if (identifier.length() > 100 && XSkull.isBase64(identifier)) {
            return XSkull.getSkullByValue(meta, identifier);
        }
        return XSkull.getTexturesFromUrlValue(meta, identifier);
    }

    @NotNull
    protected static SkullMeta getSkullByValue(@NotNull SkullMeta head, @NotNull String value) {
        Validate.notEmpty((CharSequence)value, (String)"Skull value cannot be null or empty", (Object[])new Object[0]);
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", value));
        try {
            PROFILE_SETTER.invoke(head, profile);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return head;
    }

    @NotNull
    private static SkullMeta getValueFromTextures(@NotNull SkullMeta head, @NotNull String url) {
        return XSkull.getSkullByValue(head, XSkull.encodeBase64(VALUE_PROPERTY + url + "\"}}}"));
    }

    @NotNull
    private static SkullMeta getTexturesFromUrlValue(@NotNull SkullMeta head, @NotNull String urlValue) {
        return XSkull.getValueFromTextures(head, TEXTURES + urlValue);
    }

    @NotNull
    private static String encodeBase64(@NotNull String str) {
        return Base64.getEncoder().encodeToString(str.getBytes());
    }

    private static boolean isBase64(@NotNull String base64) {
        try {
            Base64.getDecoder().decode(base64);
            return true;
        }
        catch (IllegalArgumentException ignored) {
            return false;
        }
    }

    @Nullable
    public static ItemBuilder.SkullTexture getSkinValue(@NotNull ItemMeta skull) {
        GameProfile profile = null;
        try {
            profile = (GameProfile)Reflex.Companion.getProperty(skull, "profile", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (profile != null && !profile.getProperties().get((Object)"textures").isEmpty()) {
            for (Property property : profile.getProperties().get((Object)"textures")) {
                if (property.getValue().isEmpty()) continue;
                return new ItemBuilder.SkullTexture(property.getValue(), profile.getId());
            }
        }
        return null;
    }

    private static boolean isUsername(@NotNull String name2) {
        int len = name2.length();
        if (len < 3 || len > 16) {
            return false;
        }
        UnmodifiableIterator unmodifiableIterator = Lists.charactersOf((String)name2).iterator();
        while (unmodifiableIterator.hasNext()) {
            char ch = ((Character)unmodifiableIterator.next()).charValue();
            if (ch == '_' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    static {
        SUPPORTS_UUID = XMaterial.supports(12);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle profileSetter = null;
        MethodHandle profileGetter = null;
        try {
            Class<?> CraftMetaSkull = XMaterial.PLAYER_HEAD.parseItem().getItemMeta().getClass();
            Field profile = CraftMetaSkull.getDeclaredField("profile");
            profile.setAccessible(true);
            profileSetter = lookup.unreflectSetter(profile);
            profileGetter = lookup.unreflectGetter(profile);
        }
        catch (IllegalAccessException | NoSuchFieldException e2) {
            e2.printStackTrace();
        }
        PROFILE_SETTER = profileSetter;
        PROFILE_GETTER = profileGetter;
    }
}

