/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.module.metrics.charts;

import java.util.Map;
import java.util.concurrent.Callable;
import me.arasple.mc.trchat.taboolib.common.Isolated;
import me.arasple.mc.trchat.taboolib.module.metrics.CustomChart;
import me.arasple.mc.trchat.taboolib.module.metrics.JsonBuilder;

@Isolated
public class AdvancedBarChart
extends CustomChart {
    private final Callable<Map<String, int[]>> callable;

    public AdvancedBarChart(String chartId, Callable<Map<String, int[]>> callable) {
        super(chartId);
        this.callable = callable;
    }

    @Override
    protected JsonBuilder.JsonObject getChartData() throws Exception {
        JsonBuilder valuesBuilder = new JsonBuilder();
        Map<String, int[]> map2 = this.callable.call();
        if (map2 == null || map2.isEmpty()) {
            return null;
        }
        boolean allSkipped = true;
        for (Map.Entry<String, int[]> entry : map2.entrySet()) {
            if (entry.getValue().length == 0) continue;
            allSkipped = false;
            valuesBuilder.appendField(entry.getKey(), entry.getValue());
        }
        if (allSkipped) {
            return null;
        }
        return new JsonBuilder().appendField("values", valuesBuilder.build()).build();
    }
}

