/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.platform;

import java.io.File;
import java.util.Set;
import me.arasple.mc.trchat.taboolib.common.LifeCycle;
import me.arasple.mc.trchat.taboolib.common.TabooLibCommon;
import me.arasple.mc.trchat.taboolib.common.io.Project1Kt;
import me.arasple.mc.trchat.taboolib.common.platform.Platform;
import me.arasple.mc.trchat.taboolib.common.platform.PlatformSide;
import me.arasple.mc.trchat.taboolib.common.platform.Plugin;
import me.arasple.mc.trchat.taboolib.common.platform.function.ExecutorKt;
import me.arasple.mc.trchat.taboolib.common.reflect.Reflex;
import me.arasple.mc.trchat.taboolib.platform.BukkitWorldGenerator;
import org.bukkit.Bukkit;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PlatformSide(value={Platform.BUKKIT})
public class BukkitPlugin
extends JavaPlugin {
    @Nullable
    private static Plugin pluginInstance;
    private static BukkitPlugin instance;

    public BukkitPlugin() {
        instance = this;
        BukkitPlugin.injectAccess();
        TabooLibCommon.lifeCycle(LifeCycle.INIT);
    }

    public void onLoad() {
        TabooLibCommon.lifeCycle(LifeCycle.LOAD);
        if (pluginInstance == null) {
            pluginInstance = Project1Kt.findImplementation(Plugin.class);
        }
        if (pluginInstance != null && !TabooLibCommon.isStopped()) {
            pluginInstance.onLoad();
        }
    }

    public void onEnable() {
        TabooLibCommon.lifeCycle(LifeCycle.ENABLE);
        if (!TabooLibCommon.isStopped()) {
            if (pluginInstance != null) {
                pluginInstance.onEnable();
            }
            try {
                ExecutorKt.startExecutor();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (!TabooLibCommon.isStopped()) {
            Bukkit.getScheduler().runTask((org.bukkit.plugin.Plugin)this, new Runnable(){

                @Override
                public void run() {
                    TabooLibCommon.lifeCycle(LifeCycle.ACTIVE);
                    if (pluginInstance != null) {
                        pluginInstance.onActive();
                    }
                }
            });
        }
    }

    public void onDisable() {
        TabooLibCommon.lifeCycle(LifeCycle.DISABLE);
        if (pluginInstance != null && !TabooLibCommon.isStopped()) {
            pluginInstance.onDisable();
        }
    }

    public ChunkGenerator getDefaultWorldGenerator(@NotNull String worldName, String id2) {
        try {
            if (pluginInstance instanceof BukkitWorldGenerator) {
                return ((BukkitWorldGenerator)((Object)pluginInstance)).getDefaultWorldGenerator(worldName, id2);
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    public File getFile() {
        return super.getFile();
    }

    @NotNull
    public static BukkitPlugin getInstance() {
        return instance;
    }

    @Nullable
    public static Plugin getPluginInstance() {
        return pluginInstance;
    }

    static void injectAccess() {
        try {
            PluginDescriptionFile description = (PluginDescriptionFile)Reflex.Companion.getProperty(BukkitPlugin.class.getClassLoader(), "description", false);
            Set accessSelf = (Set)Reflex.Companion.getProperty(BukkitPlugin.class.getClassLoader(), "seenIllegalAccess", false);
            for (org.bukkit.plugin.Plugin plugin2 : Bukkit.getPluginManager().getPlugins()) {
                if (!plugin2.getClass().getName().endsWith("platform.BukkitPlugin")) continue;
                Set accessOther = (Set)Reflex.Companion.getProperty(plugin2.getClass().getClassLoader(), "seenIllegalAccess", false);
                accessOther.add(description.getName());
                accessSelf.add(plugin2.getName());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        TabooLibCommon.lifeCycle(LifeCycle.CONST, Platform.BUKKIT);
        if (TabooLibCommon.isKotlinEnvironment()) {
            pluginInstance = Project1Kt.findImplementation(Plugin.class);
        }
    }
}

