/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.taboolib.platform;

import java.util.concurrent.TimeUnit;
import me.arasple.mc.trchat.taboolib.common.LifeCycle;
import me.arasple.mc.trchat.taboolib.common.TabooLibCommon;
import me.arasple.mc.trchat.taboolib.common.io.Project1Kt;
import me.arasple.mc.trchat.taboolib.common.platform.Platform;
import me.arasple.mc.trchat.taboolib.common.platform.PlatformSide;
import me.arasple.mc.trchat.taboolib.common.platform.Plugin;
import me.arasple.mc.trchat.taboolib.common.platform.function.ExecutorKt;
import net.md_5.bungee.BungeeCord;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PlatformSide(value={Platform.BUNGEE})
public class BungeePlugin
extends net.md_5.bungee.api.plugin.Plugin {
    @Nullable
    private static Plugin pluginInstance;
    private static BungeePlugin instance;

    public BungeePlugin() {
        instance = this;
        TabooLibCommon.lifeCycle(LifeCycle.INIT);
    }

    public void onLoad() {
        TabooLibCommon.lifeCycle(LifeCycle.LOAD);
        if (pluginInstance == null) {
            pluginInstance = Project1Kt.findImplementation(Plugin.class);
        }
        if (pluginInstance != null && !TabooLibCommon.isStopped()) {
            pluginInstance.onLoad();
        }
    }

    public void onEnable() {
        TabooLibCommon.lifeCycle(LifeCycle.ENABLE);
        if (!TabooLibCommon.isStopped()) {
            if (pluginInstance != null) {
                pluginInstance.onEnable();
            }
            try {
                ExecutorKt.startExecutor();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (!TabooLibCommon.isStopped()) {
            BungeeCord.getInstance().getScheduler().schedule((net.md_5.bungee.api.plugin.Plugin)this, new Runnable(){

                @Override
                public void run() {
                    TabooLibCommon.lifeCycle(LifeCycle.ACTIVE);
                    if (pluginInstance != null) {
                        pluginInstance.onActive();
                    }
                }
            }, 0L, TimeUnit.SECONDS);
        }
    }

    public void onDisable() {
        TabooLibCommon.lifeCycle(LifeCycle.DISABLE);
        if (pluginInstance != null && !TabooLibCommon.isStopped()) {
            pluginInstance.onDisable();
        }
    }

    @NotNull
    public static BungeePlugin getInstance() {
        return instance;
    }

    @Nullable
    public static Plugin getPluginInstance() {
        return pluginInstance;
    }

    static {
        TabooLibCommon.lifeCycle(LifeCycle.CONST, Platform.BUNGEE);
        if (TabooLibCommon.isKotlinEnvironment()) {
            pluginInstance = Project1Kt.findImplementation(Plugin.class);
        }
    }
}

