/*
 * Decompiled with CFR 0.152.
 */
package me.arasple.mc.trchat.util.proxy.common;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import me.arasple.mc.trchat.util.proxy.common.Message;
import me.arasple.mc.trchat.util.proxy.common.MessagePacket;

public class MessageReader {
    private static final Cache<String, Message> queueMessages = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();

    public static Message read(byte[] packet) throws IOException {
        return MessageReader.read(new String(packet, StandardCharsets.UTF_8));
    }

    public static Message read(String packet) {
        JsonObject json = new JsonParser().parse(packet).getAsJsonObject();
        Message message = (Message)queueMessages.getIfPresent((Object)json.get("uid").getAsString());
        if (message == null) {
            message = new Message();
            queueMessages.put((Object)json.get("uid").getAsString(), (Object)message);
        }
        message.getMessages().add(new MessagePacket(UUID.fromString(json.get("uid").getAsString()), json.get("data").getAsString(), json.get("index").getAsInt(), json.get("total").getAsInt()));
        return message;
    }
}

