/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.animation;

import com.songoda.ultimatetimber.UltimateTimber;
import com.songoda.ultimatetimber.animation.TreeAnimationType;
import com.songoda.ultimatetimber.core.compatibility.CompatibleHand;
import com.songoda.ultimatetimber.core.compatibility.CompatibleMaterial;
import com.songoda.ultimatetimber.tree.DetectedTree;
import com.songoda.ultimatetimber.tree.FallingTreeBlock;
import com.songoda.ultimatetimber.tree.ITreeBlock;
import com.songoda.ultimatetimber.tree.TreeBlock;
import com.songoda.ultimatetimber.tree.TreeBlockSet;
import com.songoda.ultimatetimber.utils.BlockUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class TreeAnimation {
    protected final TreeAnimationType treeAnimationType;
    protected final DetectedTree detectedTree;
    protected final Player player;
    protected final boolean hasSilkTouch;
    protected TreeBlockSet<FallingBlock> fallingTreeBlocks;

    TreeAnimation(TreeAnimationType treeAnimationType, DetectedTree detectedTree, Player player) {
        this.treeAnimationType = treeAnimationType;
        this.detectedTree = detectedTree;
        this.player = player;
        ItemStack itemInHand = CompatibleHand.getHand((Object)CompatibleHand.MAIN_HAND).getItem(player);
        this.hasSilkTouch = itemInHand != null && itemInHand.hasItemMeta() && itemInHand.getItemMeta().hasEnchant(Enchantment.SILK_TOUCH);
        this.fallingTreeBlocks = new TreeBlockSet();
    }

    public abstract void playAnimation(Runnable var1);

    public TreeAnimationType getTreeAnimationType() {
        return this.treeAnimationType;
    }

    public DetectedTree getDetectedTree() {
        return this.detectedTree;
    }

    public Player getPlayer() {
        return this.player;
    }

    public boolean hasSilkTouch() {
        return this.hasSilkTouch;
    }

    public TreeBlockSet<FallingBlock> getFallingTreeBlocks() {
        return this.fallingTreeBlocks;
    }

    protected FallingTreeBlock convertToFallingBlock(TreeBlock treeBlock) {
        Location location = treeBlock.getLocation().clone().add(0.5, 0.0, 0.5);
        Block block = treeBlock.getBlock();
        CompatibleMaterial material = CompatibleMaterial.getMaterial(block);
        if (material.isAir()) {
            this.replaceBlock(treeBlock);
            return null;
        }
        FallingBlock fallingBlock = BlockUtils.spawnFallingBlock(location, material);
        BlockUtils.configureFallingBlock(fallingBlock);
        FallingTreeBlock fallingTreeBlock = new FallingTreeBlock(fallingBlock, treeBlock.getTreeBlockType());
        this.replaceBlock(treeBlock);
        return fallingTreeBlock;
    }

    public void replaceBlock(TreeBlock treeBlock) {
        treeBlock.getBlock().setType(Material.AIR);
        UltimateTimber.getInstance().getSaplingManager().replantSapling(this.detectedTree.getTreeDefinition(), treeBlock);
    }

    public void removeFallingBlock(FallingBlock fallingBlock) {
        for (ITreeBlock<FallingBlock> fallingTreeBlock : this.fallingTreeBlocks.getAllTreeBlocks()) {
            if (!fallingTreeBlock.getBlock().equals(fallingBlock)) continue;
            this.fallingTreeBlocks.remove(fallingTreeBlock);
            return;
        }
    }
}

