/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.animation;

import com.songoda.ultimatetimber.UltimateTimber;
import com.songoda.ultimatetimber.animation.TreeAnimation;
import com.songoda.ultimatetimber.animation.TreeAnimationType;
import com.songoda.ultimatetimber.core.compatibility.CompatibleMaterial;
import com.songoda.ultimatetimber.manager.ConfigurationManager;
import com.songoda.ultimatetimber.manager.TreeDefinitionManager;
import com.songoda.ultimatetimber.tree.DetectedTree;
import com.songoda.ultimatetimber.tree.ITreeBlock;
import com.songoda.ultimatetimber.tree.TreeBlock;
import com.songoda.ultimatetimber.tree.TreeBlockType;
import com.songoda.ultimatetimber.tree.TreeDefinition;
import com.songoda.ultimatetimber.utils.ParticleUtils;
import com.songoda.ultimatetimber.utils.SoundUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.bukkit.block.Block;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class TreeAnimationDisintegrate
extends TreeAnimation {
    public TreeAnimationDisintegrate(DetectedTree detectedTree, Player player) {
        super(TreeAnimationType.DISINTEGRATE, detectedTree, player);
    }

    @Override
    public void playAnimation(final Runnable whenFinished) {
        UltimateTimber ultimateTimber = UltimateTimber.getInstance();
        final TreeDefinitionManager treeDefinitionManager = ultimateTimber.getTreeDefinitionManager();
        final boolean useCustomSound = ConfigurationManager.Setting.USE_CUSTOM_SOUNDS.getBoolean();
        final boolean useCustomParticles = ConfigurationManager.Setting.USE_CUSTOM_PARTICLES.getBoolean();
        final ArrayList<ITreeBlock<Block>> orderedLogBlocks = new ArrayList<ITreeBlock<Block>>(this.detectedTree.getDetectedTreeBlocks().getLogBlocks());
        orderedLogBlocks.sort(Comparator.comparingInt(x -> x.getLocation().getBlockY()));
        final ArrayList<ITreeBlock<Block>> leafBlocks = new ArrayList<ITreeBlock<Block>>(this.detectedTree.getDetectedTreeBlocks().getLeafBlocks());
        Collections.shuffle(leafBlocks);
        final Player p = this.player;
        final TreeDefinition td = this.detectedTree.getTreeDefinition();
        final boolean hst = this.hasSilkTouch;
        new BukkitRunnable(){

            public void run() {
                Object treeBlock;
                ArrayList<Object> toDestroy = new ArrayList<Object>();
                if (!orderedLogBlocks.isEmpty()) {
                    treeBlock = (ITreeBlock)orderedLogBlocks.remove(0);
                    toDestroy.add(treeBlock);
                } else if (!leafBlocks.isEmpty()) {
                    treeBlock = (ITreeBlock)leafBlocks.remove(0);
                    toDestroy.add(treeBlock);
                    if (!leafBlocks.isEmpty()) {
                        treeBlock = (ITreeBlock)leafBlocks.remove(0);
                        toDestroy.add(treeBlock);
                    }
                }
                for (ITreeBlock iTreeBlock : TreeAnimationDisintegrate.this.fallingTreeBlocks.getAllTreeBlocks()) {
                    FallingBlock fallingBlock = (FallingBlock)iTreeBlock.getBlock();
                    fallingBlock.setVelocity(fallingBlock.getVelocity().clone().subtract(new Vector(0.0, 0.05, 0.0)));
                }
                if (!toDestroy.isEmpty()) {
                    ITreeBlock first = (ITreeBlock)toDestroy.get(0);
                    if (useCustomSound) {
                        SoundUtils.playLandingSound(first);
                    }
                    for (ITreeBlock iTreeBlock : toDestroy) {
                        if (!iTreeBlock.getTreeBlockType().equals((Object)TreeBlockType.LOG) ? iTreeBlock.getTreeBlockType().equals((Object)TreeBlockType.LEAF) && td.getLeafMaterial().stream().noneMatch(x -> x.equals((Object)CompatibleMaterial.getMaterial((Block)treeBlock2.getBlock()))) : td.getLogMaterial().stream().noneMatch(x -> x.equals((Object)CompatibleMaterial.getMaterial((Block)treeBlock2.getBlock())))) continue;
                        if (useCustomParticles) {
                            ParticleUtils.playFallingParticles(iTreeBlock);
                        }
                        treeDefinitionManager.dropTreeLoot(td, iTreeBlock, p, hst, false);
                        TreeAnimationDisintegrate.this.replaceBlock((TreeBlock)iTreeBlock);
                    }
                } else {
                    this.cancel();
                    whenFinished.run();
                }
            }
        }.runTaskTimer((Plugin)ultimateTimber, 0L, 1L);
    }
}

