/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.compatibility;

import com.songoda.ultimatetimber.core.third_party.org.apache.commons.lang3.ArrayUtils;
import org.bukkit.Bukkit;

public enum ServerVersion {
    UNKNOWN,
    V1_7,
    V1_8,
    V1_9,
    V1_10,
    V1_11,
    V1_12,
    V1_13,
    V1_14,
    V1_15,
    V1_16,
    V1_17,
    V1_18,
    V1_19,
    V1_20,
    V1_21;

    private static final String serverPackagePath;
    private static final String serverPackageVersion;
    private static final String serverReleaseVersion;
    private static final ServerVersion serverVersion;
    private static final boolean isMocked;

    private static ServerVersion getVersion() {
        for (ServerVersion version : ServerVersion.values()) {
            if (!serverPackageVersion.toUpperCase().startsWith(version.name())) continue;
            return version;
        }
        return UNKNOWN;
    }

    public boolean isLessThan(ServerVersion other) {
        return this.ordinal() < other.ordinal();
    }

    public boolean isAtOrBelow(ServerVersion other) {
        return this.ordinal() <= other.ordinal();
    }

    public boolean isGreaterThan(ServerVersion other) {
        return this.ordinal() > other.ordinal();
    }

    public boolean isAtLeast(ServerVersion other) {
        return this.ordinal() >= other.ordinal();
    }

    public static String getServerVersionString() {
        return serverPackageVersion;
    }

    public static String getVersionReleaseNumber() {
        return serverReleaseVersion;
    }

    public static ServerVersion getServerVersion() {
        return serverVersion;
    }

    public static boolean isServerVersion(ServerVersion version) {
        return serverVersion == version;
    }

    public static boolean isServerVersion(ServerVersion ... versions) {
        return ArrayUtils.contains((Object[])versions, (Object)serverVersion);
    }

    public static boolean isServerVersionAbove(ServerVersion version) {
        return serverVersion.ordinal() > version.ordinal();
    }

    public static boolean isServerVersionAtLeast(ServerVersion version) {
        return serverVersion.ordinal() >= version.ordinal();
    }

    public static boolean isServerVersionAtOrBelow(ServerVersion version) {
        return serverVersion.ordinal() <= version.ordinal();
    }

    public static boolean isServerVersionBelow(ServerVersion version) {
        return serverVersion.ordinal() < version.ordinal();
    }

    static {
        String srvPackage = Bukkit.getServer().getClass().getPackage().getName();
        isMocked = srvPackage.equals("be.seeseemelk.mockbukkit");
        if (isMocked) {
            String packageVersionShard = "v" + Bukkit.getServer().getBukkitVersion().replace('.', '_') + "_R0";
            serverPackagePath = "org.bukkit.craftbukkit." + packageVersionShard;
            serverPackageVersion = packageVersionShard;
            serverReleaseVersion = "0";
        } else {
            serverPackagePath = srvPackage;
            serverPackageVersion = serverPackagePath.substring(serverPackagePath.lastIndexOf(46) + 1);
            serverReleaseVersion = serverPackageVersion.indexOf(82) != -1 ? serverPackageVersion.substring(serverPackageVersion.indexOf(82) + 1) : "";
        }
        serverVersion = ServerVersion.getVersion();
    }
}

