/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.configuration.editor;

import com.songoda.ultimatetimber.core.compatibility.CompatibleMaterial;
import com.songoda.ultimatetimber.core.configuration.Config;
import com.songoda.ultimatetimber.core.configuration.editor.ConfigEditorListEditorGui;
import com.songoda.ultimatetimber.core.gui.Gui;
import com.songoda.ultimatetimber.core.gui.GuiUtils;
import com.songoda.ultimatetimber.core.gui.SimplePagedGui;
import com.songoda.ultimatetimber.core.gui.events.GuiClickEvent;
import com.songoda.ultimatetimber.core.input.ChatPrompt;
import com.songoda.ultimatetimber.core.utils.ItemUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigEditorGui
extends SimplePagedGui {
    final JavaPlugin plugin;
    final String file;
    final MemoryConfiguration config;
    final ConfigurationSection node;
    final Player player;
    Method configSection_getCommentString = null;
    boolean edits = false;
    List<String> sections = new ArrayList<String>();
    List<String> settings = new ArrayList<String>();

    protected ConfigEditorGui(Player player, JavaPlugin plugin, Gui parent, String file, MemoryConfiguration config) {
        this(player, plugin, parent, file, config, (ConfigurationSection)config);
    }

    protected ConfigEditorGui(Player player, JavaPlugin plugin, Gui parent, String file, MemoryConfiguration config, ConfigurationSection node) {
        super(parent);
        this.player = player;
        this.plugin = plugin;
        this.file = file;
        this.config = config;
        this.node = node;
        this.blankItem = GuiUtils.getBorderItem(CompatibleMaterial.LIGHT_GRAY_STAINED_GLASS_PANE);
        if (!(parent instanceof ConfigEditorGui)) {
            this.setOnClose(gui -> this.save());
        } else {
            this.setOnClose(gui -> ((ConfigEditorGui)parent).edits |= this.edits);
        }
        try {
            this.configSection_getCommentString = node.getClass().getDeclaredMethod("getCommentString", String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setTitle(ChatColor.DARK_BLUE + file);
        this.setUseHeader(true);
        this.headerBackItem = this.footerBackItem = GuiUtils.getBorderItem(CompatibleMaterial.GRAY_STAINED_GLASS_PANE.getItem());
        String path = node.getCurrentPath();
        this.setItem(4, this.configItem(CompatibleMaterial.FILLED_MAP, !path.isEmpty() ? path : file, (ConfigurationSection)config, !path.isEmpty() ? path : null, ChatColor.BLACK.toString()));
        this.setButton(8, GuiUtils.createButtonItem(CompatibleMaterial.OAK_DOOR, "Exit", new String[0]), event -> event.player.closeInventory());
        for (String key : node.getKeys(false)) {
            if (node.isConfigurationSection(key)) {
                this.sections.add(key);
                continue;
            }
            this.settings.add(key);
        }
        int index = 9;
        for (String sectionKey : this.sections) {
            this.setButton(index++, this.configItem(CompatibleMaterial.WRITABLE_BOOK, ChatColor.YELLOW + sectionKey, node, sectionKey, "Click to open this section"), event -> event.manager.showGUI(event.player, new ConfigEditorGui(player, plugin, this, file, config, node.getConfigurationSection(sectionKey))));
        }
        for (String settingKey : this.settings) {
            Object val = node.get(settingKey);
            if (val == null) continue;
            if (val instanceof Boolean) {
                this.setButton(index, this.configItem(CompatibleMaterial.LEVER, ChatColor.YELLOW + settingKey, node, settingKey, String.valueOf(val), "Click to toggle this setting"), event -> this.toggle(event.slot, settingKey));
                if (((Boolean)val).booleanValue()) {
                    this.highlightItem(index);
                }
            } else if (this.isNumber(val)) {
                this.setButton(index, this.configItem(CompatibleMaterial.CLOCK, ChatColor.YELLOW + settingKey, node, settingKey, String.valueOf(val), "Click to edit this setting"), event -> {
                    event.gui.exit();
                    ChatPrompt.showPrompt((Plugin)plugin, event.player, "Enter a new number value for " + settingKey + ":", response -> {
                        if (!this.setNumber(event.slot, settingKey, response.getMessage().trim())) {
                            event.player.sendMessage(ChatColor.RED + "Error: \"" + response.getMessage().trim() + "\" is not a number!");
                        }
                    }).setOnClose(() -> event.manager.showGUI(event.player, this)).setOnCancel(() -> {
                        event.player.sendMessage(ChatColor.RED + "Edit canceled");
                        event.manager.showGUI(event.player, this);
                    });
                });
            } else if (this.isMaterial(val)) {
                this.setButton(index, this.configItem(CompatibleMaterial.STONE, ChatColor.YELLOW + settingKey, node, settingKey, val.toString(), "Click to edit this setting"), event -> {
                    SimplePagedGui paged = new SimplePagedGui(this);
                    paged.setTitle(ChatColor.BLUE + settingKey);
                    paged.setHeaderBackItem(this.headerBackItem).setFooterBackItem(this.footerBackItem).setDefaultItem(this.blankItem);
                    paged.setItem(4, this.configItem(CompatibleMaterial.FILLED_MAP, settingKey, node, settingKey, "Choose an item to change this value to"));
                    int i = 9;
                    for (CompatibleMaterial mat : CompatibleMaterial.getAllValidItemMaterials()) {
                        try {
                            ItemStack buttonItem = GuiUtils.createButtonItem(mat, mat.name(), new String[0]);
                            if (!buttonItem.getType().isItem()) continue;
                            paged.setButton(i++, buttonItem, ClickType.LEFT, (GuiClickEvent matEvent) -> {
                                this.setMaterial(event.slot, settingKey, matEvent.clickedItem);
                                matEvent.player.closeInventory();
                            });
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                    event.manager.showGUI(event.player, paged);
                });
            } else if (val instanceof String) {
                this.setButton(index, this.configItem(CompatibleMaterial.STRING, ChatColor.YELLOW + settingKey, node, settingKey, val.toString(), "Click to edit this setting"), event -> {
                    event.gui.exit();
                    ChatPrompt.showPrompt((Plugin)plugin, event.player, "Enter a new value for " + settingKey + ":", response -> {
                        node.set(settingKey, (Object)response.getMessage().trim());
                        this.updateValue(event.slot, settingKey);
                    }).setOnClose(() -> event.manager.showGUI(event.player, this)).setOnCancel(() -> {
                        event.player.sendMessage(ChatColor.RED + "Edit canceled");
                        event.manager.showGUI(event.player, this);
                    });
                });
            } else if (val instanceof List) {
                this.setButton(index, this.configItem(CompatibleMaterial.WRITABLE_BOOK, ChatColor.YELLOW + settingKey, node, settingKey, String.format("(%d values)", ((List)val).size()), "Click to edit this setting"), event -> event.manager.showGUI(event.player, new ConfigEditorListEditorGui(this, settingKey, (List)val).setOnClose(gui -> {
                    if (((ConfigEditorListEditorGui)gui.gui).saveChanges) {
                        this.setList(event.slot, settingKey, ((ConfigEditorListEditorGui)gui.gui).values);
                    }
                })));
            }
            ++index;
        }
    }

    public ConfigurationSection getCurrentNode() {
        return this.node;
    }

    protected void updateValue(int clickCell, String path) {
        ItemStack item = this.inventory.getItem(clickCell);
        if (item == null || item == AIR) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        Object val = this.node.get(path);
        if (meta != null && val != null) {
            String valStr = val instanceof List ? String.format("(%d values)", ((List)val).size()) : val.toString();
            List lore = meta.getLore();
            if (lore == null || lore.isEmpty()) {
                meta.setLore(Arrays.asList(valStr));
            } else {
                lore.set(0, valStr);
                meta.setLore(lore);
            }
            item.setItemMeta(meta);
            this.setItem(clickCell, item);
        }
        this.edits = true;
    }

    void toggle(int clickCell, String path) {
        boolean val = !this.node.getBoolean(path);
        this.node.set(path, (Object)val);
        if (val) {
            this.setItem(clickCell, ItemUtils.addGlow(this.inventory.getItem(clickCell)));
        } else {
            this.setItem(clickCell, ItemUtils.removeGlow(this.inventory.getItem(clickCell)));
        }
        this.updateValue(clickCell, path);
    }

    boolean setNumber(int clickCell, String path, String input) {
        try {
            if (this.node.isInt(path)) {
                this.node.set(path, (Object)Integer.parseInt(input));
            } else if (this.node.isDouble(path)) {
                this.node.set(path, (Object)Double.parseDouble(input));
            } else if (this.node.isLong(path)) {
                this.node.set(path, (Object)Long.parseLong(input));
            }
            this.updateValue(clickCell, path);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    void setMaterial(int clickCell, String path, ItemStack item) {
        CompatibleMaterial mat = CompatibleMaterial.getMaterial(item);
        if (mat == null) {
            this.node.set(path, (Object)CompatibleMaterial.STONE.name());
        } else {
            this.node.set(path, (Object)mat.name());
        }
        this.updateValue(clickCell, path);
    }

    void setList(int clickCell, String path, List<String> list) {
        this.node.set(path, list);
        this.updateValue(clickCell, path);
    }

    void save() {
        if (!this.edits) {
            return;
        }
        if (this.config instanceof FileConfiguration) {
            try {
                ((FileConfiguration)this.config).save(new File(this.plugin.getDataFolder(), this.file));
            }
            catch (IOException ex) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to save config changes to " + this.file, ex);
                return;
            }
        } else if (this.config instanceof Config) {
            ((Config)this.config).save();
        } else {
            this.player.sendMessage(ChatColor.RED + "Unknown configuration type '" + this.config.getClass().getName() + "' - Please report this error!");
            this.plugin.getLogger().log(Level.WARNING, "Unknown configuration type '" + this.config.getClass().getName() + "' - Please report this error!");
            return;
        }
        this.plugin.reloadConfig();
        this.player.sendMessage(ChatColor.GREEN + "Config " + this.file + " saved!");
    }

    private boolean isNumber(Object value) {
        return value instanceof Long || value instanceof Integer || value instanceof Float || value instanceof Double;
    }

    private boolean isMaterial(Object value) {
        CompatibleMaterial m;
        return value instanceof String && value.toString().equals(value.toString().toUpperCase()) && (m = CompatibleMaterial.getMaterial(value.toString())) != null && m.isValidItem();
    }

    protected ItemStack configItem(CompatibleMaterial type, String name, ConfigurationSection node, String path, String def) {
        String[] info = null;
        if (this.configSection_getCommentString != null) {
            try {
                Object comment = this.configSection_getCommentString.invoke((Object)node, path);
                if (comment != null) {
                    info = comment.toString().split("\n");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return GuiUtils.createButtonItem(type, name, info != null ? info : (def != null ? def.split("\n") : null));
    }

    protected ItemStack configItem(CompatibleMaterial type, String name, ConfigurationSection node, String path, String value, String def) {
        if (value == null) {
            value = "";
        }
        String[] info = null;
        if (this.configSection_getCommentString != null) {
            try {
                Object comment = this.configSection_getCommentString.invoke((Object)node, path);
                if (comment != null) {
                    info = (value + "\n" + comment).split("\n");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return GuiUtils.createButtonItem(type, name, info != null ? info : (def != null ? (value + "\n" + def).split("\n") : null));
    }
}

