/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.core;

import com.songoda.ultimatetimber.core.compatibility.CompatibleMaterial;
import com.songoda.ultimatetimber.core.core.PluginInfoModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.simple.JSONObject;

public final class PluginInfo {
    protected final JavaPlugin javaPlugin;
    protected final int songodaId;
    protected final String coreIcon;
    protected final String coreLibraryVersion;
    protected final CompatibleMaterial icon;
    private final List<PluginInfoModule> modules = new ArrayList<PluginInfoModule>();
    private boolean hasUpdate = false;
    private String latestVersion;
    private String notification;
    private String changeLog;
    private String marketplaceLink;
    private JSONObject json;

    public PluginInfo(JavaPlugin javaPlugin, int songodaId, String icon, String coreLibraryVersion) {
        this.javaPlugin = javaPlugin;
        this.songodaId = songodaId;
        this.coreIcon = icon;
        this.icon = CompatibleMaterial.getMaterial(icon);
        this.coreLibraryVersion = coreLibraryVersion;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public void setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
        this.hasUpdate = latestVersion != null && !latestVersion.isEmpty() && !this.javaPlugin.getDescription().getVersion().equalsIgnoreCase(latestVersion);
    }

    public String getNotification() {
        return this.notification;
    }

    public void setNotification(String notification) {
        this.notification = notification;
    }

    public boolean hasUpdate() {
        return this.hasUpdate;
    }

    public void setHasUpdate(boolean hasUpdate) {
        this.hasUpdate = hasUpdate;
    }

    public String getChangeLog() {
        return this.changeLog;
    }

    public void setChangeLog(String changeLog) {
        this.changeLog = changeLog;
    }

    public String getMarketplaceLink() {
        return this.marketplaceLink;
    }

    public void setMarketplaceLink(String marketplaceLink) {
        this.marketplaceLink = marketplaceLink;
    }

    public JSONObject getJson() {
        return this.json;
    }

    public void setJson(JSONObject json) {
        this.json = json;
    }

    public PluginInfoModule addModule(PluginInfoModule module) {
        this.modules.add(module);
        return module;
    }

    public List<PluginInfoModule> getModules() {
        return Collections.unmodifiableList(this.modules);
    }

    public JavaPlugin getJavaPlugin() {
        return this.javaPlugin;
    }

    public int getSongodaId() {
        return this.songodaId;
    }

    public String getCoreIcon() {
        return this.coreIcon;
    }

    public String getCoreLibraryVersion() {
        return this.coreLibraryVersion;
    }
}

