/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.core;

import com.songoda.ultimatetimber.core.SongodaCore;
import com.songoda.ultimatetimber.core.commands.AbstractCommand;
import com.songoda.ultimatetimber.core.compatibility.ClassMapping;
import com.songoda.ultimatetimber.core.compatibility.ServerProject;
import com.songoda.ultimatetimber.core.compatibility.ServerVersion;
import com.songoda.ultimatetimber.core.core.PluginInfo;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public class SongodaCoreDiagCommand
extends AbstractCommand {
    private final DecimalFormat format = new DecimalFormat("##.##");
    private Object serverInstance;
    private Field tpsField;

    public SongodaCoreDiagCommand() {
        super(AbstractCommand.CommandType.CONSOLE_OK, "diag");
        try {
            this.serverInstance = ClassMapping.MINECRAFT_SERVER.getClazz().getMethod("getServer", new Class[0]).invoke(null, new Object[0]);
            this.tpsField = this.serverInstance.getClass().getField("recentTps");
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected AbstractCommand.ReturnType runCommand(CommandSender sender, String ... args) {
        sender.sendMessage("");
        sender.sendMessage("Songoda Diagnostics Information");
        sender.sendMessage("");
        sender.sendMessage("Plugins:");
        for (PluginInfo plugin : SongodaCore.getPlugins()) {
            sender.sendMessage(plugin.getJavaPlugin().getName() + " (" + plugin.getJavaPlugin().getDescription().getVersion() + " Core " + plugin.getCoreLibraryVersion() + ")");
        }
        sender.sendMessage("");
        sender.sendMessage("Server Version: " + Bukkit.getVersion());
        sender.sendMessage("NMS: " + (Object)((Object)ServerProject.getServerVersion()) + " " + ServerVersion.getServerVersionString());
        sender.sendMessage("Operating System: " + System.getProperty("os.name"));
        sender.sendMessage("Allocated Memory: " + this.format.format(Runtime.getRuntime().maxMemory() / 0x100000L) + "Mb");
        sender.sendMessage("Online Players: " + Bukkit.getOnlinePlayers().size());
        if (this.tpsField != null) {
            try {
                double[] tps = (double[])this.tpsField.get(this.serverInstance);
                sender.sendMessage("TPS from last 1m, 5m, 15m: " + this.format.format(tps[0]) + ", " + this.format.format(tps[1]) + ", " + this.format.format(tps[2]));
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
        return AbstractCommand.ReturnType.SUCCESS;
    }

    @Override
    protected List<String> onTab(CommandSender sender, String ... args) {
        return null;
    }

    @Override
    public String getPermissionNode() {
        return "songoda.admin";
    }

    @Override
    public String getSyntax() {
        return "/songoda diag";
    }

    @Override
    public String getDescription() {
        return "Display diagnostics information.";
    }
}

