/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.core.gui;

import com.songoda.ultimatetimber.core.compatibility.CompatibleMaterial;
import com.songoda.ultimatetimber.core.compatibility.CompatibleSound;
import com.songoda.ultimatetimber.core.compatibility.ServerVersion;
import com.songoda.ultimatetimber.core.gui.GuiHolder;
import com.songoda.ultimatetimber.core.gui.GuiManager;
import com.songoda.ultimatetimber.core.gui.GuiType;
import com.songoda.ultimatetimber.core.gui.GuiUtils;
import com.songoda.ultimatetimber.core.gui.events.GuiClickEvent;
import com.songoda.ultimatetimber.core.gui.events.GuiCloseEvent;
import com.songoda.ultimatetimber.core.gui.events.GuiDropItemEvent;
import com.songoda.ultimatetimber.core.gui.events.GuiOpenEvent;
import com.songoda.ultimatetimber.core.gui.events.GuiPageEvent;
import com.songoda.ultimatetimber.core.gui.methods.Clickable;
import com.songoda.ultimatetimber.core.gui.methods.Closable;
import com.songoda.ultimatetimber.core.gui.methods.Droppable;
import com.songoda.ultimatetimber.core.gui.methods.Openable;
import com.songoda.ultimatetimber.core.gui.methods.Pagable;
import com.songoda.ultimatetimber.core.utils.ItemUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Gui {
    protected Inventory inventory;
    protected String title;
    protected GuiType inventoryType = GuiType.STANDARD;
    protected int rows;
    protected int page = 1;
    protected int pages = 1;
    protected boolean acceptsItems = false;
    protected boolean allowDropItems = true;
    protected boolean allowClose = true;
    protected final Map<Integer, Boolean> unlockedCells = new HashMap<Integer, Boolean>();
    protected final Map<Integer, ItemStack> cellItems = new HashMap<Integer, ItemStack>();
    protected final Map<Integer, Map<ClickType, Clickable>> conditionalButtons = new HashMap<Integer, Map<ClickType, Clickable>>();
    protected ItemStack blankItem = GuiUtils.getBorderGlassItem();
    protected int nextPageIndex = -1;
    protected int prevPageIndex = -1;
    protected ItemStack nextPageItem;
    protected ItemStack prevPageItem;
    protected ItemStack nextPage;
    protected ItemStack prevPage;
    protected Gui parent = null;
    protected static ItemStack AIR = new ItemStack(Material.AIR);
    protected GuiManager guiManager;
    protected boolean open = false;
    protected Clickable defaultClicker = null;
    protected Clickable privateDefaultClicker = null;
    protected Openable opener = null;
    protected Closable closer = null;
    protected Droppable dropper = null;
    protected Pagable pager = null;
    protected CompatibleSound defaultSound = CompatibleSound.UI_BUTTON_CLICK;

    public Gui() {
        this.rows = 3;
    }

    public Gui(@NotNull GuiType type) {
        this.inventoryType = type;
        switch (type) {
            case HOPPER: 
            case DISPENSER: {
                this.rows = 1;
                break;
            }
            default: {
                this.rows = 3;
            }
        }
    }

    public Gui(@Nullable Gui parent) {
        this.parent = parent;
    }

    public Gui(int rows) {
        this.rows = Math.max(1, Math.min(6, rows));
    }

    public Gui(int rows, @Nullable Gui parent) {
        this.parent = parent;
        this.rows = Math.max(1, Math.min(6, rows));
    }

    @NotNull
    public List<Player> getPlayers() {
        if (this.inventory == null) {
            return Collections.emptyList();
        }
        return this.inventory.getViewers().stream().filter(Player.class::isInstance).map(Player.class::cast).collect(Collectors.toList());
    }

    public boolean isOpen() {
        if (this.inventory != null && this.inventory.getViewers().isEmpty()) {
            this.open = false;
        }
        return this.open;
    }

    public boolean getAcceptsItems() {
        return this.acceptsItems;
    }

    public Gui setAcceptsItems(boolean acceptsItems) {
        this.acceptsItems = acceptsItems;
        return this;
    }

    public boolean getAllowDrops() {
        return this.allowDropItems;
    }

    public Gui setAllowDrops(boolean allow) {
        this.allowDropItems = allow;
        return this;
    }

    public boolean getAllowClose() {
        return this.allowClose;
    }

    public Gui setAllowClose(boolean allow) {
        this.allowClose = allow;
        return this;
    }

    public void exit() {
        this.allowClose = true;
        this.open = false;
        this.inventory.getViewers().stream().filter(Player.class::isInstance).map(Player.class::cast).collect(Collectors.toList()).forEach(HumanEntity::closeInventory);
    }

    public void close() {
        this.allowClose = true;
        this.inventory.getViewers().stream().filter(Player.class::isInstance).map(Player.class::cast).collect(Collectors.toList()).forEach(HumanEntity::closeInventory);
    }

    @NotNull
    public GuiType getType() {
        return this.inventoryType;
    }

    @NotNull
    public Gui setUnlocked(int cell) {
        this.unlockedCells.put(cell, true);
        return this;
    }

    @NotNull
    public Gui setUnlocked(int row, int col) {
        int cell = col + row * this.inventoryType.columns;
        this.unlockedCells.put(cell, true);
        return this;
    }

    @NotNull
    public Gui setUnlockedRange(int cellFirst, int cellLast) {
        for (int cell = cellFirst; cell <= cellLast; ++cell) {
            this.unlockedCells.put(cell, true);
        }
        return this;
    }

    @NotNull
    public Gui setUnlockedRange(int cellFirst, int cellLast, boolean open) {
        for (int cell = cellFirst; cell <= cellLast; ++cell) {
            this.unlockedCells.put(cell, open);
        }
        return this;
    }

    @NotNull
    public Gui setUnlockedRange(int cellRowFirst, int cellColFirst, int cellRowLast, int cellColLast) {
        int last = cellColLast + cellRowLast * this.inventoryType.columns;
        for (int cell = cellColFirst + cellRowFirst * this.inventoryType.columns; cell <= last; ++cell) {
            this.unlockedCells.put(cell, true);
        }
        return this;
    }

    @NotNull
    public Gui setUnlockedRange(int cellRowFirst, int cellColFirst, int cellRowLast, int cellColLast, boolean open) {
        int last = cellColLast + cellRowLast * this.inventoryType.columns;
        for (int cell = cellColFirst + cellRowFirst * this.inventoryType.columns; cell <= last; ++cell) {
            this.unlockedCells.put(cell, open);
        }
        return this;
    }

    @NotNull
    public Gui setUnlocked(int cell, boolean open) {
        this.unlockedCells.put(cell, open);
        return this;
    }

    @NotNull
    public Gui setUnlocked(int row, int col, boolean open) {
        int cell = col + row * this.inventoryType.columns;
        this.unlockedCells.put(cell, open);
        return this;
    }

    @NotNull
    public Gui setTitle(String title) {
        if (title == null) {
            title = "";
        }
        if (!title.equals(this.title)) {
            this.title = title;
            if (this.inventory != null) {
                List<Player> toUpdate = this.getPlayers();
                boolean isAllowClose = this.allowClose;
                this.exit();
                Inventory oldInv = this.inventory;
                this.createInventory();
                this.inventory.setContents(oldInv.getContents());
                toUpdate.forEach(player -> player.openInventory(this.inventory));
                this.allowClose = isAllowClose;
            }
        }
        return this;
    }

    public int getRows() {
        return this.rows;
    }

    @NotNull
    public Gui setRows(int rows) {
        switch (this.inventoryType) {
            case HOPPER: 
            case DISPENSER: {
                break;
            }
            default: {
                this.rows = Math.max(1, Math.min(6, rows));
            }
        }
        return this;
    }

    @NotNull
    public Gui setDefaultAction(@Nullable Clickable action) {
        this.defaultClicker = action;
        return this;
    }

    @NotNull
    protected Gui setPrivateDefaultAction(@Nullable Clickable action) {
        this.privateDefaultClicker = action;
        return this;
    }

    @NotNull
    public Gui setDefaultItem(@Nullable ItemStack item) {
        this.blankItem = item;
        return this;
    }

    @Nullable
    public ItemStack getDefaultItem() {
        return this.blankItem;
    }

    @Nullable
    public ItemStack getItem(int cell) {
        if (this.inventory != null && this.unlockedCells.getOrDefault(cell, false).booleanValue()) {
            return this.inventory.getItem(cell);
        }
        return this.cellItems.get(cell);
    }

    @Nullable
    public ItemStack getItem(int row, int col) {
        int cell = col + row * this.inventoryType.columns;
        if (this.inventory != null && this.unlockedCells.getOrDefault(cell, false).booleanValue()) {
            return this.inventory.getItem(cell);
        }
        return this.cellItems.get(cell);
    }

    @NotNull
    public Gui setItem(int cell, @Nullable ItemStack item) {
        this.cellItems.put(cell, item);
        if (this.inventory != null && cell >= 0 && cell < this.inventory.getSize()) {
            this.inventory.setItem(cell, item);
        }
        return this;
    }

    @NotNull
    public Gui setItem(int row, int col, @Nullable ItemStack item) {
        int cell = col + row * this.inventoryType.columns;
        return this.setItem(cell, item);
    }

    @NotNull
    public Gui mirrorFill(int row, int col, boolean mirrorRow, boolean mirrorCol, ItemStack item) {
        this.setItem(row, col, item);
        if (mirrorRow) {
            this.setItem(this.rows - row - 1, col, item);
        }
        if (mirrorCol) {
            this.setItem(row, 8 - col, item);
        }
        if (mirrorRow && mirrorCol) {
            this.setItem(this.rows - row - 1, 8 - col, item);
        }
        return this;
    }

    @NotNull
    public Gui highlightItem(int cell) {
        ItemStack item = this.cellItems.get(cell);
        if (item != null && item.getType() != Material.AIR) {
            this.setItem(cell, ItemUtils.addGlow(item));
        }
        return this;
    }

    @NotNull
    public Gui highlightItem(int row, int col) {
        int cell = col + row * this.inventoryType.columns;
        return this.highlightItem(cell);
    }

    @NotNull
    public Gui removeHighlight(int cell) {
        ItemStack item = this.cellItems.get(cell);
        if (item != null && item.getType() != Material.AIR) {
            this.setItem(cell, ItemUtils.removeGlow(item));
        }
        return this;
    }

    @NotNull
    public Gui removeHighlight(int row, int col) {
        int cell = col + row * this.inventoryType.columns;
        return this.removeHighlight(cell);
    }

    @NotNull
    public Gui updateItemLore(int row, int col, String ... lore) {
        return this.updateItemLore(col + row * this.inventoryType.columns, lore);
    }

    @NotNull
    public Gui updateItemLore(int cell, String ... lore) {
        ItemStack item = this.cellItems.get(cell);
        if (item != null && item.getType() != Material.AIR) {
            this.setItem(cell, GuiUtils.updateItemLore(item, lore));
        }
        return this;
    }

    @NotNull
    public Gui updateItemLore(int row, int col, @Nullable List<String> lore) {
        return this.updateItemLore(col + row * this.inventoryType.columns, lore);
    }

    @NotNull
    public Gui updateItemLore(int cell, @Nullable List<String> lore) {
        ItemStack item = this.cellItems.get(cell);
        if (item != null && item.getType() != Material.AIR) {
            this.setItem(cell, GuiUtils.updateItemLore(item, lore));
        }
        return this;
    }

    @NotNull
    public Gui updateItemName(int row, int col, @Nullable String name) {
        return this.updateItemName(col + row * this.inventoryType.columns, name);
    }

    @NotNull
    public Gui updateItemName(int cell, @Nullable String name) {
        ItemStack item = this.cellItems.get(cell);
        if (item != null && item.getType() != Material.AIR) {
            this.setItem(cell, GuiUtils.updateItemName(item, name));
        }
        return this;
    }

    @NotNull
    public Gui updateItem(int row, int col, @Nullable String name, String ... lore) {
        return this.updateItem(col + row * this.inventoryType.columns, name, lore);
    }

    @NotNull
    public Gui updateItem(int cell, @Nullable String name, String ... lore) {
        return this.updateItem(cell, name, Arrays.asList(lore));
    }

    @NotNull
    public Gui updateItem(int row, int col, @Nullable String name, @Nullable List<String> lore) {
        return this.updateItem(col + row * this.inventoryType.columns, name, lore);
    }

    @NotNull
    public Gui updateItem(int cell, @NotNull String name, @Nullable List<String> lore) {
        ItemStack item = this.cellItems.get(cell);
        if (item != null && item.getType() != Material.AIR) {
            this.setItem(cell, GuiUtils.updateItem(item, name, lore));
        }
        return this;
    }

    @NotNull
    public Gui updateItem(int row, int col, @NotNull ItemStack itemTo, @Nullable String title, String ... lore) {
        return this.updateItem(col + row * this.inventoryType.columns, itemTo, title, lore);
    }

    @NotNull
    public Gui updateItem(int cell, @NotNull ItemStack itemTo, @Nullable String title, String ... lore) {
        ItemStack item = this.cellItems.get(cell);
        if (item != null && item.getType() != Material.AIR) {
            this.setItem(cell, GuiUtils.updateItem(item, itemTo, title, lore));
        }
        return this;
    }

    @NotNull
    public Gui updateItem(int row, int col, @NotNull CompatibleMaterial itemTo, @Nullable String title, String ... lore) {
        return this.updateItem(col + row * this.inventoryType.columns, itemTo, title, lore);
    }

    @NotNull
    public Gui updateItem(int cell, @NotNull CompatibleMaterial itemTo, @Nullable String title, String ... lore) {
        ItemStack item = this.cellItems.get(cell);
        if (item != null && item.getType() != Material.AIR) {
            this.setItem(cell, GuiUtils.updateItem(item, itemTo, title, lore));
        }
        return this;
    }

    @NotNull
    public Gui updateItem(int row, int col, @NotNull ItemStack itemTo, @Nullable String title, @Nullable List<String> lore) {
        return this.updateItem(col + row * this.inventoryType.columns, itemTo, title, lore);
    }

    @NotNull
    public Gui updateItem(int cell, @NotNull ItemStack itemTo, @Nullable String title, @Nullable List<String> lore) {
        ItemStack item = this.cellItems.get(cell);
        if (item != null && item.getType() != Material.AIR) {
            this.setItem(cell, GuiUtils.updateItem(item, itemTo, title, lore));
        }
        return this;
    }

    @NotNull
    public Gui updateItem(int row, int col, @NotNull CompatibleMaterial itemTo, @Nullable String title, @Nullable List<String> lore) {
        return this.updateItem(col + row * this.inventoryType.columns, itemTo, title, lore);
    }

    @NotNull
    public Gui updateItem(int cell, @NotNull CompatibleMaterial itemTo, @Nullable String title, @Nullable List<String> lore) {
        ItemStack item = this.cellItems.get(cell);
        if (item != null && item.getType() != Material.AIR) {
            this.setItem(cell, GuiUtils.updateItem(item, itemTo, title, lore));
        }
        return this;
    }

    @NotNull
    public Gui setAction(int cell, @Nullable Clickable action) {
        this.setConditional(cell, null, action);
        return this;
    }

    @NotNull
    public Gui setAction(int row, int col, @Nullable Clickable action) {
        this.setConditional(col + row * this.inventoryType.columns, null, action);
        return this;
    }

    @NotNull
    public Gui setAction(int cell, @Nullable ClickType type, @Nullable Clickable action) {
        this.setConditional(cell, type, action);
        return this;
    }

    @NotNull
    public Gui setAction(int row, int col, @Nullable ClickType type, @Nullable Clickable action) {
        this.setConditional(col + row * this.inventoryType.columns, type, action);
        return this;
    }

    @NotNull
    public Gui setActionForRange(int cellFirst, int cellLast, @Nullable Clickable action) {
        for (int cell = cellFirst; cell <= cellLast; ++cell) {
            this.setConditional(cell, null, action);
        }
        return this;
    }

    @NotNull
    public Gui setActionForRange(int cellRowFirst, int cellColFirst, int cellRowLast, int cellColLast, @Nullable Clickable action) {
        int last = cellColLast + cellRowLast * this.inventoryType.columns;
        for (int cell = cellColFirst + cellRowFirst * this.inventoryType.columns; cell <= last; ++cell) {
            this.setConditional(cell, null, action);
        }
        return this;
    }

    @NotNull
    public Gui setActionForRange(int cellFirst, int cellLast, @Nullable ClickType type, @Nullable Clickable action) {
        for (int cell = cellFirst; cell <= cellLast; ++cell) {
            this.setConditional(cell, type, action);
        }
        return this;
    }

    @NotNull
    public Gui setActionForRange(int cellRowFirst, int cellColFirst, int cellRowLast, int cellColLast, @Nullable ClickType type, @Nullable Clickable action) {
        int last = cellColLast + cellRowLast * this.inventoryType.columns;
        for (int cell = cellColFirst + cellRowFirst * this.inventoryType.columns; cell <= last; ++cell) {
            this.setConditional(cell, type, action);
        }
        return this;
    }

    @NotNull
    public Gui clearActions(int cell) {
        this.conditionalButtons.remove(cell);
        return this;
    }

    @NotNull
    public Gui clearActions(int row, int col) {
        return this.clearActions(col + row * this.inventoryType.columns);
    }

    @NotNull
    public Gui setButton(int cell, ItemStack item, @Nullable Clickable action) {
        this.setItem(cell, item);
        this.setConditional(cell, null, action);
        return this;
    }

    @NotNull
    public Gui setButton(int row, int col, @Nullable ItemStack item, @Nullable Clickable action) {
        int cell = col + row * this.inventoryType.columns;
        this.setItem(cell, item);
        this.setConditional(cell, null, action);
        return this;
    }

    @NotNull
    public Gui setButton(int cell, @Nullable ItemStack item, @Nullable ClickType type, @Nullable Clickable action) {
        this.setItem(cell, item);
        this.setConditional(cell, type, action);
        return this;
    }

    @NotNull
    public Gui setButton(int row, int col, @Nullable ItemStack item, @Nullable ClickType type, @Nullable Clickable action) {
        int cell = col + row * this.inventoryType.columns;
        this.setItem(cell, item);
        this.setConditional(cell, type, action);
        return this;
    }

    protected void setConditional(int cell, @Nullable ClickType type, @Nullable Clickable action) {
        Map conditionals = this.conditionalButtons.computeIfAbsent(cell, k -> new HashMap());
        conditionals.put(type, action);
    }

    @NotNull
    public Gui setOnOpen(@Nullable Openable action) {
        this.opener = action;
        return this;
    }

    @NotNull
    public Gui setOnClose(@Nullable Closable action) {
        this.closer = action;
        return this;
    }

    @NotNull
    public Gui setOnDrop(@Nullable Droppable action) {
        this.dropper = action;
        return this;
    }

    @NotNull
    public Gui setOnPage(@Nullable Pagable action) {
        this.pager = action;
        return this;
    }

    public Gui setNextPage(ItemStack item) {
        this.nextPage = item;
        return this;
    }

    public Gui setPrevPage(ItemStack item) {
        this.prevPage = item;
        return this;
    }

    public void reset() {
        if (this.inventory != null) {
            this.inventory.clear();
        }
        this.setActionForRange(0, 53, null);
        this.cellItems.clear();
        this.update();
    }

    @NotNull
    public Gui setNextPage(int cell, @NotNull ItemStack item) {
        this.nextPageItem = this.cellItems.get(cell);
        this.nextPageIndex = cell;
        this.nextPage = item;
        if (this.page < this.pages) {
            this.setButton(this.nextPageIndex, this.nextPage, ClickType.LEFT, (GuiClickEvent event) -> this.nextPage());
        }
        return this;
    }

    @NotNull
    public Gui setNextPage(int row, int col, @NotNull ItemStack item) {
        return this.setNextPage(col + row * this.inventoryType.columns, item);
    }

    @NotNull
    public Gui setPrevPage(int cell, @NotNull ItemStack item) {
        this.prevPageItem = this.cellItems.get(cell);
        this.prevPageIndex = cell;
        this.prevPage = item;
        if (this.page > 1) {
            this.setButton(this.prevPageIndex, this.prevPage, ClickType.LEFT, (GuiClickEvent event) -> this.prevPage());
        }
        return this;
    }

    @NotNull
    public Gui setPrevPage(int row, int col, @NotNull ItemStack item) {
        return this.setPrevPage(col + row * this.inventoryType.columns, item);
    }

    public void setPages(int pages) {
        this.pages = Math.max(1, pages);
        if (this.page > pages) {
            this.setPage(pages);
        }
    }

    public void setPage(int page) {
        int lastPage = this.page;
        this.page = Math.max(1, Math.min(this.pages, page));
        if (this.pager != null && this.page != lastPage) {
            this.pager.onPageChange(new GuiPageEvent(this, this.guiManager, lastPage, page));
            this.updatePageNavigation();
        }
    }

    public void changePage(int direction) {
        int lastPage = this.page;
        this.page = Math.max(1, Math.min(this.pages, this.page + direction));
        if (this.pager != null && this.page != lastPage) {
            this.pager.onPageChange(new GuiPageEvent(this, this.guiManager, lastPage, this.page));
            this.updatePageNavigation();
        }
    }

    public void nextPage() {
        if (this.page < this.pages) {
            int lastPage = this.page++;
            if (this.pager != null) {
                this.pager.onPageChange(new GuiPageEvent(this, this.guiManager, lastPage, this.page));
                this.updatePageNavigation();
            }
        }
    }

    public void prevPage() {
        if (this.page > 1) {
            int lastPage = this.page--;
            if (this.pager != null) {
                this.pager.onPageChange(new GuiPageEvent(this, this.guiManager, lastPage, this.page));
                this.updatePageNavigation();
            }
        }
    }

    protected void updatePageNavigation() {
        if (this.prevPage != null) {
            if (this.page > 1) {
                this.setButton(this.prevPageIndex, this.prevPage, ClickType.LEFT, (GuiClickEvent event) -> this.prevPage());
            } else {
                this.setItem(this.prevPageIndex, this.prevPageItem);
                this.clearActions(this.prevPageIndex);
            }
        }
        if (this.nextPage != null) {
            if (this.pages > 1 && this.page != this.pages) {
                this.setButton(this.nextPageIndex, this.nextPage, ClickType.LEFT, (GuiClickEvent event) -> this.nextPage());
            } else {
                this.setItem(this.nextPageIndex, this.nextPageItem);
                this.clearActions(this.nextPageIndex);
            }
        }
    }

    @NotNull
    protected Inventory getOrCreateInventory(@NotNull GuiManager manager) {
        return this.inventory != null ? this.inventory : this.generateInventory(manager);
    }

    @NotNull
    protected Inventory generateInventory(@NotNull GuiManager manager) {
        this.guiManager = manager;
        int cells = this.rows * this.inventoryType.columns;
        this.createInventory();
        for (int i = 0; i < cells; ++i) {
            ItemStack item = this.cellItems.get(i);
            this.inventory.setItem(i, item != null ? item : (this.unlockedCells.getOrDefault(i, false) != false ? AIR : this.blankItem));
        }
        return this.inventory;
    }

    protected void createInventory() {
        InventoryType t = this.inventoryType == null ? InventoryType.CHEST : this.inventoryType.type;
        switch (t) {
            case DISPENSER: 
            case HOPPER: {
                this.inventory = new GuiHolder(this.guiManager, this).newInventory(t, this.title == null ? "" : Gui.trimTitle(this.title));
                break;
            }
            default: {
                this.inventory = new GuiHolder(this.guiManager, this).newInventory(this.rows * 9, this.title == null ? "" : Gui.trimTitle(this.title));
            }
        }
    }

    @Nullable
    public Gui getParent() {
        return this.parent;
    }

    public void update() {
        if (this.inventory == null) {
            return;
        }
        int cells = this.rows * this.inventoryType.columns;
        for (int i = 0; i < cells; ++i) {
            ItemStack item = this.cellItems.get(i);
            this.inventory.setItem(i, item != null ? item : (this.unlockedCells.getOrDefault(i, false) != false ? AIR : this.blankItem));
        }
    }

    protected static String trimTitle(String title) {
        if (title == null) {
            return "";
        }
        if (ServerVersion.isServerVersionAtOrBelow(ServerVersion.V1_8) && title.length() > 32) {
            return title.charAt(30) == '\u00a7' ? title.substring(0, 30) : title.substring(0, 31);
        }
        return title;
    }

    protected boolean onClickOutside(@NotNull GuiManager manager, @NotNull Player player, @NotNull InventoryClickEvent event) {
        return this.dropper == null || this.dropper.onDrop(new GuiDropItemEvent(manager, this, player, event));
    }

    protected boolean onClick(@NotNull GuiManager manager, @NotNull Player player, @NotNull Inventory inventory, @NotNull InventoryClickEvent event) {
        Clickable button;
        int cell = event.getSlot();
        Map<ClickType, Clickable> conditionals = this.conditionalButtons.get(cell);
        if (conditionals == null || (button = conditionals.get(event.getClick())) == null && (button = conditionals.get(null)) == null) {
            if (this.defaultClicker != null) {
                this.defaultClicker.onClick(new GuiClickEvent(manager, this, player, event, cell, true));
            }
            if (this.privateDefaultClicker != null) {
                this.privateDefaultClicker.onClick(new GuiClickEvent(manager, this, player, event, cell, true));
            }
            return false;
        }
        button.onClick(new GuiClickEvent(manager, this, player, event, cell, true));
        return true;
    }

    protected boolean onClickPlayerInventory(@NotNull GuiManager manager, @NotNull Player player, @NotNull Inventory openInv, @NotNull InventoryClickEvent event) {
        return false;
    }

    public void onOpen(@NotNull GuiManager manager, @NotNull Player player) {
        this.open = true;
        this.guiManager = manager;
        if (this.opener != null) {
            this.opener.onOpen(new GuiOpenEvent(manager, this, player));
        }
    }

    public void onClose(@NotNull GuiManager manager, @NotNull Player player) {
        boolean showParent;
        if (!this.allowClose) {
            manager.showGUI(player, this);
            return;
        }
        boolean bl = showParent = this.open && this.parent != null;
        if (this.closer != null) {
            this.closer.onClose(new GuiCloseEvent(manager, this, player));
        }
        if (showParent) {
            manager.showGUI(player, this.parent);
        }
    }

    public CompatibleSound getDefaultSound() {
        return this.defaultSound;
    }

    public void setDefaultSound(CompatibleSound sound) {
        this.defaultSound = sound;
    }
}

