/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.manager;

import com.songoda.ultimatetimber.UltimateTimber;
import com.songoda.ultimatetimber.manager.ConfigurationManager;
import com.songoda.ultimatetimber.manager.Manager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ChoppingManager
extends Manager {
    private final Set<UUID> disabledPlayers = new HashSet<UUID>();
    private final Map<UUID, Boolean> cooldownedPlayers = new HashMap<UUID, Boolean>();
    private boolean useCooldown;
    private int cooldownAmount;

    public ChoppingManager(UltimateTimber ultimateTimber) {
        super(ultimateTimber);
    }

    @Override
    public void reload() {
        this.useCooldown = ConfigurationManager.Setting.PLAYER_TREE_TOPPLE_COOLDOWN.getBoolean();
        this.cooldownAmount = ConfigurationManager.Setting.PLAYER_TREE_TOPPLE_COOLDOWN_LENGTH.getInt();
    }

    @Override
    public void disable() {
        this.disabledPlayers.clear();
        this.cooldownedPlayers.clear();
    }

    public boolean togglePlayer(Player player) {
        if (this.disabledPlayers.contains(player.getUniqueId())) {
            this.disabledPlayers.remove(player.getUniqueId());
            return true;
        }
        this.disabledPlayers.add(player.getUniqueId());
        return false;
    }

    public boolean isChopping(Player player) {
        return !this.disabledPlayers.contains(player.getUniqueId());
    }

    public void cooldownPlayer(Player player) {
        if (!this.useCooldown || player.hasPermission("ultimatetimber.bypasscooldown")) {
            return;
        }
        this.cooldownedPlayers.put(player.getUniqueId(), false);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)UltimateTimber.getInstance(), () -> this.cooldownedPlayers.remove(player.getUniqueId()), (long)this.cooldownAmount * 20L);
    }

    public boolean isInCooldown(Player player) {
        boolean cooldowned;
        boolean bl = cooldowned = this.useCooldown && this.cooldownedPlayers.containsKey(player.getUniqueId());
        if (cooldowned && !this.cooldownedPlayers.get(player.getUniqueId()).booleanValue()) {
            this.plugin.getLocale().getMessage("event.on.cooldown").sendPrefixedMessage((CommandSender)player);
            this.cooldownedPlayers.replace(player.getUniqueId(), true);
        }
        return cooldowned;
    }
}

