/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.manager;

import com.songoda.ultimatetimber.UltimateTimber;
import com.songoda.ultimatetimber.manager.Manager;
import java.io.File;
import java.util.List;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigurationManager
extends Manager {
    private YamlConfiguration configuration;

    public ConfigurationManager(UltimateTimber ultimateTimber) {
        super(ultimateTimber);
    }

    @Override
    public void reload() {
        this.plugin.getCoreConfig().load();
        File configFile = new File(this.plugin.getDataFolder() + "/config.yml");
        if (configFile.exists() && this.plugin.getConfig().get("server-type") == null) {
            File renameConfigTo = new File(this.plugin.getDataFolder() + "/config-old.yml");
            configFile.renameTo(renameConfigTo);
            configFile = new File(this.plugin.getDataFolder() + "/config.yml");
        }
        if (!configFile.exists()) {
            String newConfigName = "config.yml";
            File newConfigFile = new File(this.plugin.getDataFolder() + "/" + newConfigName);
            this.plugin.saveResource(newConfigName, false);
            newConfigFile.renameTo(configFile);
        }
        this.configuration = YamlConfiguration.loadConfiguration((File)configFile);
        for (Setting setting : Setting.values()) {
            setting.reset();
        }
    }

    @Override
    public void disable() {
        for (Setting setting : Setting.values()) {
            setting.reset();
        }
    }

    public YamlConfiguration getConfig() {
        return this.configuration;
    }

    public static enum Setting {
        SERVER_TYPE(SettingType.STRING),
        LOCALE(SettingType.STRING),
        DISABLED_WORLDS(SettingType.STRING_LIST),
        MAX_LOGS_PER_CHOP(SettingType.INT),
        DESTROY_LEAVES(SettingType.BOOLEAN),
        LEAVES_REQUIRED_FOR_TREE(SettingType.INT),
        REALISTIC_TOOL_DAMAGE(SettingType.BOOLEAN),
        PROTECT_TOOL(SettingType.BOOLEAN),
        APPLY_SILK_TOUCH(SettingType.BOOLEAN),
        APPLY_SILK_TOUCH_TOOL_DAMAGE(SettingType.BOOLEAN),
        ALWAYS_REPLANT_SAPLING(SettingType.BOOLEAN),
        BREAK_ENTIRE_TREE_BASE(SettingType.BOOLEAN),
        DESTROY_INITIATED_BLOCK(SettingType.BOOLEAN),
        ONLY_DETECT_LOGS_UPWARDS(SettingType.BOOLEAN),
        ONLY_TOPPLE_WHILE(SettingType.STRING),
        ALLOW_CREATIVE_MODE(SettingType.BOOLEAN),
        REQUIRE_CHOP_PERMISSION(SettingType.BOOLEAN),
        PLAYER_TREE_TOPPLE_COOLDOWN(SettingType.BOOLEAN),
        PLAYER_TREE_TOPPLE_COOLDOWN_LENGTH(SettingType.INT),
        IGNORE_REQUIRED_TOOLS(SettingType.BOOLEAN),
        REPLANT_SAPLINGS(SettingType.BOOLEAN),
        REPLANT_SAPLINGS_COOLDOWN(SettingType.INT),
        FALLING_BLOCKS_REPLANT_SAPLINGS(SettingType.BOOLEAN),
        FALLING_BLOCKS_REPLANT_SAPLINGS_CHANCE(SettingType.DOUBLE),
        FALLING_BLOCKS_DEAL_DAMAGE(SettingType.BOOLEAN),
        FALLING_BLOCK_DAMAGE(SettingType.INT),
        ADD_ITEMS_TO_INVENTORY(SettingType.BOOLEAN),
        USE_CUSTOM_SOUNDS(SettingType.BOOLEAN),
        USE_CUSTOM_PARTICLES(SettingType.BOOLEAN),
        BONUS_LOOT_MULTIPLIER(SettingType.DOUBLE),
        IGNORE_PLACED_BLOCKS(SettingType.BOOLEAN),
        IGNORE_PLACED_BLOCKS_MEMORY_SIZE(SettingType.INT),
        HOOKS_APPLY_EXPERIENCE(SettingType.BOOLEAN),
        HOOKS_APPLY_EXTRA_DROPS(SettingType.BOOLEAN),
        HOOKS_REQUIRE_ABILITY_ACTIVE(SettingType.BOOLEAN),
        TREE_ANIMATION_TYPE(SettingType.STRING),
        SCATTER_TREE_BLOCKS_ON_GROUND(SettingType.BOOLEAN),
        FRAGILE_BLOCKS(SettingType.STRING_LIST);

        private SettingType settingType;
        private Object value = null;

        private Setting(SettingType settingType) {
            this.settingType = settingType;
        }

        public boolean getBoolean() {
            this.loadValue();
            return (Boolean)this.value;
        }

        public int getInt() {
            this.loadValue();
            return (Integer)this.value;
        }

        public double getDouble() {
            this.loadValue();
            return (Double)this.value;
        }

        public String getString() {
            this.loadValue();
            return (String)this.value;
        }

        public List<String> getStringList() {
            this.loadValue();
            return (List)this.value;
        }

        public void reset() {
            this.value = null;
        }

        private void loadValue() {
            if (this.value != null) {
                return;
            }
            YamlConfiguration config = UltimateTimber.getInstance().getConfigurationManager().getConfig();
            switch (this.settingType) {
                case BOOLEAN: {
                    this.value = config.getBoolean(this.getNameAsKey());
                    break;
                }
                case INT: {
                    this.value = config.getInt(this.getNameAsKey());
                    break;
                }
                case DOUBLE: {
                    this.value = config.getDouble(this.getNameAsKey());
                    break;
                }
                case STRING: {
                    this.value = config.getString(this.getNameAsKey());
                    break;
                }
                case STRING_LIST: {
                    this.value = config.getStringList(this.getNameAsKey());
                }
            }
        }

        private String getNameAsKey() {
            return this.name().replace("_", "-").toLowerCase();
        }
    }

    private static enum SettingType {
        BOOLEAN,
        INT,
        DOUBLE,
        STRING,
        STRING_LIST;

    }
}

