/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.manager;

import com.google.common.base.Strings;
import com.songoda.ultimatetimber.UltimateTimber;
import com.songoda.ultimatetimber.core.compatibility.CompatibleMaterial;
import com.songoda.ultimatetimber.core.compatibility.ServerVersion;
import com.songoda.ultimatetimber.core.hooks.McMMOHook;
import com.songoda.ultimatetimber.core.third_party.de.tr7zw.nbtapi.NBTItem;
import com.songoda.ultimatetimber.core.utils.TextUtils;
import com.songoda.ultimatetimber.manager.ConfigurationManager;
import com.songoda.ultimatetimber.manager.Manager;
import com.songoda.ultimatetimber.tree.ITreeBlock;
import com.songoda.ultimatetimber.tree.TreeBlockType;
import com.songoda.ultimatetimber.tree.TreeDefinition;
import com.songoda.ultimatetimber.tree.TreeLoot;
import com.songoda.ultimatetimber.utils.BlockUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TreeDefinitionManager
extends Manager {
    private final Random random = new Random();
    private final Set<TreeDefinition> treeDefinitions = new HashSet<TreeDefinition>();
    private final Set<CompatibleMaterial> globalPlantableSoil = new HashSet<CompatibleMaterial>();
    private final Set<TreeLoot> globalLogLoot = new HashSet<TreeLoot>();
    private final Set<TreeLoot> globalLeafLoot = new HashSet<TreeLoot>();
    private final Set<TreeLoot> globalEntireTreeLoot = new HashSet<TreeLoot>();
    private final Set<ItemStack> globalRequiredTools = new HashSet<ItemStack>();
    private boolean globalAxeRequired;
    private ItemStack requiredAxe;
    private String requiredAxeKey;

    public TreeDefinitionManager(UltimateTimber ultimateTimber) {
        super(ultimateTimber);
    }

    @Override
    public void reload() {
        ConfigurationSection entireTreeSection;
        ConfigurationSection leafSection;
        this.treeDefinitions.clear();
        this.globalPlantableSoil.clear();
        this.globalLogLoot.clear();
        this.globalLeafLoot.clear();
        this.globalEntireTreeLoot.clear();
        this.globalRequiredTools.clear();
        ConfigurationManager configurationManager = this.plugin.getConfigurationManager();
        YamlConfiguration config = configurationManager.getConfig();
        ConfigurationSection treeSection = config.getConfigurationSection("trees");
        block0: for (String key : treeSection.getKeys(false)) {
            ConfigurationSection entireTreeLootSection;
            ConfigurationSection leafLootSection;
            CompatibleMaterial material;
            ConfigurationSection tree = treeSection.getConfigurationSection(key);
            HashSet<CompatibleMaterial> logMaterials = new HashSet<CompatibleMaterial>();
            HashSet<CompatibleMaterial> leafMaterials = new HashSet<CompatibleMaterial>();
            HashSet<CompatibleMaterial> plantableSoilMaterial = new HashSet<CompatibleMaterial>();
            HashSet<TreeLoot> logLoot = new HashSet<TreeLoot>();
            HashSet<TreeLoot> leafLoot = new HashSet<TreeLoot>();
            HashSet<TreeLoot> entireTreeLoot = new HashSet<TreeLoot>();
            HashSet<ItemStack> requiredTools = new HashSet<ItemStack>();
            for (Object materialString : tree.getStringList("logs")) {
                material = CompatibleMaterial.getMaterial((String)materialString);
                if (material == null || material.getMaterial() == null) continue block0;
                logMaterials.add(material);
            }
            for (Object materialString : tree.getStringList("leaves")) {
                material = CompatibleMaterial.getMaterial((String)materialString);
                if (material == null || material.getMaterial() == null) continue block0;
                leafMaterials.add(material);
            }
            CompatibleMaterial saplingMaterial = CompatibleMaterial.getMaterial(tree.getString("sapling"));
            for (Object materialString : tree.getStringList("plantable-soil")) {
                material = CompatibleMaterial.getMaterial((String)materialString);
                if (material == null || material.getMaterial() == null) continue block0;
                plantableSoilMaterial.add(material);
            }
            double maxLogDistanceFromTrunk = tree.getDouble("max-log-distance-from-trunk");
            int maxLeafDistanceFromLog = tree.getInt("max-leaf-distance-from-log");
            boolean detectLeavesDiagonally = tree.getBoolean("search-for-leaves-diagonally");
            boolean dropOriginalLog = tree.getBoolean("drop-original-log");
            boolean dropOriginalLeaf = tree.getBoolean("drop-original-leaf");
            ConfigurationSection logLootSection = tree.getConfigurationSection("log-loot");
            if (logLootSection != null) {
                Object materialString;
                materialString = logLootSection.getKeys(false).iterator();
                while (materialString.hasNext()) {
                    String lootKey = (String)materialString.next();
                    logLoot.add(this.getTreeLootEntry(TreeBlockType.LOG, logLootSection.getConfigurationSection(lootKey)));
                }
            }
            if ((leafLootSection = tree.getConfigurationSection("leaf-loot")) != null) {
                for (String lootKey : leafLootSection.getKeys(false)) {
                    leafLoot.add(this.getTreeLootEntry(TreeBlockType.LEAF, leafLootSection.getConfigurationSection(lootKey)));
                }
            }
            if ((entireTreeLootSection = tree.getConfigurationSection("entire-tree-loot")) != null) {
                for (String lootKey : entireTreeLootSection.getKeys(false)) {
                    entireTreeLoot.add(this.getTreeLootEntry(TreeBlockType.LEAF, entireTreeLootSection.getConfigurationSection(lootKey)));
                }
            }
            for (String itemStackString : tree.getStringList("required-tools")) {
                CompatibleMaterial material2 = CompatibleMaterial.getMaterial(itemStackString);
                if (material2 == null) continue block0;
                requiredTools.add(material2.getItem());
            }
            boolean requiredAxe = tree.getBoolean("required-axe", false);
            this.treeDefinitions.add(new TreeDefinition(key, logMaterials, leafMaterials, saplingMaterial, plantableSoilMaterial, maxLogDistanceFromTrunk, maxLeafDistanceFromLog, detectLeavesDiagonally, dropOriginalLog, dropOriginalLeaf, logLoot, leafLoot, entireTreeLoot, requiredTools, requiredAxe));
        }
        for (Object material : config.getStringList("global-plantable-soil")) {
            this.globalPlantableSoil.add(CompatibleMaterial.getMaterial((String)material));
        }
        ConfigurationSection logSection = config.getConfigurationSection("global-log-loot");
        if (logSection != null) {
            for (Object lootKey : logSection.getKeys(false)) {
                this.globalLogLoot.add(this.getTreeLootEntry(TreeBlockType.LOG, logSection.getConfigurationSection((String)lootKey)));
            }
        }
        if ((leafSection = config.getConfigurationSection("global-leaf-loot")) != null) {
            for (String lootKey : leafSection.getKeys(false)) {
                this.globalLeafLoot.add(this.getTreeLootEntry(TreeBlockType.LEAF, leafSection.getConfigurationSection(lootKey)));
            }
        }
        if ((entireTreeSection = config.getConfigurationSection("global-entire-tree-loot")) != null) {
            for (String lootKey : entireTreeSection.getKeys(false)) {
                this.globalEntireTreeLoot.add(this.getTreeLootEntry(TreeBlockType.LOG, entireTreeSection.getConfigurationSection(lootKey)));
            }
        }
        for (String itemStackString : config.getStringList("global-required-tools")) {
            ItemStack tool = CompatibleMaterial.getMaterial(itemStackString).getItem();
            if (tool == null) continue;
            this.globalRequiredTools.add(tool);
        }
        this.globalAxeRequired = config.getBoolean("global-required-axe", false);
        if (config.contains("required-axe")) {
            this.loadAxe(config);
        }
    }

    private void loadAxe(YamlConfiguration config) {
        this.requiredAxeKey = config.getString("required-axe.nbt");
        this.requiredAxe = null;
        String typeString = config.getString("required-axe.type");
        if (Strings.isNullOrEmpty((String)typeString)) {
            this.plugin.getLogger().warning("Required-axe has to have a material set.");
            return;
        }
        CompatibleMaterial material = CompatibleMaterial.getMaterial(typeString);
        if (material == null) {
            this.plugin.getLogger().warning("Material " + typeString + " is invalid.");
            return;
        }
        ItemStack item = material.getItem();
        String displayName = TextUtils.formatText(config.getString("required-axe.name"));
        List lore = config.getStringList("required-axe.lore").stream().map(TextUtils::formatText).collect(Collectors.toList());
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(displayName);
        meta.setLore(lore);
        for (String enchantString : config.getStringList("required-axe.enchants")) {
            Enchantment enchantment;
            int level;
            String[] arr = enchantString.split(":");
            int n = level = arr.length > 1 ? Math.max(1, this.parseInt(arr[1])) : 1;
            if (ServerVersion.isServerVersionAtLeast(ServerVersion.V1_13)) {
                NamespacedKey key = NamespacedKey.minecraft((String)arr[0].trim().toLowerCase());
                enchantment = Enchantment.getByKey((NamespacedKey)key);
                if (enchantment == null) {
                    enchantment = Enchantment.getByName((String)arr[0].trim());
                }
            } else {
                enchantment = Enchantment.getByName((String)arr[0].trim());
            }
            if (enchantment == null) {
                this.plugin.getLogger().warning("Enchantment " + arr[0].trim() + " is invalid.");
                continue;
            }
            meta.addEnchant(enchantment, level, true);
        }
        item.setItemMeta(meta);
        NBTItem nbtItem = new NBTItem(item);
        nbtItem.setBoolean(this.requiredAxeKey, true);
        this.requiredAxe = item = nbtItem.getItem();
    }

    private int parseInt(String str) {
        try {
            return Integer.parseInt(str.trim());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public ItemStack getRequiredAxe() {
        return this.requiredAxe;
    }

    public boolean isGlobalAxeRequired() {
        return this.globalAxeRequired;
    }

    @Override
    public void disable() {
        this.treeDefinitions.clear();
    }

    public Set<TreeDefinition> getTreeDefinitionsForLog(Block block) {
        return this.narrowTreeDefinition(this.treeDefinitions, block, TreeBlockType.LOG);
    }

    public Set<TreeDefinition> narrowTreeDefinition(Set<TreeDefinition> possibleTreeDefinitions, Block block, TreeBlockType treeBlockType) {
        HashSet<TreeDefinition> matchingTreeDefinitions = new HashSet<TreeDefinition>();
        switch (treeBlockType) {
            case LOG: {
                block4: for (TreeDefinition treeDefinition : possibleTreeDefinitions) {
                    for (CompatibleMaterial material : treeDefinition.getLogMaterial()) {
                        if (!material.equals((Object)CompatibleMaterial.getMaterial(block))) continue;
                        matchingTreeDefinitions.add(treeDefinition);
                        continue block4;
                    }
                }
                break;
            }
            case LEAF: {
                block6: for (TreeDefinition treeDefinition : possibleTreeDefinitions) {
                    for (CompatibleMaterial material : treeDefinition.getLeafMaterial()) {
                        if (!material.equals((Object)CompatibleMaterial.getMaterial(block))) continue;
                        matchingTreeDefinitions.add(treeDefinition);
                        continue block6;
                    }
                }
                break;
            }
        }
        return matchingTreeDefinitions;
    }

    public boolean isToolValidForAnyTreeDefinition(ItemStack tool) {
        if (ConfigurationManager.Setting.IGNORE_REQUIRED_TOOLS.getBoolean()) {
            return true;
        }
        for (TreeDefinition treeDefinition : this.treeDefinitions) {
            if (!treeDefinition.isRequiredAxe() && !this.isGlobalAxeRequired() || tool == null || tool.getType().isAir() || !new NBTItem(tool).hasKey(this.requiredAxeKey).booleanValue()) continue;
            return true;
        }
        for (TreeDefinition treeDefinition : this.treeDefinitions) {
            for (ItemStack requiredTool : treeDefinition.getRequiredTools()) {
                if (!requiredTool.getType().equals((Object)tool.getType())) continue;
                return true;
            }
        }
        for (ItemStack requiredTool : this.globalRequiredTools) {
            if (!requiredTool.getType().equals((Object)tool.getType())) continue;
            return true;
        }
        return false;
    }

    public boolean isToolValidForTreeDefinition(TreeDefinition treeDefinition, ItemStack tool) {
        if (ConfigurationManager.Setting.IGNORE_REQUIRED_TOOLS.getBoolean()) {
            return true;
        }
        if (treeDefinition.isRequiredAxe() || this.isGlobalAxeRequired()) {
            return tool != null && !tool.getType().isAir() && new NBTItem(tool).hasKey(this.requiredAxeKey) != false;
        }
        for (ItemStack requiredTool : treeDefinition.getRequiredTools()) {
            if (!requiredTool.getType().equals((Object)tool.getType())) continue;
            return true;
        }
        for (ItemStack requiredTool : this.globalRequiredTools) {
            if (!requiredTool.getType().equals((Object)tool.getType())) continue;
            return true;
        }
        return false;
    }

    public void dropTreeLoot(TreeDefinition treeDefinition, ITreeBlock treeBlock, Player player, boolean hasSilkTouch, boolean isForEntireTree) {
        boolean addToInventory = ConfigurationManager.Setting.ADD_ITEMS_TO_INVENTORY.getBoolean();
        boolean hasBonusChance = player.hasPermission("ultimatetimber.bonusloot");
        ArrayList<ItemStack> lootedItems = new ArrayList<ItemStack>();
        ArrayList<String> lootedCommands = new ArrayList<String>();
        ArrayList<TreeLoot> toTry = new ArrayList<TreeLoot>();
        if (isForEntireTree) {
            toTry.addAll(treeDefinition.getEntireTreeLoot());
            toTry.addAll(this.globalEntireTreeLoot);
        } else if (ConfigurationManager.Setting.APPLY_SILK_TOUCH.getBoolean() && hasSilkTouch) {
            if (ConfigurationManager.Setting.HOOKS_APPLY_EXTRA_DROPS.getBoolean() && McMMOHook.hasWoodcuttingDoubleDrops(player)) {
                lootedItems.addAll(BlockUtils.getBlockDrops(treeBlock));
            }
            lootedItems.addAll(BlockUtils.getBlockDrops(treeBlock));
        } else {
            switch (treeBlock.getTreeBlockType()) {
                case LOG: {
                    toTry.addAll(treeDefinition.getLogLoot());
                    toTry.addAll(this.globalLogLoot);
                    if (!treeDefinition.shouldDropOriginalLog()) break;
                    if (ConfigurationManager.Setting.HOOKS_APPLY_EXTRA_DROPS.getBoolean() && McMMOHook.hasWoodcuttingDoubleDrops(player)) {
                        lootedItems.addAll(BlockUtils.getBlockDrops(treeBlock));
                    }
                    lootedItems.addAll(BlockUtils.getBlockDrops(treeBlock));
                    break;
                }
                case LEAF: {
                    toTry.addAll(treeDefinition.getLeafLoot());
                    toTry.addAll(this.globalLeafLoot);
                    if (!treeDefinition.shouldDropOriginalLeaf()) break;
                    if (ConfigurationManager.Setting.HOOKS_APPLY_EXTRA_DROPS.getBoolean() && McMMOHook.hasWoodcuttingDoubleDrops(player)) {
                        lootedItems.addAll(BlockUtils.getBlockDrops(treeBlock));
                    }
                    lootedItems.addAll(BlockUtils.getBlockDrops(treeBlock));
                }
            }
        }
        double bonusLootMultiplier = ConfigurationManager.Setting.BONUS_LOOT_MULTIPLIER.getDouble();
        for (TreeLoot treeLoot : toTry) {
            double chance;
            if (treeLoot == null) continue;
            double d = chance = hasBonusChance ? treeLoot.getChance() * bonusLootMultiplier : treeLoot.getChance();
            if (this.random.nextDouble() > chance / 100.0) continue;
            if (treeLoot.hasItem()) {
                if (ConfigurationManager.Setting.HOOKS_APPLY_EXTRA_DROPS.getBoolean() && McMMOHook.hasWoodcuttingDoubleDrops(player)) {
                    lootedItems.add(treeLoot.getItem());
                }
                lootedItems.add(treeLoot.getItem());
            }
            if (!treeLoot.hasCommand()) continue;
            if (ConfigurationManager.Setting.HOOKS_APPLY_EXTRA_DROPS.getBoolean() && McMMOHook.hasWoodcuttingDoubleDrops(player)) {
                lootedCommands.add(treeLoot.getCommand());
            }
            lootedCommands.add(treeLoot.getCommand());
        }
        if (addToInventory && player.getWorld().equals(treeBlock.getLocation().getWorld())) {
            ArrayList extraItems = new ArrayList();
            for (ItemStack lootedItem : lootedItems) {
                extraItems.addAll(player.getInventory().addItem(new ItemStack[]{lootedItem}).values());
            }
            Location location = player.getLocation().clone().subtract(0.5, 0.0, 0.5);
            for (ItemStack extraItem : extraItems) {
                location.getWorld().dropItemNaturally(location, extraItem);
            }
        } else {
            Location location = treeBlock.getLocation().clone().add(0.5, 0.5, 0.5);
            for (ItemStack lootedItem : lootedItems) {
                location.getWorld().dropItemNaturally(location, lootedItem);
            }
        }
        for (String string : lootedCommands) {
            Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), string.replace("%player%", player.getName()).replace("%type%", treeDefinition.getKey()).replace("%xPos%", treeBlock.getLocation().getBlockX() + "").replace("%yPos%", treeBlock.getLocation().getBlockY() + "").replace("%zPos%", treeBlock.getLocation().getBlockZ() + ""));
        }
    }

    public Set<CompatibleMaterial> getPlantableSoilMaterial(TreeDefinition treeDefinition) {
        HashSet<CompatibleMaterial> plantableSoilBlockData = new HashSet<CompatibleMaterial>();
        plantableSoilBlockData.addAll(treeDefinition.getPlantableSoilMaterial());
        plantableSoilBlockData.addAll(this.globalPlantableSoil);
        return plantableSoilBlockData;
    }

    private TreeLoot getTreeLootEntry(TreeBlockType treeBlockType, ConfigurationSection configurationSection) {
        String material = configurationSection.getString("material");
        CompatibleMaterial compatibleMaterial = material == null ? null : CompatibleMaterial.getMaterial(material);
        ItemStack item = compatibleMaterial == null ? null : compatibleMaterial.getItem();
        String command = configurationSection.getString("command");
        double chance = configurationSection.getDouble("chance");
        return new TreeLoot(treeBlockType, item, command, chance);
    }
}

