/*
 * Decompiled with CFR 0.152.
 */
package com.songoda.ultimatetimber.tree;

import com.songoda.ultimatetimber.tree.ITreeBlock;
import com.songoda.ultimatetimber.tree.TreeBlockType;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TreeBlockSet<BlockType>
implements Collection {
    private final ITreeBlock<BlockType> initialLogBlock;
    private List<ITreeBlock<BlockType>> logBlocks;
    private final List<ITreeBlock<BlockType>> leafBlocks;

    public TreeBlockSet() {
        this.initialLogBlock = null;
        this.logBlocks = new LinkedList<ITreeBlock<BlockType>>();
        this.leafBlocks = new LinkedList<ITreeBlock<BlockType>>();
    }

    public TreeBlockSet(ITreeBlock<BlockType> initialLogBlock) {
        this.initialLogBlock = initialLogBlock;
        this.logBlocks = new LinkedList<ITreeBlock<BlockType>>();
        this.leafBlocks = new LinkedList<ITreeBlock<BlockType>>();
        if (initialLogBlock != null) {
            this.logBlocks.add(initialLogBlock);
        }
    }

    public ITreeBlock<BlockType> getInitialLogBlock() {
        return this.initialLogBlock;
    }

    public List<ITreeBlock<BlockType>> getLogBlocks() {
        return Collections.unmodifiableList(this.logBlocks);
    }

    public List<ITreeBlock<BlockType>> getLeafBlocks() {
        return Collections.unmodifiableList(this.leafBlocks);
    }

    public Set<ITreeBlock<BlockType>> getAllTreeBlocks() {
        HashSet<ITreeBlock<BlockType>> treeBlocks = new HashSet<ITreeBlock<BlockType>>();
        treeBlocks.addAll(this.logBlocks);
        treeBlocks.addAll(this.leafBlocks);
        return treeBlocks;
    }

    @Override
    public int size() {
        return this.logBlocks.size() + this.leafBlocks.size();
    }

    @Override
    public boolean isEmpty() {
        return this.logBlocks.isEmpty() && this.leafBlocks.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.logBlocks.contains(o) || this.leafBlocks.contains(o);
    }

    @Override
    public Iterator iterator() {
        return this.getAllTreeBlocks().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getAllTreeBlocks().toArray();
    }

    public boolean add(Object o) {
        if (!(o instanceof ITreeBlock)) {
            return false;
        }
        ITreeBlock treeBlock = (ITreeBlock)o;
        switch (treeBlock.getTreeBlockType()) {
            case LOG: {
                return this.logBlocks.add(treeBlock);
            }
            case LEAF: {
                return this.leafBlocks.add(treeBlock);
            }
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof ITreeBlock)) {
            return false;
        }
        ITreeBlock treeBlock = (ITreeBlock)o;
        switch (treeBlock.getTreeBlockType()) {
            case LOG: {
                return this.logBlocks.remove(treeBlock);
            }
            case LEAF: {
                return this.leafBlocks.remove(treeBlock);
            }
        }
        return false;
    }

    public boolean addAll(Collection c) {
        boolean allAdded = true;
        for (Object o : c) {
            if (this.add(o)) continue;
            allAdded = false;
        }
        return allAdded;
    }

    @Override
    public void clear() {
        this.logBlocks.clear();
        this.leafBlocks.clear();
    }

    public boolean retainAll(Collection c) {
        boolean retainedAll = true;
        for (Object o : c) {
            if (!this.contains(o)) {
                this.remove(o);
                continue;
            }
            retainedAll = false;
        }
        return retainedAll;
    }

    public boolean removeAll(Collection c) {
        boolean removedAll = true;
        for (Object o : c) {
            if (this.contains(o)) {
                this.remove(o);
                continue;
            }
            removedAll = false;
        }
        return removedAll;
    }

    public void sortAndLimit(int max) {
        if (this.logBlocks.size() < max) {
            return;
        }
        this.logBlocks = this.logBlocks.stream().sorted(Comparator.comparingInt(b2 -> b2.getLocation().getBlockY())).limit(max).collect(Collectors.toList());
        int highest = this.logBlocks.get(this.logBlocks.size() - 1).getLocation().getBlockY();
        if (this.logBlocks.size() >= max) {
            for (ITreeBlock iTreeBlock : new LinkedList<ITreeBlock<BlockType>>(this.leafBlocks)) {
                if (!(iTreeBlock.getLocation().getY() > (double)highest)) continue;
                this.leafBlocks.remove(iTreeBlock);
            }
        }
    }

    public boolean removeAll(TreeBlockType treeBlockType) {
        if (treeBlockType.equals((Object)TreeBlockType.LOG)) {
            boolean removedAny = !this.logBlocks.isEmpty();
            this.logBlocks.clear();
            return removedAny;
        }
        if (treeBlockType.equals((Object)TreeBlockType.LEAF)) {
            boolean removedAny = !this.leafBlocks.isEmpty();
            this.leafBlocks.clear();
            return removedAny;
        }
        return false;
    }

    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public Object[] toArray(Object[] a2) {
        HashSet<ITreeBlock> treeBlocks = new HashSet<ITreeBlock>();
        for (Object o : a2) {
            if (!(o instanceof ITreeBlock)) continue;
            treeBlocks.add((ITreeBlock)o);
        }
        return treeBlocks.toArray();
    }
}

