/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.animations;

import me.davidml16.acubelets.utils.Utils;
import me.davidml16.acubelets.utils.XSeries.XMaterial;
import org.bukkit.inventory.ItemStack;

public class AnimationSettings
implements Comparable<AnimationSettings> {
    private String id;
    private String displayName;
    private int animationNumber;
    private ItemStack displayItem;
    private boolean enabled;
    private boolean outlineParticles;
    private boolean floorParticles;
    private boolean aroundParticles;
    private boolean needPermission;

    public AnimationSettings(String string) {
        this.id = string;
        this.displayName = "";
        this.animationNumber = 0;
        this.displayItem = XMaterial.BARRIER.parseItem();
        this.enabled = true;
        this.outlineParticles = false;
        this.floorParticles = false;
        this.aroundParticles = false;
        this.needPermission = true;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getFormatedDisplayName() {
        if (!this.displayName.startsWith("&") && !this.displayName.startsWith("\u00a7")) {
            return Utils.translate(this.displayName);
        }
        return Utils.translate("&r" + this.displayName);
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public ItemStack getDisplayItem() {
        return this.displayItem != null ? this.displayItem : XMaterial.BARRIER.parseItem();
    }

    public void setDisplayItem(ItemStack itemStack) {
        this.displayItem = itemStack;
    }

    public int getAnimationNumber() {
        return this.animationNumber;
    }

    public void setAnimationNumber(int n) {
        this.animationNumber = n;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isOutlineParticles() {
        return this.outlineParticles;
    }

    public void setOutlineParticles(boolean bl) {
        this.outlineParticles = bl;
    }

    public boolean isFloorParticles() {
        return this.floorParticles;
    }

    public void setFloorParticles(boolean bl) {
        this.floorParticles = bl;
    }

    public boolean isAroundParticles() {
        return this.aroundParticles;
    }

    public void setAroundParticles(boolean bl) {
        this.aroundParticles = bl;
    }

    public boolean isNeedPermission() {
        return this.needPermission;
    }

    public void setNeedPermission(boolean bl) {
        this.needPermission = bl;
    }

    @Override
    public int compareTo(AnimationSettings animationSettings) {
        return this.getAnimationNumber() - animationSettings.getAnimationNumber();
    }

    public String toString() {
        return "AnimationSettings{id='" + this.id + '\'' + ", displayName='" + this.displayName + '\'' + ", animationNumber=" + this.animationNumber + ", displayItem=" + this.displayItem + ", outlineParticles=" + this.outlineParticles + ", floorParticles=" + this.floorParticles + ", aroundParticles=" + this.aroundParticles + ", needPermission=" + this.needPermission + '}';
    }
}

