/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.animations.animation.animation10;

import java.util.Arrays;
import java.util.Objects;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.ASSpawner;
import me.davidml16.acubelets.animations.Animation;
import me.davidml16.acubelets.animations.AnimationSettings;
import me.davidml16.acubelets.animations.animation.animation10.Animation10_Spiral;
import me.davidml16.acubelets.utils.LocationUtils;
import me.davidml16.acubelets.utils.ParticlesAPI.Particles;
import me.davidml16.acubelets.utils.ParticlesAPI.UtilParticles;
import me.davidml16.acubelets.utils.Sounds;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.util.Vector;

public class Animation10_Task
extends Animation {
    private ArmorStand armorStand;
    private Location armorStandLocation;

    public Animation10_Task(Main main, AnimationSettings animationSettings) {
        super(main, animationSettings);
    }

    @Override
    public void onTick(int n) {
        if (n > 0 && n < 83) {
            Objects.requireNonNull(this.armorStand).setHeadPose(this.armorStand.getHeadPose().add(0.0, 0.26, 0.0));
        }
        if (n > 0 && n < 20) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, 0.35, 0.0);
        } else if (n > 20 && n < 30) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, 0.25, 0.0);
        } else if (n > 30 && n < 40) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, 0.15, 0.0);
        } else if (n > 40 && n < 50) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, 0.05, 0.0);
        }
        if (n > 0 && n < 70) {
            this.armorStand.teleport(this.armorStandLocation);
        }
        if (n == 50) {
            Location location = this.armorStand.getEyeLocation().add(0.0, 0.4, 0.0);
            for (Location location2 : LocationUtils.getCircle(this.armorStand.getLocation().clone().add(0.0, 0.75, 0.0), 0.25, 50)) {
                Vector vector = location2.toVector().subtract(this.armorStand.getLocation().clone().add(0.0, 0.75, 0.0).toVector()).normalize();
                UtilParticles.display(Particles.CLOUD, vector, location, 0.3f);
            }
            Sounds.playSound(this.getCubeletBox().getLocation(), Sounds.MySound.FIREWORK_BLAST, 0.5f, 0.0f);
        } else if (n == 70) {
            Sounds.playSound(this.getCubeletBox().getLocation(), Sounds.MySound.IRONGOLEM_DEATH, 0.5f, 0.0f);
            this.cancelRunnable("spiral");
        } else if (n > 70 && n < 83) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, -0.85, 0.0);
            this.armorStand.teleport(this.armorStandLocation);
            this.getMain().getFireworkUtil().spawn(this.armorStandLocation.clone().add(0.0, 1.75, 0.0), FireworkEffect.Type.BURST, this.getColors().get(0), this.getColors().get(1));
        } else if (n == 83) {
            this.doPreRewardReveal();
        }
    }

    @Override
    public void onStart() {
        this.armorStand = ASSpawner.spawn(this.getMain(), this.getCubeletBox(), this.getCubeletType(), false, false, this.getBoxLocation().clone().add(0.0, -1.25, 0.0));
        this.getMain().getAnimationHandler().getEntities().add((Entity)this.armorStand);
        this.armorStandLocation = this.armorStand.getLocation();
        Sounds.playSound(this.getCubeletBox().getLocation(), Sounds.MySound.FIREWORK_LAUNCH, 0.5f, 0.0f);
        this.addRunnable("spiral", new Animation10_Spiral(this.armorStand));
        this.startRunnable("spiral", 0L, 1L);
        this.setColors(Arrays.asList(Color.ORANGE, Color.WHITE));
    }

    @Override
    public void onStop() {
        this.cancelRunnables();
        if (this.getMain().getAnimationHandler().getEntities().contains(this.armorStand)) {
            if (this.armorStand != null) {
                this.armorStand.remove();
            }
            this.getMain().getAnimationHandler().getEntities().remove(this.armorStand);
        }
    }

    @Override
    public void onPreRewardReveal() {
        this.getMain().getFireworkUtil().spawn(this.getCubeletBox().getLocation().clone().add(0.5, 2.0, 0.5), FireworkEffect.Type.STAR, this.getColors().get(0), this.getColors().get(1));
        Sounds.playSound(this.getCubeletBox().getLocation(), Sounds.MySound.EXPLODE, 0.5f, 0.0f);
    }

    @Override
    public void onRewardReveal() {
        this.armorStand.remove();
        this.armorStand = null;
    }
}

