/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.animations.animation.animation11;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.ASSpawner;
import me.davidml16.acubelets.animations.Animation;
import me.davidml16.acubelets.animations.AnimationSettings;
import me.davidml16.acubelets.animations.animation.animation11.Animation11_Planet;
import me.davidml16.acubelets.animations.animation.animation11.Animation11_Spiral;
import me.davidml16.acubelets.utils.ParticlesAPI.Particles;
import me.davidml16.acubelets.utils.ParticlesAPI.UtilParticles;
import me.davidml16.acubelets.utils.SkullCreator;
import me.davidml16.acubelets.utils.Sounds;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Animation11_Task
extends Animation {
    private ArmorStand armorStand;
    private Location armorStandLocation;
    private Set<Animation11_Planet> planets = new HashSet<Animation11_Planet>();
    private static final Random RANDOM = new Random();
    private static final ItemStack PLANET_SUN = SkullCreator.itemFromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTkwYjYwZGZjZGE2YzBkNDRjMWZhMTMzMDJjZWZjZjhiMjM3ZjgxZDdlZjliNzIwNDFmNmJlYWE4M2M0ZWQwNyJ9fX0=");
    private static final ItemStack PLANET_MERCURY = SkullCreator.itemFromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMzE3OGYyMzU3NjhlZDJmMGYxYTA3YWIwMmI5MmY1OTljYzQyYzc0MWQyZjczM2U1MzY4YjVhMTA0ODRiM2NiIn19fQ==");
    private static final ItemStack PLANET_VENUS = SkullCreator.itemFromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMGVmMTQ3ZGRjOTA4ZTY4MjVjMjI5OTk3YWE1Mjk3NjFmNTE2OTFhMTFjOTU1MTI5YTIzMzYzMmQ1NTQ4NzVlIn19fQ==");
    private static final ItemStack PLANET_EARTH = SkullCreator.itemFromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYzY5MTk2YjMzMGM2Yjg5NjJmMjNhZDU2MjdmYjZlY2NlNDcyZWFmNWM5ZDQ0Zjc5MWY2NzA5YzdkMGY0ZGVjZSJ9fX0=");
    private static final ItemStack PLANET_MARS = SkullCreator.itemFromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZDM3ODU3ZTE2OWVkMzdiMjQ4OTVjM2ZkZTQyNjJkYWU2ZTg3NDI4NjFlYjczZWRhMTU0M2NiNGMwM2E2N2UzIn19fQ==");
    private static final ItemStack PLANET_JUPITER = SkullCreator.itemFromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYjhhYWE4YTM1NjFlODBlZjFmOTU2MWYxNzIxMWU3NzBkZTE4YTlmOThjMjY5MWVjZjlkNjk2NTU5YTFiOTE4YyJ9fX0=");
    private static final ItemStack PLANET_SATURN = SkullCreator.itemFromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNjY1Y2QzYTI0ZjE5MzM3MWVlYmFjOWE3MWM0OGY0MDhhOTM1YWZjNGI0MzVmMWZiN2I5ODQzZTY1ODcyOThmIn19fQ==");
    private static final ItemStack PLANET_URANUS = SkullCreator.itemFromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYWE2ZGQ3NWY0MWU0MjY4ZTBhMTI2OTA1MDkwN2FhNjc0NmZmZDM3YTRhOTI5ZTczMjUyNDY0MmMzMzZiYyJ9fX0=");
    private static final ItemStack PLANET_NEPTUNE = SkullCreator.itemFromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvODdkNjZmOTM5MDlhNmQ0NjQxYzY1MzA4MmUwNDc0OTY5MWRlODJjZjc3MjMyYmQyMGFiMzJhZGY0ZiJ9fX0=");

    public Animation11_Task(Main main, AnimationSettings animationSettings) {
        super(main, animationSettings);
    }

    @Override
    public void onTick(int n) {
        if (n > 0 && n < 10) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, 0.2, 0.0);
            Objects.requireNonNull(this.armorStand).setHeadPose(this.armorStand.getHeadPose().add(0.0, 0.17, 0.0));
        } else if (n > 10 && n < 20) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, 0.15, 0.0);
            Objects.requireNonNull(this.armorStand).setHeadPose(this.armorStand.getHeadPose().add(0.0, 0.14, 0.0));
        } else if (n > 20 && n < 30) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, 0.1, 0.0);
            Objects.requireNonNull(this.armorStand).setHeadPose(this.armorStand.getHeadPose().add(0.0, 0.11, 0.0));
        } else if (n > 30 && n < 40) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, 0.05, 0.0);
            Objects.requireNonNull(this.armorStand).setHeadPose(this.armorStand.getHeadPose().add(0.0, 0.08, 0.0));
        } else if (this.armorStand != null) {
            Objects.requireNonNull(this.armorStand).setHeadPose(this.armorStand.getHeadPose().add(0.0, 0.05, 0.0));
            if (n > 40) {
                UtilParticles.display(Particles.FLAME, 0.25, 0.25, 0.25, this.armorStand.getLocation().clone().add(0.0, 1.75, 0.0), 1);
            }
        }
        if (n < 160) {
            this.armorStand.teleport(this.armorStandLocation);
        }
        if (n == 40) {
            this.cancelRunnable("spiral");
            int n2 = this.r_i(160, 360);
            Animation11_Planet animation11_Planet = new Animation11_Planet(this.getMain(), PLANET_MERCURY, this.armorStandLocation.clone().add(0.0, this.r_d(-1.0, 2.0), 0.0), 1.0f, n2, true, this.r_d(0.05, 0.2), this.r_i(0, n2));
            animation11_Planet.runTaskTimer((Plugin)this.getMain(), 0L, 1L);
            this.planets.add(animation11_Planet);
            this.removeLater(animation11_Planet, 115L);
        } else if (n == 42) {
            int n3 = this.r_i(160, 360);
            Animation11_Planet animation11_Planet = new Animation11_Planet(this.getMain(), PLANET_VENUS, this.armorStandLocation.clone().add(0.0, this.r_d(-1.0, 2.0), 0.0), 1.5f, n3, true, this.r_d(0.05, 0.2), this.r_i(0, n3));
            animation11_Planet.runTaskTimer((Plugin)this.getMain(), 0L, 1L);
            this.planets.add(animation11_Planet);
            this.removeLater(animation11_Planet, 110L);
        } else if (n == 44) {
            int n4 = this.r_i(160, 360);
            Animation11_Planet animation11_Planet = new Animation11_Planet(this.getMain(), PLANET_EARTH, this.armorStandLocation.clone().add(0.0, this.r_d(-1.0, 2.0), 0.0), 2.0f, n4, true, this.r_d(0.05, 0.2), this.r_i(0, n4));
            animation11_Planet.runTaskTimer((Plugin)this.getMain(), 0L, 1L);
            this.planets.add(animation11_Planet);
            this.removeLater(animation11_Planet, 105L);
        } else if (n == 46) {
            int n5 = this.r_i(160, 360);
            Animation11_Planet animation11_Planet = new Animation11_Planet(this.getMain(), PLANET_MARS, this.armorStandLocation.clone().add(0.0, this.r_d(-1.0, 2.0), 0.0), 2.5f, n5, true, this.r_d(0.05, 0.2), this.r_i(0, n5));
            animation11_Planet.runTaskTimer((Plugin)this.getMain(), 0L, 1L);
            this.planets.add(animation11_Planet);
            this.removeLater(animation11_Planet, 100L);
        } else if (n == 48) {
            int n6 = this.r_i(160, 360);
            Animation11_Planet animation11_Planet = new Animation11_Planet(this.getMain(), PLANET_JUPITER, this.armorStandLocation.clone().add(0.0, this.r_d(-1.0, 2.0), 0.0), 3.0f, n6, true, this.r_d(0.05, 0.2), this.r_i(0, n6));
            animation11_Planet.runTaskTimer((Plugin)this.getMain(), 0L, 1L);
            this.planets.add(animation11_Planet);
            this.removeLater(animation11_Planet, 95L);
        } else if (n == 50) {
            int n7 = this.r_i(160, 360);
            Animation11_Planet animation11_Planet = new Animation11_Planet(this.getMain(), PLANET_SATURN, this.armorStandLocation.clone().add(0.0, this.r_d(-1.0, 2.0), 0.0), 3.5f, n7, true, this.r_d(0.05, 0.2), this.r_i(0, n7));
            animation11_Planet.runTaskTimer((Plugin)this.getMain(), 0L, 1L);
            this.planets.add(animation11_Planet);
            this.removeLater(animation11_Planet, 90L);
        } else if (n == 52) {
            int n8 = this.r_i(160, 360);
            Animation11_Planet animation11_Planet = new Animation11_Planet(this.getMain(), PLANET_URANUS, this.armorStandLocation.clone().add(0.0, this.r_d(-1.0, 2.0), 0.0), 4.0f, n8, true, this.r_d(0.05, 0.2), this.r_i(0, n8));
            animation11_Planet.runTaskTimer((Plugin)this.getMain(), 0L, 1L);
            this.planets.add(animation11_Planet);
            this.removeLater(animation11_Planet, 85L);
        } else if (n == 54) {
            int n9 = this.r_i(160, 360);
            Animation11_Planet animation11_Planet = new Animation11_Planet(this.getMain(), PLANET_NEPTUNE, this.armorStandLocation.clone().add(0.0, this.r_d(-1.0, 2.0), 0.0), 4.5f, n9, true, this.r_d(0.05, 0.2), this.r_i(0, n9));
            animation11_Planet.runTaskTimer((Plugin)this.getMain(), 0L, 1L);
            this.planets.add(animation11_Planet);
            this.removeLater(animation11_Planet, 80L);
        }
        if (n == 160) {
            Sounds.playSound(this.getCubeletBox().getLocation(), Sounds.MySound.IRONGOLEM_DEATH, 0.5f, 0.0f);
            UtilParticles.display(Particles.EXPLOSION_LARGE, this.armorStand.getLocation().clone().add(0.0, 1.25, 0.0), 2);
            this.armorStand.setGravity(true);
            ASSpawner.setEntityNoclip((Entity)this.armorStand);
        } else if (n > 160 && n < 173) {
            UtilParticles.display(Particles.FLAME, 0.1f, 0.25, 0.15f, this.armorStand.getLocation().clone().add(0.0, 1.5, 0.0), 5);
        }
        if (n == 171) {
            this.doPreRewardReveal();
        }
    }

    @Override
    public void onStart() {
        this.armorStand = ASSpawner.spawn(this.getMain(), this.getCubeletBox(), PLANET_SUN, false, false, this.getBoxLocation().clone().add(0.0, -1.25, 0.0));
        this.getMain().getAnimationHandler().getEntities().add((Entity)this.armorStand);
        this.armorStandLocation = this.armorStand.getLocation();
        Sounds.playSound(this.getCubeletBox().getLocation(), Sounds.MySound.FIREWORK_LAUNCH, 0.5f, 0.0f);
        this.addRunnable("spiral", new Animation11_Spiral(this.armorStand));
        this.startRunnable("spiral", 0L, 1L);
        this.setColors(Arrays.asList(Color.PURPLE, Color.FUCHSIA));
    }

    @Override
    public void onStop() {
        this.cancelRunnables();
        try {
            for (Animation11_Planet animation11_Planet : this.planets) {
                animation11_Planet.cancel();
                if (!this.getMain().getAnimationHandler().getEntities().contains(animation11_Planet.getArmorStand())) continue;
                ArmorStand armorStand = animation11_Planet.getArmorStand();
                if (armorStand != null) {
                    armorStand.remove();
                }
                this.getMain().getAnimationHandler().getEntities().remove(armorStand);
            }
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        if (this.getMain().getAnimationHandler().getEntities().contains(this.armorStand)) {
            if (this.armorStand != null) {
                this.armorStand.remove();
            }
            this.getMain().getAnimationHandler().getEntities().remove(this.armorStand);
        }
    }

    @Override
    public void onPreRewardReveal() {
        this.getMain().getFireworkUtil().spawn(this.getCubeletBox().getLocation().clone().add(0.5, 2.0, 0.5), FireworkEffect.Type.BALL_LARGE, this.getColors().get(0), this.getColors().get(1));
        Sounds.playSound(this.getCubeletBox().getLocation(), Sounds.MySound.EXPLODE, 0.5f, 0.0f);
    }

    @Override
    public void onRewardReveal() {
        this.armorStand.remove();
        this.armorStand = null;
    }

    private int r_i(int n, int n2) {
        return RANDOM.nextInt(n2 - n) + n;
    }

    private double r_d(double d, double d2) {
        return ThreadLocalRandom.current().nextDouble(d, d2);
    }

    public void removeLater(Animation11_Planet animation11_Planet, long l) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.getMain(), () -> {
            animation11_Planet.cancel();
            UtilParticles.display(Particles.SNOW_SHOVEL, animation11_Planet.getArmorStand().getLocation().clone().add(0.0, 1.0, 0.0), 5);
            Sounds.playSound(animation11_Planet.getArmorStand().getLocation(), Sounds.MySound.LAVA_POP, 0.5f, 1.0f);
            if (this.getMain().getAnimationHandler().getEntities().contains(animation11_Planet.getArmorStand())) {
                ArmorStand armorStand = animation11_Planet.getArmorStand();
                if (armorStand != null) {
                    armorStand.remove();
                }
                this.getMain().getAnimationHandler().getEntities().remove(armorStand);
            }
        }, l);
    }
}

