/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.animations.animation.animation18;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.ASSpawner;
import me.davidml16.acubelets.animations.Animation;
import me.davidml16.acubelets.animations.AnimationSettings;
import me.davidml16.acubelets.animations.animation.animation18.Animation18_Item;
import me.davidml16.acubelets.utils.LocationUtils;
import me.davidml16.acubelets.utils.ParticlesAPI.Particles;
import me.davidml16.acubelets.utils.ParticlesAPI.UtilParticles;
import me.davidml16.acubelets.utils.Sounds;
import me.davidml16.acubelets.utils.XSeries.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class Animation18_Task
extends Animation {
    private ArmorStand armorStand;
    private List<Animation18_Item> items = new ArrayList<Animation18_Item>();
    private BukkitTask spawnItemsRunnable;
    private BukkitTask removeItemsRunnable;
    private double boxLocIncrease = -1.5;
    private double circleSize = 0.0;
    private int circleStep = 0;
    private float rotation;

    public Animation18_Task(Main main, AnimationSettings animationSettings) {
        super(main, animationSettings);
    }

    @Override
    public void onTick(int n) {
        if (n <= 25) {
            Location location = this.getBoxLocation().clone();
            this.boxLocIncrease += 0.06;
            location.add(0.0, this.boxLocIncrease, 0.0);
            location.setYaw(this.rotation);
            UtilParticles.display(Particles.FIREWORKS_SPARK, this.armorStand.getLocation().clone().add(0.0, 1.25, 0.0), 1);
            this.armorStand.teleport(location);
        } else if (n <= 60) {
            this.boxLocIncrease += 0.04;
            Location location = this.getBoxLocation().clone();
            location.add(0.0, this.boxLocIncrease, 0.0);
            this.circleSize = n <= 40 ? (this.circleSize += 0.07) : (this.circleSize -= 0.075);
            if (this.circleSize < 0.0) {
                this.circleSize = 0.0;
            }
            List<Location> list = LocationUtils.getCircle(location, this.circleSize, 50);
            Location location2 = list.get(this.circleStep).clone();
            location2.setYaw(this.rotation);
            Sounds.playSound(this.armorStand.getLocation(), Sounds.MySound.NOTE_PLING, 0.5f, 3.0f);
            UtilParticles.display(Particles.FIREWORKS_SPARK, this.armorStand.getLocation().clone().add(0.0, 1.25, 0.0), 1);
            this.armorStand.teleport(location2);
            ++this.circleStep;
            if (this.circleStep == list.size()) {
                this.circleStep = 0;
            }
        }
        if (n == 150) {
            this.spawnItemsRunnable.cancel();
        }
        if (n == 283) {
            this.doPreRewardReveal();
        }
        if (n == 305) {
            Sounds.playSound(this.getCubeletBox().getLocation(), Sounds.MySound.LEVEL_UP, 0.5f, 1.0f);
        }
    }

    @Override
    public void onStart() {
        this.rotation = this.getRotation((boolean)false).value;
        this.setColors(Arrays.asList(Color.RED, Color.YELLOW, Color.BLUE, Color.GREEN, Color.ORANGE, Color.FUCHSIA, Color.AQUA, Color.WHITE));
        this.armorStand = ASSpawner.spawn(this.getMain(), this.getCubeletBox().getLocation().clone().add(0.5, -1.5, 0.5), XMaterial.CHEST.parseItem(), false, false, false);
        this.getMain().getAnimationHandler().getEntities().add((Entity)this.armorStand);
        this.spawnItemsRunnable = Bukkit.getScheduler().runTaskTimer((Plugin)this.getMain(), () -> {
            if (this.items.size() < 9) {
                Animation18_Item animation18_Item = new Animation18_Item(this.getMain(), this.getMain().getCubeletRewardHandler().processReward(this.getCubeletType()), this.armorStand.getLocation().clone().add(0.0, 0.75, 0.0));
                animation18_Item.runTaskTimer((Plugin)this.getMain(), 0L, 1L);
                this.items.add(animation18_Item);
            }
        }, 65L, 8L);
        this.removeItemsRunnable = Bukkit.getScheduler().runTaskTimer((Plugin)this.getMain(), () -> {
            if (this.items.size() > 1) {
                this.removeRandomItem();
            } else {
                this.setReward(this.items.get(0).getReward());
            }
        }, 200L, 5L);
    }

    @Override
    public void onStop() {
        if (this.spawnItemsRunnable != null) {
            this.spawnItemsRunnable.cancel();
        }
        if (this.removeItemsRunnable != null) {
            this.removeItemsRunnable.cancel();
        }
        try {
            for (Animation18_Item animation18_Item : this.items) {
                ArmorStand armorStand;
                animation18_Item.cancel();
                if (this.getMain().getAnimationHandler().getEntities().contains(animation18_Item.getArmorStandItem())) {
                    armorStand = animation18_Item.getArmorStandItem();
                    if (armorStand != null) {
                        armorStand.remove();
                    }
                    this.getMain().getAnimationHandler().getEntities().remove(armorStand);
                }
                if (!this.getMain().getAnimationHandler().getEntities().contains(animation18_Item.getArmorStandName())) continue;
                armorStand = animation18_Item.getArmorStandName();
                if (armorStand != null) {
                    armorStand.remove();
                }
                this.getMain().getAnimationHandler().getEntities().remove(armorStand);
            }
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        if (this.getMain().getAnimationHandler().getEntities().contains(this.armorStand)) {
            if (this.armorStand != null) {
                this.armorStand.remove();
            }
            this.getMain().getAnimationHandler().getEntities().remove(this.armorStand);
        }
    }

    @Override
    public void onPreRewardReveal() {
        Sounds.playSound(this.armorStand.getLocation(), Sounds.MySound.EXPLODE, 0.5f, 1.0f);
        this.getMain().getFireworkUtil().spawn(this.getCubeletBox().getLocation().clone().add(0.5, 1.5, 0.5), FireworkEffect.Type.BALL_LARGE, this.getColors().toArray(new Color[this.getColors().size()]));
    }

    @Override
    public void onRewardReveal() {
        this.armorStand.remove();
        this.armorStand = null;
        this.spawnItemsRunnable.cancel();
        this.removeItemsRunnable.cancel();
        try {
            for (Animation18_Item animation18_Item : this.items) {
                ArmorStand armorStand;
                animation18_Item.cancel();
                if (this.getMain().getAnimationHandler().getEntities().contains(animation18_Item.getArmorStandItem())) {
                    armorStand = animation18_Item.getArmorStandItem();
                    if (armorStand != null) {
                        armorStand.remove();
                    }
                    this.getMain().getAnimationHandler().getEntities().remove(armorStand);
                }
                if (!this.getMain().getAnimationHandler().getEntities().contains(animation18_Item.getArmorStandName())) continue;
                armorStand = animation18_Item.getArmorStandName();
                if (armorStand != null) {
                    armorStand.remove();
                }
                this.getMain().getAnimationHandler().getEntities().remove(armorStand);
            }
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    public void removeRandomItem() {
        ArmorStand armorStand;
        Animation18_Item animation18_Item = this.items.get((int)(Math.random() * (double)this.items.size()));
        animation18_Item.cancel();
        if (this.getMain().getAnimationHandler().getEntities().contains(animation18_Item.getArmorStandItem())) {
            armorStand = animation18_Item.getArmorStandItem();
            if (armorStand != null) {
                armorStand.remove();
            }
            this.getMain().getAnimationHandler().getEntities().remove(armorStand);
        }
        if (this.getMain().getAnimationHandler().getEntities().contains(animation18_Item.getArmorStandName())) {
            armorStand = animation18_Item.getArmorStandName();
            if (armorStand != null) {
                armorStand.remove();
            }
            this.getMain().getAnimationHandler().getEntities().remove(armorStand);
        }
        this.items.remove((Object)animation18_Item);
    }
}

