/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.animations.animation.animation19;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.ASSpawner;
import me.davidml16.acubelets.animations.Animation;
import me.davidml16.acubelets.animations.AnimationSettings;
import me.davidml16.acubelets.animations.animation.animation19.Animation19_Blocks;
import me.davidml16.acubelets.animations.animation.animation19.Animation19_Sword;
import me.davidml16.acubelets.utils.Sounds;
import me.davidml16.acubelets.utils.XSeries.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class Animation19_Task
extends Animation {
    private ArmorStand armorStand;
    private Location armorStandLocation;
    private List<Animation19_Sword> swords = new ArrayList<Animation19_Sword>();
    private BukkitTask spawnSwordsRunnable;

    public Animation19_Task(Main main, AnimationSettings animationSettings) {
        super(main, animationSettings);
    }

    @Override
    public void onTick(int n) {
        if (n > 60 && n < 130) {
            Objects.requireNonNull(this.armorStand).setHeadPose(this.armorStand.getHeadPose().add(0.0, 0.26, 0.0));
        }
        if (n > 60 && n < 80) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, 0.35, 0.0);
        } else if (n > 80 && n < 90) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, 0.25, 0.0);
        } else if (n > 90 && n < 100) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, 0.15, 0.0);
        } else if (n > 100 && n < 110) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, 0.05, 0.0);
        }
        if (n > 60 && n < 130) {
            this.armorStand.teleport(this.armorStandLocation);
        }
        if (n == 130) {
            Sounds.playSound(this.armorStand.getLocation(), Sounds.MySound.ANVIL_LAND, 0.5f, 0.0f);
            this.armorStand.setHelmet(XMaterial.ANVIL.parseItem());
        }
        if (n > 130 && n < 143) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, -0.85, 0.0);
            this.armorStand.teleport(this.armorStandLocation);
        }
        if (n == 60) {
            this.armorStand = ASSpawner.spawn(this.getMain(), this.getCubeletBox(), this.getCubeletType(), false, false, this.getBoxLocation().clone().add(0.0, -1.25, 0.0));
            this.getMain().getAnimationHandler().getEntities().add((Entity)this.armorStand);
            this.armorStandLocation = this.armorStand.getLocation();
            Sounds.playSound(this.getCubeletBox().getLocation(), Sounds.MySound.FIREWORK_LAUNCH, 0.5f, 0.0f);
        } else if (n == 143) {
            this.doPreRewardReveal();
        }
    }

    @Override
    public void onStart() {
        this.setAnimationBlocks(new Animation19_Blocks(this.getCubeletBox().getLocation()));
        this.startAnimationBlocks(0L);
        this.setColors(Arrays.asList(Color.WHITE, Color.PURPLE));
        this.spawnSwordsRunnable = Bukkit.getScheduler().runTaskTimer((Plugin)this.getMain(), () -> {
            if (this.swords.size() < 8) {
                Animation19_Sword animation19_Sword = new Animation19_Sword(this.getMain(), this.getCubeletBox().getLocation().clone().add(0.5, 3.0, 0.5), 2.0f, 66, false, 0);
                animation19_Sword.runTaskTimer((Plugin)this.getMain(), 0L, 1L);
                this.swords.add(animation19_Sword);
            }
        }, 5L, 8L);
    }

    @Override
    public void onStop() {
        this.stopAnimationBlocks();
        if (this.spawnSwordsRunnable != null) {
            this.spawnSwordsRunnable.cancel();
        }
        if (this.getMain().getAnimationHandler().getEntities().contains(this.armorStand)) {
            if (this.armorStand != null) {
                this.armorStand.remove();
            }
            this.getMain().getAnimationHandler().getEntities().remove(this.armorStand);
        }
        try {
            for (Animation19_Sword animation19_Sword : this.swords) {
                animation19_Sword.cancel();
                if (!this.getMain().getAnimationHandler().getEntities().contains(animation19_Sword.getArmorStand())) continue;
                ArmorStand armorStand = animation19_Sword.getArmorStand();
                if (armorStand != null) {
                    armorStand.remove();
                }
                this.getMain().getAnimationHandler().getEntities().remove(armorStand);
            }
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public void onPreRewardReveal() {
        this.getMain().getFireworkUtil().spawn(this.getCubeletBox().getLocation().clone().add(0.5, 1.5, 0.5), FireworkEffect.Type.BALL_LARGE, this.getColors().get(0), this.getColors().get(1));
        try {
            for (Animation19_Sword animation19_Sword : this.swords) {
                animation19_Sword.cancel();
                if (!this.getMain().getAnimationHandler().getEntities().contains(animation19_Sword.getArmorStand())) continue;
                ArmorStand armorStand = animation19_Sword.getArmorStand();
                if (armorStand != null) {
                    armorStand.remove();
                }
                this.getMain().getAnimationHandler().getEntities().remove(armorStand);
            }
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    @Override
    public void onRewardReveal() {
        if (this.spawnSwordsRunnable != null) {
            this.spawnSwordsRunnable.cancel();
        }
        if (this.armorStand != null) {
            this.armorStand.remove();
            this.armorStand = null;
        }
    }
}

