/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.animations.animation.animation20;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.BlockPosition;
import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.Animation;
import me.davidml16.acubelets.animations.AnimationSettings;
import me.davidml16.acubelets.animations.FakeBlock;
import me.davidml16.acubelets.animations.animation.animation20.Animation20_Blocks;
import me.davidml16.acubelets.utils.LocationUtils;
import me.davidml16.acubelets.utils.ParticlesAPI.Particles;
import me.davidml16.acubelets.utils.ParticlesAPI.UtilParticles;
import me.davidml16.acubelets.utils.Sounds;
import me.davidml16.acubelets.utils.XSeries.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.material.MaterialData;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Animation20_Task
extends Animation {
    private Location rotationLocation;
    private LivingEntity enderman;

    public Animation20_Task(Main main, AnimationSettings animationSettings) {
        super(main, animationSettings);
    }

    @Override
    public void onTick(int n) {
        if (n == 50) {
            this.enderman = (LivingEntity)this.getCubeletBox().getLocation().getWorld().spawnEntity(this.rotationLocation, EntityType.ENDERMAN);
            UtilParticles.display(Particles.FIREWORKS_SPARK, 0.35, 0.1, 0.35, this.enderman.getLocation(), 10);
            Sounds.playSound(this.getCubeletBox().getLocation(), Sounds.MySound.ENDERMAN_TELEPORT, 0.5f, 2.0f);
            if (XMaterial.supports(9)) {
                this.enderman.setCollidable(false);
            }
            if (XMaterial.supports(13)) {
                ((Enderman)this.enderman).setCarriedBlock(Bukkit.createBlockData((Material)XMaterial.CHEST.parseMaterial()));
            } else {
                ((Enderman)this.enderman).setCarriedMaterial(new MaterialData(XMaterial.CHEST.parseMaterial()));
            }
            this.enderman.setRemoveWhenFarAway(false);
            this.enderman.setMetadata("ACUBELETS", (MetadataValue)new FixedMetadataValue((Plugin)this.getMain(), (Object)Boolean.TRUE));
            NBTEditor.set(this.enderman, (byte)1, "NoAI");
            NBTEditor.set(this.enderman, (byte)1, "Silent");
            NBTEditor.set(this.enderman, (byte)1, "Invulnerable");
        }
        if (n > 50 && n < 90 && this.enderman != null) {
            this.enderman.teleport(this.rotationLocation);
        }
        if (n == 70) {
            if (this.enderman != null) {
                if (XMaterial.supports(13)) {
                    ((Enderman)this.enderman).setCarriedBlock(Bukkit.createBlockData((Material)XMaterial.AIR.parseMaterial()));
                } else {
                    ((Enderman)this.enderman).setCarriedMaterial(new MaterialData(XMaterial.AIR.parseMaterial()));
                }
            }
            Location location = this.getBoxLocation().clone().add(0.0, 0.4, 0.0);
            for (Location location2 : LocationUtils.getCircle(this.getBoxLocation().clone().add(0.0, 0.75, 0.0), 0.25, 50)) {
                Vector vector = location2.toVector().subtract(this.getBoxLocation().clone().add(0.0, 0.75, 0.0).toVector()).normalize();
                UtilParticles.display(Particles.CLOUD, vector, location, 0.3f);
            }
            this.placeOrientedChest(this.getBoxLocation());
            Sounds.playSound(this.getCubeletBox().getLocation(), Sounds.MySound.CHICKEN_EGG_POP, 0.5f, 0.0f);
        }
        if (n == 90) {
            if (this.enderman != null) {
                UtilParticles.display(Particles.FIREWORKS_SPARK, 0.35, 0.1, 0.35, this.enderman.getLocation(), 10);
                this.enderman.remove();
            }
            Sounds.playSound(this.getCubeletBox().getLocation(), Sounds.MySound.ENDERMAN_TELEPORT, 0.5f, 2.0f);
        }
        if (n == 120) {
            this.setChestOpened(this.getBoxLocation().getBlock(), true);
            Sounds.playSound(this.getCubeletBox().getLocation(), Sounds.MySound.CHEST_OPEN, 0.5f, 1.0f);
        } else if (n == 123) {
            this.doPreRewardReveal();
        }
    }

    @Override
    public void onStart() {
        this.rotationLocation = this.getLocationRotation(0.0);
        this.setAnimationBlocks(new Animation20_Blocks(this.getCubeletBox().getLocation()));
        this.startAnimationBlocks(6L);
        this.setColors(Arrays.asList(Color.BLACK, Color.PURPLE));
    }

    @Override
    public void onStop() {
        this.stopAnimationBlocks();
    }

    @Override
    public void onPreRewardReveal() {
        this.getMain().getFireworkUtil().spawn(this.getCubeletBox().getLocation().clone().add(0.5, 0.35, 0.5), FireworkEffect.Type.BALL_LARGE, this.getColors().get(0), this.getColors().get(1));
    }

    @Override
    public void onRewardReveal() {
    }

    public void placeOrientedChest(Location location) {
        BlockFace blockFace;
        switch (this.getCubeletBox().getRotation()) {
            case SOUTH: {
                blockFace = BlockFace.SOUTH;
                break;
            }
            case EAST: {
                blockFace = BlockFace.EAST;
                break;
            }
            case WEST: {
                blockFace = BlockFace.WEST;
                break;
            }
            default: {
                blockFace = BlockFace.NORTH;
            }
        }
        this.getAnimationBlocks().setStepFakeBlocks(1, new FakeBlock[]{new FakeBlock(location, XMaterial.CHEST, blockFace)});
    }

    public void setChestOpened(Block block, boolean bl) {
        PacketContainer packetContainer = new PacketContainer(PacketType.Play.Server.BLOCK_ACTION);
        packetContainer.getBlockPositionModifier().write(0, (Object)new BlockPosition(block.getX(), block.getY(), block.getZ()));
        packetContainer.getIntegers().write(0, (Object)1);
        packetContainer.getIntegers().write(1, (Object)(bl ? 1 : 0));
        packetContainer.getBlocks().write(0, (Object)block.getType());
        int n = 4096;
        Location location = block.getLocation();
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        try {
            for (Player player : block.getWorld().getPlayers()) {
                if (!(player.getLocation().distanceSquared(location) < (double)n)) continue;
                protocolManager.sendServerPacket(player, packetContainer);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }
}

