/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.animations.animation.animation6;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.ASSpawner;
import me.davidml16.acubelets.animations.Animation;
import me.davidml16.acubelets.animations.AnimationSettings;
import me.davidml16.acubelets.animations.animation.animation6.Animation6_Music;
import me.davidml16.acubelets.animations.animation.animation6.Animation6_Rabbit;
import me.davidml16.acubelets.utils.ParticlesAPI.Particles;
import me.davidml16.acubelets.utils.ParticlesAPI.UtilParticles;
import me.davidml16.acubelets.utils.XSeries.XParticle;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;

public class Animation6_Task
extends Animation {
    private ArmorStand armorStand;
    private Location armorStandLocation;
    private Location pc1;
    private Location pc2;
    private Set<Animation6_Rabbit> rabbits = new HashSet<Animation6_Rabbit>();
    private double rotSpeed = 0.1;

    public Animation6_Task(Main main, AnimationSettings animationSettings) {
        super(main, animationSettings);
    }

    @Override
    public void onTick(int n) {
        Animation6_Rabbit animation6_Rabbit;
        if (n == 0) {
            animation6_Rabbit = new Animation6_Rabbit(this.getMain(), this.getBoxLocation().clone().add(1.0, 0.0, 1.0), 135.0f);
            animation6_Rabbit.runTaskTimer((Plugin)this.getMain(), 0L, 1L);
            this.rabbits.add(animation6_Rabbit);
            this.startRunnable("music", 0L, 1L);
            this.armorStand = ASSpawner.spawn(this.getMain(), this.getCubeletBox(), this.getCubeletType(), false);
            this.armorStandLocation = this.armorStand.getLocation();
            this.getMain().getAnimationHandler().getEntities().add((Entity)this.armorStand);
        } else if (n == 10) {
            animation6_Rabbit = new Animation6_Rabbit(this.getMain(), this.getBoxLocation().clone().add(-1.0, 0.0, 1.0), -135.0f);
            animation6_Rabbit.runTaskTimer((Plugin)this.getMain(), 0L, 1L);
            this.rabbits.add(animation6_Rabbit);
        } else if (n == 20) {
            animation6_Rabbit = new Animation6_Rabbit(this.getMain(), this.getBoxLocation().clone().add(-1.0, 0.0, -1.0), -45.0f);
            animation6_Rabbit.runTaskTimer((Plugin)this.getMain(), 0L, 1L);
            this.rabbits.add(animation6_Rabbit);
        } else if (n == 30) {
            animation6_Rabbit = new Animation6_Rabbit(this.getMain(), this.getBoxLocation().clone().add(1.0, 0.0, -1.0), 45.0f);
            animation6_Rabbit.runTaskTimer((Plugin)this.getMain(), 0L, 1L);
            this.rabbits.add(animation6_Rabbit);
        }
        if (n > 0 && n < 100) {
            if (this.armorStand != null) {
                if (n <= 50) {
                    this.armorStandLocation.add(0.0, 0.02, 0.0);
                }
                this.armorStand.teleport(this.armorStandLocation);
                this.armorStand.setHeadPose(this.armorStand.getHeadPose().add(0.0, this.rotSpeed, 0.0));
                this.rotSpeed += 0.003;
                this.drawCircle(this.armorStandLocation.clone().add(0.0, 0.6, 0.0), 0.3);
            }
            for (int i = 0; i < 3; ++i) {
                Color color = XParticle.randomColor();
                UtilParticles.display(color.getRed(), color.getBlue(), color.getGreen(), this.getRandomLocation(this.pc1, this.pc2));
            }
        }
        if (n == 98) {
            this.doPreRewardReveal();
        }
    }

    @Override
    public void onStart() {
        this.addRunnable("music", new Animation6_Music(this.getCubeletBox().getLocation()));
        this.setColors(Arrays.asList(Color.YELLOW, Color.YELLOW));
        this.pc1 = this.getCubeletBox().getLocation().clone().add(-2.5, -1.0, -2.5);
        this.pc2 = this.getCubeletBox().getLocation().clone().add(2.5, 3.5, 2.5);
    }

    @Override
    public void onStop() {
        this.cancelRunnables();
        try {
            for (Animation6_Rabbit animation6_Rabbit : this.rabbits) {
                animation6_Rabbit.cancel();
                if (!this.getMain().getAnimationHandler().getEntities().contains(animation6_Rabbit.getEntity())) continue;
                Entity entity = animation6_Rabbit.getEntity();
                if (entity != null) {
                    entity.remove();
                }
                this.getMain().getAnimationHandler().getEntities().remove(entity);
            }
        }
        catch (IllegalStateException | NullPointerException runtimeException) {
            // empty catch block
        }
        if (this.getMain().getAnimationHandler().getEntities().contains(this.armorStand)) {
            if (this.armorStand != null) {
                this.armorStand.remove();
            }
            this.getMain().getAnimationHandler().getEntities().remove(this.armorStand);
        }
    }

    @Override
    public void onPreRewardReveal() {
        this.getMain().getFireworkUtil().spawn(this.getCubeletBox().getLocation().clone().add(0.5, 1.5, 0.5), FireworkEffect.Type.STAR, this.getColors().get(0), this.getColors().get(1));
    }

    @Override
    public void onRewardReveal() {
        this.cancelRunnable("music");
        this.armorStand.remove();
        this.armorStand = null;
        for (Animation6_Rabbit animation6_Rabbit : this.rabbits) {
            animation6_Rabbit.cancel();
            if (!this.getMain().getAnimationHandler().getEntities().contains(animation6_Rabbit.getEntity())) continue;
            Entity entity = animation6_Rabbit.getEntity();
            if (entity != null) {
                entity.remove();
            }
            this.getMain().getAnimationHandler().getEntities().remove(entity);
        }
    }

    private void drawCircle(Location location, double d) {
        for (int i = 0; i < 10; ++i) {
            double d2 = Math.PI * 2 * (double)i / 10.0;
            Location location2 = location.clone().add(d * Math.sin(d2), 0.0, d * Math.cos(d2));
            Particles.REDSTONE.display((Particles.ParticleColor)new Particles.OrdinaryColor(Color.LIME), location2, 128.0);
        }
    }

    public Location getRandomLocation(Location location, Location location2) {
        double d = Math.min(location.getX(), location2.getX());
        double d2 = Math.min(location.getY(), location2.getY());
        double d3 = Math.min(location.getZ(), location2.getZ());
        double d4 = Math.max(location.getX(), location2.getX());
        double d5 = Math.max(location.getY(), location2.getY());
        double d6 = Math.max(location.getZ(), location2.getZ());
        return new Location(location.getWorld(), this.randomDouble(d, d4), this.randomDouble(d2, d5), this.randomDouble(d3, d6));
    }

    public double randomDouble(double d, double d2) {
        return d + ThreadLocalRandom.current().nextDouble(Math.abs(d2 - d + 1.0));
    }
}

