/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.conversation;

import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.utils.Sounds;
import me.davidml16.acubelets.utils.Utils;
import org.apache.commons.lang.math.NumberUtils;
import org.bukkit.ChatColor;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.entity.Player;

public interface CommonPrompts {

    public static class ErrorPrompt
    extends StringPrompt {
        private Prompt parent;
        private String text;
        private Main main;

        public ErrorPrompt(Main main, Prompt prompt, String string) {
            this.main = main;
            this.parent = prompt;
            this.text = string;
        }

        public String getPromptText(ConversationContext conversationContext) {
            Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.NOTE_PLING, 10.0f, 0.0f);
            return this.text;
        }

        public Prompt acceptInput(ConversationContext conversationContext, String string) {
            conversationContext.getForWhom().sendRawMessage(this.text);
            return this.parent;
        }
    }

    public static class ConfirmExitPrompt
    extends StringPrompt {
        private Prompt parent;
        private Main main;

        public ConfirmExitPrompt(Main main, Prompt prompt) {
            this.main = main;
            this.parent = prompt;
        }

        public String getPromptText(ConversationContext conversationContext) {
            String string = ChatColor.GREEN + "  1 " + ChatColor.GRAY + "- Yes\n" + ChatColor.RED + "  2 " + ChatColor.GRAY + "- No\n ";
            return ChatColor.YELLOW + "\n Are you sure you want to exit without saving?\n \n" + string;
        }

        public Prompt acceptInput(ConversationContext conversationContext, String string) {
            if (string.equals("1") || string.equalsIgnoreCase("Yes")) {
                conversationContext.getForWhom().sendRawMessage("\n" + Utils.translate(this.main.getLanguageHandler().getPrefix() + " &cYou leave type setup menu!"));
                Main.get().getConversationHandler().removeConversation((Player)conversationContext.getSessionData((Object)"player"));
                return Prompt.END_OF_CONVERSATION;
            }
            if (string.equals("2") || string.equalsIgnoreCase("No")) {
                return this.parent;
            }
            conversationContext.getForWhom().sendRawMessage(ChatColor.RED + "  That's not a valid option!\n");
            Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.NOTE_PLING, 10.0f, 0.0f);
            return this;
        }
    }

    public static class IntegerPrompt
    extends StringPrompt {
        private Prompt parentPrompt;
        private String text;
        private String storeValue;
        private Main main;

        public IntegerPrompt(Main main, Prompt prompt, String string, String string2) {
            this.main = main;
            this.parentPrompt = prompt;
            this.text = string;
            this.storeValue = string2;
        }

        public String getPromptText(ConversationContext conversationContext) {
            return this.text;
        }

        public Prompt acceptInput(ConversationContext conversationContext, String string) {
            if (string.trim().equalsIgnoreCase("cancel")) {
                return this.parentPrompt;
            }
            if (string.contains(" ")) {
                conversationContext.getForWhom().sendRawMessage(ChatColor.RED + "  Spaces are not allowed!\n ");
                Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.NOTE_PLING, 10.0f, 0.0f);
                return this;
            }
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                conversationContext.getForWhom().sendRawMessage(ChatColor.RED + "  Invalid number!\n ");
                Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.NOTE_PLING, 10.0f, 0.0f);
                return this;
            }
            conversationContext.setSessionData((Object)this.storeValue, (Object)n);
            Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.CLICK, 10.0f, 2.0f);
            return this.parentPrompt;
        }
    }

    public static class BooleanPrompt
    extends StringPrompt {
        private Prompt parentPrompt;
        private String text;
        private String storeValue;
        private Main main;

        public BooleanPrompt(Main main, Prompt prompt, String string, String string2) {
            this.main = main;
            this.parentPrompt = prompt;
            this.text = string;
            this.storeValue = string2;
        }

        public String getPromptText(ConversationContext conversationContext) {
            return this.text;
        }

        public Prompt acceptInput(ConversationContext conversationContext, String string) {
            if (string.trim().equalsIgnoreCase("cancel")) {
                return this.parentPrompt;
            }
            if (string.contains(" ")) {
                conversationContext.getForWhom().sendRawMessage(ChatColor.RED + "  Spaces are not allowed!\n ");
                Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.NOTE_PLING, 10.0f, 0.0f);
                return this;
            }
            if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("false")) {
                conversationContext.setSessionData((Object)this.storeValue, (Object)Boolean.parseBoolean(string.toLowerCase()));
                Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.CLICK, 10.0f, 2.0f);
                return this.parentPrompt;
            }
            conversationContext.getForWhom().sendRawMessage(ChatColor.RED + "  That's not a valid option!\n ");
            Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.NOTE_PLING, 10.0f, 0.0f);
            return this;
        }
    }

    public static class NumericIntegerRangePrompt
    extends StringPrompt {
        private Prompt parentPrompt;
        private String text;
        private String storeValue;
        private int minValue;
        private int maxValue;
        private boolean hasRange;
        private Main main;

        public NumericIntegerRangePrompt(Main main, Prompt prompt, String string, String string2, int n, int n2) {
            this.main = main;
            this.parentPrompt = prompt;
            this.text = string;
            this.storeValue = string2;
            this.minValue = n;
            this.maxValue = n2;
            this.hasRange = true;
        }

        public NumericIntegerRangePrompt(Prompt prompt, String string, String string2) {
            this.parentPrompt = prompt;
            this.text = string;
            this.storeValue = string2;
            this.hasRange = false;
        }

        public String getPromptText(ConversationContext conversationContext) {
            return this.text;
        }

        public Prompt acceptInput(ConversationContext conversationContext, String string) {
            if (string.equalsIgnoreCase("cancel")) {
                return this.parentPrompt;
            }
            if (!NumberUtils.isNumber((String)string)) {
                conversationContext.getForWhom().sendRawMessage(ChatColor.RED + "  That's not a valid number!\n ");
                return this;
            }
            int n = Integer.parseInt(string);
            if (this.hasRange && (n < this.minValue || n > this.maxValue)) {
                conversationContext.getForWhom().sendRawMessage(ChatColor.RED + "  The value must be between " + this.minValue + " and " + this.maxValue + "!\n ");
                return this;
            }
            conversationContext.setSessionData((Object)this.storeValue, (Object)n);
            Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.CLICK, 10.0f, 2.0f);
            return this.parentPrompt;
        }
    }

    public static class NumericRangePrompt
    extends StringPrompt {
        private Prompt parentPrompt;
        private String text;
        private String storeValue;
        private double minValue;
        private double maxValue;
        private boolean hasRange;
        private Main main;

        public NumericRangePrompt(Main main, Prompt prompt, String string, String string2, double d, double d2) {
            this.main = main;
            this.parentPrompt = prompt;
            this.text = string;
            this.storeValue = string2;
            this.minValue = d;
            this.maxValue = d2;
            this.hasRange = true;
        }

        public NumericRangePrompt(Prompt prompt, String string, String string2) {
            this.parentPrompt = prompt;
            this.text = string;
            this.storeValue = string2;
            this.hasRange = false;
        }

        public String getPromptText(ConversationContext conversationContext) {
            return this.text;
        }

        public Prompt acceptInput(ConversationContext conversationContext, String string) {
            if (string.equalsIgnoreCase("cancel")) {
                return this.parentPrompt;
            }
            if (!NumberUtils.isNumber((String)string)) {
                conversationContext.getForWhom().sendRawMessage(ChatColor.RED + "  That's not a valid number!\n ");
                return this;
            }
            double d = Double.parseDouble(string);
            if (this.hasRange && (d < this.minValue || d > this.maxValue)) {
                conversationContext.getForWhom().sendRawMessage(ChatColor.RED + "  The value must be between " + this.minValue + " and " + this.maxValue + "!\n ");
                return this;
            }
            conversationContext.setSessionData((Object)this.storeValue, (Object)d);
            Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.CLICK, 10.0f, 2.0f);
            return this.parentPrompt;
        }
    }

    public static class MineSkinStringPrompt
    extends StringPrompt {
        private Prompt parentPrompt;
        private String text;
        private String storeValue;
        private boolean allowSpaces;
        private Main main;

        public MineSkinStringPrompt(Main main, Prompt prompt, boolean bl, String string, String string2) {
            this.main = main;
            this.parentPrompt = prompt;
            this.allowSpaces = bl;
            this.text = string;
            this.storeValue = string2;
        }

        public MineSkinStringPrompt(Prompt prompt, String string, String string2) {
            this(null, prompt, true, string, string2);
        }

        public String getPromptText(ConversationContext conversationContext) {
            return this.text;
        }

        public Prompt acceptInput(ConversationContext conversationContext, String string) {
            if (string.trim().equalsIgnoreCase("cancel")) {
                return this.parentPrompt;
            }
            if (!this.allowSpaces && string.contains(" ")) {
                conversationContext.getForWhom().sendRawMessage(ChatColor.RED + "  Spaces are not allowed!\n ");
                Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.NOTE_PLING, 10.0f, 0.0f);
                return this;
            }
            if (!string.contains("minesk.in")) {
                conversationContext.getForWhom().sendRawMessage(ChatColor.RED + "  Invalid Mineskin direct link!\n ");
                Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.NOTE_PLING, 10.0f, 0.0f);
                return this;
            }
            conversationContext.setSessionData((Object)this.storeValue, (Object)string);
            conversationContext.getForWhom().sendRawMessage(ChatColor.GREEN + "  Succesfully setup skull texture with method " + ChatColor.YELLOW + conversationContext.getSessionData((Object)"method"));
            Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.CLICK, 10.0f, 2.0f);
            return this.parentPrompt;
        }
    }

    public static class SkullStringPrompt
    extends StringPrompt {
        private Prompt parentPrompt;
        private String text;
        private String storeValue;
        private boolean allowSpaces;
        private Main main;

        public SkullStringPrompt(Main main, Prompt prompt, boolean bl, String string, String string2) {
            this.main = main;
            this.parentPrompt = prompt;
            this.allowSpaces = bl;
            this.text = string;
            this.storeValue = string2;
        }

        public SkullStringPrompt(Prompt prompt, String string, String string2) {
            this(null, prompt, true, string, string2);
        }

        public String getPromptText(ConversationContext conversationContext) {
            return this.text;
        }

        public Prompt acceptInput(ConversationContext conversationContext, String string) {
            if (string.trim().equalsIgnoreCase("cancel")) {
                return this.parentPrompt;
            }
            if (!this.allowSpaces && string.contains(" ")) {
                conversationContext.getForWhom().sendRawMessage(ChatColor.RED + "  Spaces are not allowed!\n ");
                Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.NOTE_PLING, 10.0f, 0.0f);
                return this;
            }
            conversationContext.setSessionData((Object)this.storeValue, (Object)string);
            conversationContext.getForWhom().sendRawMessage(ChatColor.GREEN + "  Succesfully setup skull texture with method " + ChatColor.YELLOW + conversationContext.getSessionData((Object)"method"));
            Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.CLICK, 10.0f, 2.0f);
            return this.parentPrompt;
        }
    }

    public static class UncoloredStringPrompt
    extends StringPrompt {
        private Prompt parentPrompt;
        private String text;
        private String storeValue;
        private boolean allowSpaces;
        private Main main;

        public UncoloredStringPrompt(Main main, Prompt prompt, boolean bl, String string, String string2) {
            this.main = main;
            this.parentPrompt = prompt;
            this.allowSpaces = bl;
            this.text = string;
            this.storeValue = string2;
        }

        public UncoloredStringPrompt(Prompt prompt, String string, String string2) {
            this(null, prompt, true, string, string2);
        }

        public String getPromptText(ConversationContext conversationContext) {
            return this.text;
        }

        public Prompt acceptInput(ConversationContext conversationContext, String string) {
            if (string.trim().equalsIgnoreCase("cancel")) {
                return this.parentPrompt;
            }
            if (!this.allowSpaces && string.contains(" ")) {
                conversationContext.getForWhom().sendRawMessage(ChatColor.RED + "  Spaces are not allowed!\n ");
                Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.NOTE_PLING, 10.0f, 0.0f);
                return this;
            }
            if (string.contains("&") || string.contains("\u00a7")) {
                conversationContext.getForWhom().sendRawMessage(ChatColor.RED + "  Color codes are not allowed!\n ");
                Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.NOTE_PLING, 10.0f, 0.0f);
                return this;
            }
            conversationContext.setSessionData((Object)this.storeValue, (Object)string);
            Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.CLICK, 10.0f, 2.0f);
            return this.parentPrompt;
        }
    }

    public static class DuplicateRangeStringPrompt
    extends StringPrompt {
        private Prompt parentPrompt;
        private String text;
        private String storeValue;
        private boolean allowSpaces;
        private Main main;

        public DuplicateRangeStringPrompt(Main main, Prompt prompt, boolean bl, String string, String string2) {
            this.main = main;
            this.parentPrompt = prompt;
            this.allowSpaces = bl;
            this.text = string;
            this.storeValue = string2;
        }

        public DuplicateRangeStringPrompt(Prompt prompt, String string, String string2) {
            this(null, prompt, true, string, string2);
        }

        public String getPromptText(ConversationContext conversationContext) {
            return this.text;
        }

        public Prompt acceptInput(ConversationContext conversationContext, String string) {
            if (string.trim().equalsIgnoreCase("cancel")) {
                return this.parentPrompt;
            }
            if (!this.allowSpaces && string.contains(" ")) {
                conversationContext.getForWhom().sendRawMessage(ChatColor.RED + "  Spaces are not allowed!\n ");
                Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.NOTE_PLING, 10.0f, 0.0f);
                return this;
            }
            if (!string.contains("-") || string.split("-").length != 2) {
                conversationContext.getForWhom().sendRawMessage(ChatColor.RED + "  Format: min-max\n ");
                Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.NOTE_PLING, 10.0f, 0.0f);
                return this;
            }
            conversationContext.setSessionData((Object)this.storeValue, (Object)string);
            Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.CLICK, 10.0f, 2.0f);
            return this.parentPrompt;
        }
    }

    public static class CommonStringPrompt
    extends StringPrompt {
        private Prompt parentPrompt;
        private String text;
        private String storeValue;
        private boolean allowSpaces;
        private Main main;

        public CommonStringPrompt(Main main, Prompt prompt, boolean bl, String string, String string2) {
            this.main = main;
            this.parentPrompt = prompt;
            this.allowSpaces = bl;
            this.text = string;
            this.storeValue = string2;
        }

        public CommonStringPrompt(Prompt prompt, String string, String string2) {
            this(null, prompt, true, string, string2);
        }

        public String getPromptText(ConversationContext conversationContext) {
            return this.text;
        }

        public Prompt acceptInput(ConversationContext conversationContext, String string) {
            if (string.trim().equalsIgnoreCase("cancel")) {
                return this.parentPrompt;
            }
            if (!this.allowSpaces && string.contains(" ")) {
                conversationContext.getForWhom().sendRawMessage(ChatColor.RED + "  Spaces are not allowed!\n ");
                Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.NOTE_PLING, 10.0f, 0.0f);
                return this;
            }
            conversationContext.setSessionData((Object)this.storeValue, (Object)string);
            Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.CLICK, 10.0f, 2.0f);
            return this.parentPrompt;
        }
    }
}

