/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.conversation.options;

import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.AnimationSettings;
import me.davidml16.acubelets.conversation.CommonPrompts;
import me.davidml16.acubelets.menus.admin.options.OptionsAnimationsMenu;
import me.davidml16.acubelets.objects.Menu;
import org.bukkit.ChatColor;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.FixedSetPrompt;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RenameAnimationConversation
implements ConversationAbandonedListener,
CommonPrompts {
    private Main main;

    public RenameAnimationConversation(Main main) {
        this.main = main;
    }

    public Conversation getConversation(Player player, AnimationSettings animationSettings) {
        Conversation conversation = new ConversationFactory((Plugin)this.main).withModality(true).withLocalEcho(false).withFirstPrompt((Prompt)new RenameMenuOptions()).withTimeout(3600).thatExcludesNonPlayersWithMessage("").addConversationAbandonedListener((ConversationAbandonedListener)this).buildConversation((Conversable)player);
        conversation.getContext().setSessionData((Object)"player", (Object)player);
        conversation.getContext().setSessionData((Object)"animationSettings", (Object)animationSettings);
        conversation.getContext().setSessionData((Object)"animationName", (Object)animationSettings.getDisplayName());
        this.main.getConversationHandler().addConversation(player);
        return conversation;
    }

    public Conversation getConversation(Player player) {
        return this.getConversation(player, null);
    }

    public void conversationAbandoned(ConversationAbandonedEvent conversationAbandonedEvent) {
    }

    public class RenameMenuOptions
    extends FixedSetPrompt {
        RenameMenuOptions() {
            super(new String[]{"1", "2"});
        }

        protected Prompt acceptValidatedInput(ConversationContext conversationContext, String string) {
            AnimationSettings animationSettings = (AnimationSettings)conversationContext.getSessionData((Object)"animationSettings");
            Player player = (Player)conversationContext.getSessionData((Object)"player");
            switch (string) {
                case "1": {
                    return new CommonPrompts.CommonStringPrompt(RenameAnimationConversation.this.main, (Prompt)this, true, ChatColor.YELLOW + "  Enter animation display name, \"cancel\" to return.\n\n ", "animationName");
                }
                case "2": {
                    String string2 = (String)conversationContext.getSessionData((Object)"animationName");
                    animationSettings.setDisplayName(string2);
                    RenameAnimationConversation.this.main.getAnimationHandler().saveAnimations();
                    RenameAnimationConversation.this.main.getMenuHandler().reloadAllMenus(OptionsAnimationsMenu.class);
                    OptionsAnimationsMenu optionsAnimationsMenu = new OptionsAnimationsMenu(RenameAnimationConversation.this.main, player);
                    optionsAnimationsMenu.setAttribute(Menu.AttrType.ANIMATION_SETTINGS_ATTR, animationSettings);
                    optionsAnimationsMenu.open();
                    RenameAnimationConversation.this.main.getConversationHandler().removeConversation(player);
                    return Prompt.END_OF_CONVERSATION;
                }
            }
            return null;
        }

        public String getPromptText(ConversationContext conversationContext) {
            String string = "";
            string = string + ChatColor.GOLD + "" + ChatColor.BOLD + "\n  ANIMATION RENAME MENU\n";
            string = string + ChatColor.GREEN + " \n";
            string = string + ChatColor.GREEN + "    1 " + ChatColor.GRAY + "- Change animation display name (" + ChatColor.YELLOW + ChatColor.translateAlternateColorCodes((char)'&', (String)((String)conversationContext.getSessionData((Object)"animationName"))) + ChatColor.GRAY + ")\n";
            string = string + ChatColor.GREEN + "    2 " + ChatColor.GRAY + "- Save and exit\n";
            string = string + ChatColor.GREEN + " \n";
            string = string + ChatColor.GOLD + "" + ChatColor.YELLOW + "  Choose the option: \n";
            string = string + ChatColor.GREEN + " \n";
            return string;
        }
    }
}

