/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.handlers;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.api.CubeletReceivedEvent;
import me.davidml16.acubelets.database.DatabaseHandler;
import me.davidml16.acubelets.menus.player.CubeletsMenu;
import me.davidml16.acubelets.menus.player.crafting.CraftingMenu;
import me.davidml16.acubelets.menus.player.gifts.GiftCubeletMenu;
import me.davidml16.acubelets.menus.player.gifts.GiftMenu;
import me.davidml16.acubelets.objects.Cubelet;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.Profile;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class TransactionHandler {
    private Main main;

    public TransactionHandler(Main main) {
        this.main = main;
    }

    public void giveCubelet(String string, String string3, int n, DatabaseHandler.Callback<CubeletType> callback) {
        if (Bukkit.getPlayer((String)string) != null) {
            UUID uUID = Bukkit.getPlayer((String)string).getUniqueId();
            callback.done(this.giveCubelet(uUID, string3, n));
        } else {
            try {
                this.main.getDatabaseHandler().getPlayerUUID(string, string2 -> {
                    UUID uUID = UUID.fromString(string2);
                    try {
                        callback.done(this.giveCubelet(uUID, string3, n));
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                });
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    public CubeletType giveCubelet(UUID uUID, String string, int n) {
        if (this.main.getCubeletTypesHandler().getTypes().containsKey(string) || string.equalsIgnoreCase("random")) {
            ArrayList<CubeletType> arrayList;
            CubeletType cubeletType = null;
            if (!string.equalsIgnoreCase("random")) {
                cubeletType = this.main.getCubeletTypesHandler().getTypeBydId(string);
            } else {
                arrayList = new ArrayList<CubeletType>(this.main.getCubeletTypesHandler().getTypes().values());
                cubeletType = (CubeletType)arrayList.get((int)(Math.random() * (double)arrayList.size()));
            }
            arrayList = new ArrayList();
            if (n > 0) {
                for (int i = 1; i <= n; ++i) {
                    arrayList.add((CubeletType)((Object)new Cubelet(cubeletType)));
                }
                this.main.getDatabaseHandler().addCubelets(uUID, arrayList);
                if (Bukkit.getPlayer((UUID)uUID) != null) {
                    Player player = Bukkit.getPlayer((UUID)uUID);
                    this.main.getPlayerDataHandler().getData(Objects.requireNonNull(player)).getCubelets().addAll(arrayList);
                    Bukkit.getScheduler().runTask((Plugin)this.main, () -> {
                        this.main.getMenuHandler().reloadAllMenus(player, CubeletsMenu.class);
                        this.main.getMenuHandler().reloadAllMenus(player, CraftingMenu.class);
                        this.main.getMenuHandler().reloadAllMenus(player, GiftMenu.class);
                        this.main.getMenuHandler().reloadAllMenus(player, GiftCubeletMenu.class);
                        this.main.getHologramImplementation().reloadHolograms(player);
                        Bukkit.getPluginManager().callEvent((Event)new CubeletReceivedEvent(player, this.main.getCubeletTypesHandler().getTypeBydId(string), n));
                    });
                }
            }
            return cubeletType;
        }
        return null;
    }

    public void removeCubelet(String string, String string3, int n) {
        if (Bukkit.getPlayer((String)string) != null) {
            UUID uUID = Bukkit.getPlayer((String)string).getUniqueId();
            this.removeCubelet(uUID, string3, n);
        } else {
            try {
                this.main.getDatabaseHandler().getPlayerUUID(string, string2 -> {
                    UUID uUID = UUID.fromString(string2);
                    try {
                        this.removeCubelet(uUID, string3, n);
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                });
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    public void removeCubelet(UUID uUID, String string, int n) {
        if (this.main.getCubeletTypesHandler().getTypes().containsKey(string) && n > 0) {
            if (Bukkit.getPlayer((UUID)uUID) != null) {
                Player player = Bukkit.getPlayer((UUID)uUID);
                Profile profile = this.main.getPlayerDataHandler().getData(player);
                ArrayList<Cubelet> arrayList = new ArrayList<Cubelet>();
                for (int i = 1; i <= n; ++i) {
                    Optional<Cubelet> optional = profile.getCubelets().stream().filter(cubelet -> cubelet.getType().equalsIgnoreCase(string)).findFirst();
                    if (!optional.isPresent()) continue;
                    Cubelet cubelet2 = optional.get();
                    arrayList.add(cubelet2);
                    profile.getCubelets().remove(cubelet2);
                }
                Bukkit.getScheduler().runTask((Plugin)this.main, () -> {
                    this.main.getMenuHandler().reloadAllMenus(player, CubeletsMenu.class);
                    this.main.getMenuHandler().reloadAllMenus(player, CraftingMenu.class);
                    this.main.getMenuHandler().reloadAllMenus(player, GiftMenu.class);
                    this.main.getHologramImplementation().reloadHolograms(player);
                });
                this.main.getDatabaseHandler().removeCubelets(uUID, arrayList);
            } else {
                this.main.getDatabaseHandler().removeCubelet(uUID, string, n);
            }
        }
    }

    public void transferCubelets(UUID uUID, UUID uUID2, CubeletType cubeletType, int n) {
        if (this.main.getCubeletTypesHandler().getTypes().containsKey(cubeletType.getId())) {
            try {
                this.removeCubelet(uUID, cubeletType.getId(), n);
                this.giveCubelet(uUID2, cubeletType.getId(), n);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    public void givePoints(String string2, int n) {
        if (Bukkit.getPlayer((String)string2) != null) {
            UUID uUID = Bukkit.getPlayer((String)string2).getUniqueId();
            this.givePoints(uUID, n);
        } else {
            try {
                this.main.getDatabaseHandler().getPlayerUUID(string2, string -> {
                    UUID uUID = UUID.fromString(string);
                    try {
                        this.givePoints(uUID, n);
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                });
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    public void givePoints(UUID uUID, int n) {
        if (Bukkit.getPlayer((UUID)uUID) != null) {
            this.main.getPlayerDataHandler().getData(uUID).setLootPoints(this.main.getPlayerDataHandler().getData(uUID).getLootPoints() + (long)n);
            Bukkit.getScheduler().runTask((Plugin)this.main, () -> {
                Player player = Bukkit.getPlayer((UUID)uUID);
                this.main.getMenuHandler().reloadAllMenus(player, CubeletsMenu.class);
                this.main.getMenuHandler().reloadAllMenus(player, CraftingMenu.class);
                this.main.getMenuHandler().reloadAllMenus(player, GiftMenu.class);
                this.main.getMenuHandler().reloadAllMenus(player, GiftCubeletMenu.class);
            });
        }
        this.main.getDatabaseHandler().getPlayerLootPoints(uUID, l -> this.main.getDatabaseHandler().setPlayerLootPoints(uUID, l + (long)n));
    }

    public void removePoints(String string2, int n) {
        if (Bukkit.getPlayer((String)string2) != null) {
            UUID uUID = Bukkit.getPlayer((String)string2).getUniqueId();
            this.removePoints(uUID, n);
        } else {
            try {
                this.main.getDatabaseHandler().getPlayerUUID(string2, string -> {
                    UUID uUID = UUID.fromString(string);
                    try {
                        this.removePoints(uUID, n);
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                });
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    public void removePoints(UUID uUID, int n) {
        if (Bukkit.getPlayer((UUID)uUID) != null) {
            if (this.main.getPlayerDataHandler().getData(uUID).getLootPoints() - (long)n < 0L) {
                this.main.getPlayerDataHandler().getData(uUID).setLootPoints(0L);
            } else {
                this.main.getPlayerDataHandler().getData(uUID).setLootPoints(this.main.getPlayerDataHandler().getData(uUID).getLootPoints() - (long)n);
            }
            Bukkit.getScheduler().runTask((Plugin)this.main, () -> {
                Player player = Bukkit.getPlayer((UUID)uUID);
                this.main.getMenuHandler().reloadAllMenus(player, CubeletsMenu.class);
                this.main.getMenuHandler().reloadAllMenus(player, CraftingMenu.class);
                this.main.getMenuHandler().reloadAllMenus(player, GiftMenu.class);
                this.main.getMenuHandler().reloadAllMenus(player, GiftCubeletMenu.class);
            });
        }
        this.main.getDatabaseHandler().getPlayerLootPoints(uUID, l -> {
            if (l - (long)n < 0L) {
                this.main.getDatabaseHandler().setPlayerLootPoints(uUID, 0L);
            } else {
                this.main.getDatabaseHandler().setPlayerLootPoints(uUID, l - (long)n);
            }
        });
    }

    public void setPoints(String string2, int n) {
        if (Bukkit.getPlayer((String)string2) != null) {
            UUID uUID = Bukkit.getPlayer((String)string2).getUniqueId();
            this.setPoints(uUID, n);
        } else {
            try {
                this.main.getDatabaseHandler().getPlayerUUID(string2, string -> {
                    UUID uUID = UUID.fromString(string);
                    try {
                        this.setPoints(uUID, n);
                    }
                    catch (SQLException sQLException) {
                        sQLException.printStackTrace();
                    }
                });
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }

    public void setPoints(UUID uUID, int n) {
        if (Bukkit.getPlayer((UUID)uUID) != null) {
            this.main.getPlayerDataHandler().getData(uUID).setLootPoints(n);
            Bukkit.getScheduler().runTask((Plugin)this.main, () -> {
                Player player = Bukkit.getPlayer((UUID)uUID);
                this.main.getMenuHandler().reloadAllMenus(player, CubeletsMenu.class);
                this.main.getMenuHandler().reloadAllMenus(player, CraftingMenu.class);
                this.main.getMenuHandler().reloadAllMenus(player, GiftMenu.class);
                this.main.getMenuHandler().reloadAllMenus(player, GiftCubeletMenu.class);
            });
        }
        this.main.getDatabaseHandler().setPlayerLootPoints(uUID, n);
    }
}

