/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.holograms;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.holograms.HologramImplementation;
import me.davidml16.acubelets.holograms.implementations.DecentHologramsImpl;
import me.davidml16.acubelets.holograms.implementations.HolographicDisplaysImpl;
import me.davidml16.acubelets.objects.ColorAnimation;
import me.davidml16.acubelets.objects.CubeletOpener;
import me.davidml16.acubelets.objects.rewards.Reward;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.entity.Player;

public class HologramHandler {
    private Main main;
    private HologramImplementation implementation;
    private ColorAnimation colorAnimation;
    private String actualColor;
    private int visibilityDistance = 75;

    public HologramHandler(Main main) {
        this.main = main;
        this.colorAnimation = new ColorAnimation();
        this.actualColor = "&c";
        if (main.getServer().getPluginManager().isPluginEnabled("HolographicDisplays")) {
            this.implementation = new HolographicDisplaysImpl(main, this);
        } else if (main.getServer().getPluginManager().isPluginEnabled("DecentHolograms")) {
            this.implementation = new DecentHologramsImpl(main, this);
        }
    }

    public HologramImplementation getImplementation() {
        return this.implementation;
    }

    public ColorAnimation getColorAnimation() {
        return this.colorAnimation;
    }

    public void setColorAnimation(ColorAnimation colorAnimation) {
        this.colorAnimation = colorAnimation;
    }

    public String getActualColor() {
        return this.actualColor;
    }

    public void setActualColor(String string) {
        this.actualColor = string;
    }

    public int getVisibilityDistance() {
        return this.visibilityDistance;
    }

    public void setVisibilityDistance(int n) {
        this.visibilityDistance = n;
    }

    public List<String> getLines(Player player) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        if (this.main.getPlayerDataHandler().getPlayersData().containsKey(player.getUniqueId())) {
            n = this.main.getPlayerDataHandler().getData(player).getCubelets().size();
        }
        if (n > 0) {
            for (String string : this.main.getLanguageHandler().getMessageList("Holograms.CubeletAvailable")) {
                arrayList.add(Utils.translate(string.replaceAll("%blink%", this.actualColor).replaceAll("%cubelets_available%", String.valueOf(n))));
            }
        } else {
            for (String string : this.main.getLanguageHandler().getMessageList("Holograms.NoCubeletAvailable")) {
                arrayList.add(Utils.translate(string.replaceAll("%blink%", this.actualColor).replaceAll("%cubelets_available%", String.valueOf(n))));
            }
        }
        return arrayList;
    }

    public List<String> getLinesReward(Player player, CubeletOpener cubeletOpener, Reward reward) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (player.getUniqueId().equals(cubeletOpener.getUuid())) {
            for (String string : this.main.getLanguageHandler().getMessageList("Holograms.Reward.New.Me")) {
                arrayList.add(Utils.translate(string.replaceAll("%player%", cubeletOpener.getName()).replaceAll("%reward_name%", Matcher.quoteReplacement(reward.getName())).replaceAll("%cubelet_type%", Matcher.quoteReplacement(Utils.removeColors(reward.getParentCubelet().getName()))).replaceAll("%reward_rarity%", Matcher.quoteReplacement(reward.getRarity().getName()))));
            }
        } else {
            for (String string : this.main.getLanguageHandler().getMessageList("Holograms.Reward.New.Other")) {
                arrayList.add(Utils.translate(string.replaceAll("%player%", cubeletOpener.getName()).replaceAll("%reward_name%", Matcher.quoteReplacement(reward.getName())).replaceAll("%cubelet_type%", Matcher.quoteReplacement(Utils.removeColors(reward.getParentCubelet().getName()))).replaceAll("%reward_rarity%", Matcher.quoteReplacement(reward.getRarity().getName()))));
            }
        }
        return arrayList;
    }

    public List<String> getLinesRewardDuplicated(Reward reward, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.main.getLanguageHandler().getMessageList("Holograms.Reward.Duplicate")) {
            arrayList.add(Utils.translate(string.replaceAll("%points%", "" + n).replaceAll("%reward_name%", Matcher.quoteReplacement(reward.getName())).replaceAll("%cubelet_type%", Matcher.quoteReplacement(Utils.removeColors(reward.getParentCubelet().getName()))).replaceAll("%reward_rarity%", Matcher.quoteReplacement(reward.getRarity().getName()))));
        }
        return arrayList;
    }
}

