/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.holograms.implementations;

import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import eu.decentsoftware.holograms.api.holograms.HologramPage;
import eu.decentsoftware.holograms.api.utils.items.HologramItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.enums.CubeletBoxState;
import me.davidml16.acubelets.holograms.HologramHandler;
import me.davidml16.acubelets.holograms.HologramImplementation;
import me.davidml16.acubelets.objects.CubeletMachine;
import me.davidml16.acubelets.objects.rewards.Reward;
import me.davidml16.acubelets.utils.RepeatingTask;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class DecentHologramsImpl
implements HologramImplementation,
Listener {
    private Main main;
    private HologramHandler hologramHandler;
    private static final double LINE_HEIGHT = 0.36;
    private static final double LINE_HEIGHT_REWARD = 0.32;
    private HashMap<CubeletMachine, HashMap<UUID, Hologram>> holograms;

    public DecentHologramsImpl(Main main, HologramHandler hologramHandler) {
        this.main = main;
        this.hologramHandler = hologramHandler;
        this.holograms = new HashMap();
    }

    @Override
    public void loadHolograms() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.loadHolograms(player);
        }
    }

    @Override
    public void loadHolograms(Player player) {
        for (CubeletMachine cubeletMachine : this.main.getCubeletBoxHandler().getBoxes().values()) {
            this.loadHolograms(player, cubeletMachine);
        }
    }

    @Override
    public void loadHolograms(CubeletMachine cubeletMachine) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.loadHolograms(player, cubeletMachine);
        }
    }

    @Override
    public void removeHolograms() {
        for (Hologram hologram : Hologram.getCachedHolograms()) {
            hologram.hideAll();
            hologram.destroy();
        }
    }

    @Override
    public void reloadHolograms() {
        this.hologramHandler.setActualColor(this.hologramHandler.getColorAnimation().nextColor());
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.reloadHolograms(player);
        }
    }

    @Override
    public void loadHolograms(Player player, CubeletMachine cubeletMachine) {
        Hologram hologram = DHAPI.createHologram((String)UUID.randomUUID().toString(), (Location)cubeletMachine.getLocation().clone().add(0.5, 1.025 + (cubeletMachine.getBlockHeight() + 0.1875), 0.5));
        hologram.setDefaultVisibleState(false);
        hologram.setShowPlayer(player);
        if (cubeletMachine.getState() == CubeletBoxState.EMPTY) {
            int n = Math.max(this.main.getLanguageHandler().getMessageList("Holograms.CubeletAvailable").size(), this.main.getLanguageHandler().getMessageList("Holograms.NoCubeletAvailable").size());
            DHAPI.setHologramLines((Hologram)hologram, this.hologramHandler.getLines(player));
            DHAPI.moveHologram((Hologram)hologram, (Location)cubeletMachine.getLocation().clone().add(0.5, (double)n * 0.36 + (cubeletMachine.getBlockHeight() + 0.1875), 0.5));
        } else if (cubeletMachine.getState() == CubeletBoxState.REWARD) {
            List<String> list = this.hologramHandler.getLinesReward(player, cubeletMachine.getPlayerOpening(), cubeletMachine.getLastReward());
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : list) {
                if (!string.contains("%reward_icon%")) {
                    arrayList.add(string);
                    continue;
                }
                arrayList.add("#ICON:" + HologramItem.fromItemStack((ItemStack)cubeletMachine.getLastReward().getIcon()).getContent());
            }
            DHAPI.setHologramLines((Hologram)hologram, arrayList);
            DHAPI.moveHologram((Hologram)hologram, (Location)cubeletMachine.getLocation().clone().add(0.5, (double)arrayList.size() * 0.32 + (cubeletMachine.getBlockHeight() + 0.1875), 0.5));
        }
        if (this.holograms.get(cubeletMachine) == null) {
            this.holograms.put(cubeletMachine, new HashMap());
        }
        this.holograms.get(cubeletMachine).put(player.getUniqueId(), hologram);
    }

    @Override
    public void reloadHolograms(Player player) {
        for (CubeletMachine cubeletMachine : this.main.getCubeletBoxHandler().getBoxes().values()) {
            this.reloadHologram(player, cubeletMachine);
        }
    }

    @Override
    public void reloadHologram(CubeletMachine cubeletMachine) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.reloadHologram(player, cubeletMachine);
        }
    }

    @Override
    public void reloadHologram(Player player, CubeletMachine cubeletMachine) {
        if (!Objects.equals(cubeletMachine.getLocation().getWorld(), player.getLocation().getWorld()) || cubeletMachine.getLocation().distanceSquared(player.getLocation()) > (double)this.hologramHandler.getVisibilityDistance()) {
            return;
        }
        if (this.holograms.get(cubeletMachine) == null || !this.holograms.get(cubeletMachine).containsKey(player.getUniqueId())) {
            return;
        }
        Hologram hologram = this.holograms.get(cubeletMachine).get(player.getUniqueId());
        if (cubeletMachine.getState() == CubeletBoxState.EMPTY && this.holograms.get(cubeletMachine).containsKey(player.getUniqueId())) {
            List<String> list = this.hologramHandler.getLines(player);
            int n = Math.max(this.main.getLanguageHandler().getMessageList("Holograms.CubeletAvailable").size(), this.main.getLanguageHandler().getMessageList("Holograms.NoCubeletAvailable").size());
            DHAPI.setHologramLines((Hologram)hologram, list);
            DHAPI.moveHologram((Hologram)hologram, (Location)cubeletMachine.getLocation().clone().add(0.5, (double)n * 0.36 + (cubeletMachine.getBlockHeight() + 0.1875), 0.5));
        }
    }

    @Override
    public void clearLines(CubeletMachine cubeletMachine) {
        for (Hologram hologram : this.holograms.get(cubeletMachine).values()) {
            HologramPage hologramPage = hologram.getPage(0);
            while (hologramPage.size() > 0) {
                hologramPage.removeLine(hologramPage.size() - 1);
            }
            hologram.realignLines();
            hologram.updateAll();
            hologram.save();
        }
    }

    @Override
    public void clearHolograms(CubeletMachine cubeletMachine) {
        this.holograms.get(cubeletMachine).clear();
    }

    @Override
    public void moveHologram(CubeletMachine cubeletMachine) {
        int n = Math.max(this.main.getLanguageHandler().getMessageList("Holograms.CubeletAvailable").size(), this.main.getLanguageHandler().getMessageList("Holograms.NoCubeletAvailable").size());
        if (this.holograms.get(cubeletMachine) == null) {
            return;
        }
        for (Hologram hologram : this.holograms.get(cubeletMachine).values()) {
            DHAPI.moveHologram((Hologram)hologram, (Location)cubeletMachine.getLocation().clone().add(0.5, (double)n * 0.36 + (cubeletMachine.getBlockHeight() + 0.1875), 0.5));
        }
    }

    @Override
    public void rewardHologram(CubeletMachine cubeletMachine, Reward reward) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (this.holograms.get(cubeletMachine) == null || !this.holograms.get(cubeletMachine).containsKey(player.getUniqueId())) continue;
            Hologram hologram = this.holograms.get(cubeletMachine).get(player.getUniqueId());
            List<String> list = this.hologramHandler.getLinesReward(player, cubeletMachine.getPlayerOpening(), reward);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string : list) {
                if (string.contains("%reward_icon%")) {
                    arrayList.add("#ICON:" + HologramItem.fromItemStack((ItemStack)cubeletMachine.getLastReward().getIcon()).getContent());
                    continue;
                }
                arrayList.add(string);
            }
            DHAPI.setHologramLines((Hologram)hologram, arrayList);
            DHAPI.moveHologram((Hologram)hologram, (Location)cubeletMachine.getLocation().clone().add(0.5, (double)list.size() * 0.32 + (cubeletMachine.getBlockHeight() + 0.1875), 0.5));
        }
    }

    @Override
    public RepeatingTask duplicationRewardHologram(final CubeletMachine cubeletMachine, final Reward reward) {
        final int n = cubeletMachine.getLastDuplicationPoints();
        return new RepeatingTask(this.main, 0, 1){
            int pointsPerTick;
            int pointsToShow;
            {
                super(javaPlugin, n4, n2);
                this.pointsPerTick = n > 40 ? n / 40 : (n > 20 ? n / 20 : n / n);
                this.pointsToShow = 0;
            }

            @Override
            public void run() {
                List<String> list = DecentHologramsImpl.this.hologramHandler.getLinesRewardDuplicated(reward, this.pointsToShow);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!DecentHologramsImpl.this.main.isDuplicationVisibleAllPlayers() && !cubeletMachine.getPlayerOpening().getUuid().equals(player.getUniqueId()) || DecentHologramsImpl.this.holograms.get(cubeletMachine) == null || !((HashMap)DecentHologramsImpl.this.holograms.get(cubeletMachine)).containsKey(player.getUniqueId())) continue;
                    Hologram hologram = (Hologram)((HashMap)DecentHologramsImpl.this.holograms.get(cubeletMachine)).get(player.getUniqueId());
                    HologramPage hologramPage = hologram.getPage(0);
                    for (int i = 0; i < hologramPage.getLines().size(); ++i) {
                        String string = hologramPage.getLine(i).getContent();
                        if (string.contains("#ICON:")) continue;
                        DHAPI.setHologramLine((Hologram)hologram, (int)i, (String)list.get(i));
                    }
                    DHAPI.moveHologram((Hologram)hologram, (Location)cubeletMachine.getLocation().clone().add(0.5, (double)list.size() * 0.32 + (cubeletMachine.getBlockHeight() + 0.1875), 0.5));
                }
                this.pointsToShow = this.pointsToShow + this.pointsPerTick <= n ? (this.pointsToShow += this.pointsPerTick) : n;
            }
        };
    }

    @Override
    public void removeHolograms(Player player) {
        for (CubeletMachine cubeletMachine : this.main.getCubeletBoxHandler().getBoxes().values()) {
            if (this.holograms.get(cubeletMachine) == null || !this.holograms.get(cubeletMachine).containsKey(player.getUniqueId()) || this.holograms.get(cubeletMachine).get(player.getUniqueId()) == null) continue;
            this.holograms.get(cubeletMachine).get(player.getUniqueId()).delete();
            this.holograms.get(cubeletMachine).remove(player.getUniqueId());
        }
    }

    @Override
    public void removeHolograms(CubeletMachine cubeletMachine) {
        if (this.holograms.get(cubeletMachine) == null) {
            return;
        }
        for (Hologram hologram : this.holograms.get(cubeletMachine).values()) {
            hologram.destroy();
        }
    }
}

