/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.menus.admin;

import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.enums.Rotation;
import me.davidml16.acubelets.objects.CubeletMachine;
import me.davidml16.acubelets.objects.GUILayout;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.utils.ItemBuilder;
import me.davidml16.acubelets.utils.SkullCreator;
import me.davidml16.acubelets.utils.Utils;
import me.davidml16.acubelets.utils.XSeries.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class EditMachineMenu
extends Menu {
    public EditMachineMenu(Main main, Player player) {
        super(main, player);
    }

    @Override
    public void OnPageOpened(int n) {
        Player player = this.getOwner();
        player.updateInventory();
        CubeletMachine cubeletMachine = (CubeletMachine)this.getAttribute(Menu.AttrType.CUBELET_BOX_ATTR);
        Inventory inventory = this.createInventory(36, "Machine editor");
        ItemStack itemStack = new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack();
        ItemStack itemStack2 = SkullCreator.itemFromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTk5YWFmMjQ1NmE2MTIyZGU4ZjZiNjI2ODNmMmJjMmVlZDlhYmI4MWZkNWJlYTFiNGMyM2E1ODE1NmI2NjkifX19");
        ItemStack itemStack3 = SkullCreator.itemFromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMzkxMmQ0NWIxYzc4Y2MyMjQ1MjcyM2VlNjZiYTJkMTU3NzdjYzI4ODU2OGQ2YzFiNjJhNTQ1YjI5YzcxODcifX19");
        ItemStack itemStack4 = SkullCreator.itemFromBase64("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNGVkNjc5OTE0OTc4OGI5ZTkwMTY4MTFkM2EzZDBlZDFmNTUyNTMwZDY3Zjk4Njk0NTAzMmQ2ZTQzOWZhODk5ZCJ9fX0=");
        inventory.setItem(10, new ItemBuilder(itemStack2).setName(Utils.translate("&aIncrease height")).setLore("", Utils.translate(" &7Actual height: &6" + String.format("%.3f", cubeletMachine.getBlockHeight())), Utils.translate(" &7New height: &6" + String.format("%.3f", cubeletMachine.getBlockHeight() + 0.015)), "", Utils.translate("&eClick to increase height")).toItemStack());
        inventory.setItem(11, new ItemBuilder(XMaterial.ANVIL.parseMaterial()).setName(Utils.translate("&aReset height to default")).setLore("", Utils.translate(" &7New height: &6" + String.format("%.3f", cubeletMachine.getPermanentBlockHeight())), "", Utils.translate("&eClick \u00bb &aReset height"), Utils.translate("&eShift-Click \u00bb &aSet default height to actual")).toItemStack());
        inventory.setItem(12, new ItemBuilder(itemStack3).setName(Utils.translate("&aDecrease height")).setLore("", Utils.translate(" &7Actual height: &6" + String.format("%.3f", cubeletMachine.getBlockHeight())), Utils.translate(" &7New height: &6" + String.format("%.3f", cubeletMachine.getBlockHeight() - 0.015)), "", Utils.translate("&eClick to decrease height")).toItemStack());
        inventory.setItem(14, new ItemBuilder(XMaterial.COMPASS.parseItem()).setName(Utils.translate("&aChange direction")).setLore("", Utils.translate(" " + (cubeletMachine.getRotation() == Rotation.NORTH ? "&eNorth" : "&7North")), Utils.translate(" " + (cubeletMachine.getRotation() == Rotation.SOUTH ? "&eSouth" : "&7South")), Utils.translate(" " + (cubeletMachine.getRotation() == Rotation.EAST ? "&eEast" : "&7East")), Utils.translate(" " + (cubeletMachine.getRotation() == Rotation.WEST ? "&eWest" : "&7West")), "", Utils.translate("&eClick to change direction")).toItemStack());
        inventory.setItem(16, new ItemBuilder(itemStack4).setName(Utils.translate("&cRemove cubelet machine")).setLore("", Utils.translate("&eClick to remove this machine")).toItemStack());
        this.fillPage(itemStack);
        GUILayout gUILayout = this.getMain().getLayoutHandler().getLayout("opencubelet");
        ItemStack itemStack5 = new ItemBuilder(XMaterial.matchXMaterial(gUILayout.getMessage("Items.Close.Material")).get().parseItem()).setName(gUILayout.getMessage("Items.Close.Name")).setLore(gUILayout.getMessageList("Items.Close.Lore")).toItemStack();
        inventory.setItem(31, itemStack5);
        this.openInventory();
    }

    @Override
    public void OnMenuClick(InventoryClickEvent inventoryClickEvent) {
        Player player = this.getOwner();
        inventoryClickEvent.setCancelled(true);
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        int n = inventoryClickEvent.getRawSlot();
        CubeletMachine cubeletMachine = (CubeletMachine)this.getAttribute(Menu.AttrType.CUBELET_BOX_ATTR);
        if (n == 10) {
            cubeletMachine.setBlockHeight(cubeletMachine.getBlockHeight() + 0.015);
            this.getMain().getHologramImplementation().moveHologram(cubeletMachine);
            this.playSound(Menu.SoundType.CLICK);
            this.reloadMyMenu();
        } else if (n == 11) {
            if (inventoryClickEvent.getClick() == ClickType.LEFT || inventoryClickEvent.getClick() == ClickType.RIGHT) {
                cubeletMachine.setBlockHeight(cubeletMachine.getPermanentBlockHeight());
                this.playSound(Menu.SoundType.CHICKEN_EGG_POP);
                this.reloadMyMenu();
                this.getMain().getHologramImplementation().moveHologram(cubeletMachine);
                Bukkit.getScheduler().runTaskLater((Plugin)this.getMain(), () -> this.getMain().getHologramImplementation().moveHologram(cubeletMachine), 5L);
            } else if (inventoryClickEvent.getClick() == ClickType.SHIFT_RIGHT || inventoryClickEvent.getClick() == ClickType.SHIFT_LEFT) {
                cubeletMachine.setPermanentBlockHeight(cubeletMachine.getBlockHeight());
                this.playSound(Menu.SoundType.CHICKEN_EGG_POP);
                this.reloadMyMenu();
            }
        } else if (n == 12) {
            cubeletMachine.setBlockHeight(cubeletMachine.getBlockHeight() - 0.015);
            this.getMain().getHologramImplementation().moveHologram(cubeletMachine);
            this.playSound(Menu.SoundType.CLICK);
            this.reloadMyMenu();
        } else if (n == 14) {
            if (inventoryClickEvent.getClick() != ClickType.DOUBLE_CLICK) {
                if (cubeletMachine.getRotation() == Rotation.NORTH) {
                    cubeletMachine.setRotation(Rotation.SOUTH);
                } else if (cubeletMachine.getRotation() == Rotation.SOUTH) {
                    cubeletMachine.setRotation(Rotation.EAST);
                } else if (cubeletMachine.getRotation() == Rotation.EAST) {
                    cubeletMachine.setRotation(Rotation.WEST);
                } else if (cubeletMachine.getRotation() == Rotation.WEST) {
                    cubeletMachine.setRotation(Rotation.NORTH);
                }
                this.playSound(Menu.SoundType.CLICK);
                this.reloadMyMenu();
            }
        } else if (n == 16) {
            if (this.getMain().getCubeletBoxHandler().getBoxes().containsKey(cubeletMachine.getLocation())) {
                this.getMain().getCubeletBoxHandler().removeBox(cubeletMachine.getLocation());
                this.playSound(Menu.SoundType.ANVIL_USE);
                player.sendMessage(Utils.translate(this.getMain().getLanguageHandler().getPrefix() + " &aSuccesfully removed cubelet machine of &aX: &e" + cubeletMachine.getLocation().getBlockX() + ", &aY: &e" + cubeletMachine.getLocation().getBlockY() + ", &aZ: &e" + cubeletMachine.getLocation().getBlockZ()));
                String string = this.getClass().getName();
                for (Menu menu : this.getMain().getMenuHandler().getOpenedMenus().values()) {
                    if (!menu.getClass().getName().equalsIgnoreCase(string) || !menu.getAttribute(Menu.AttrType.CUBELET_BOX_ATTR).equals(cubeletMachine)) continue;
                    menu.getOwner().closeInventory();
                }
            } else {
                player.sendMessage(Utils.translate(this.getMain().getLanguageHandler().getPrefix() + " &cThis cubelet machine location no exists!"));
            }
        } else if (n == 31) {
            player.closeInventory();
        }
    }

    @Override
    public void OnMenuClosed() {
        this.getMain().getCubeletBoxHandler().saveBoxes();
    }
}

