/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.menus.admin.rewards;

import java.util.List;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.menus.admin.rewards.RewardsMenu;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.objects.rewards.ItemObject;
import me.davidml16.acubelets.objects.rewards.Reward;
import me.davidml16.acubelets.utils.ItemBuilder;
import me.davidml16.acubelets.utils.Utils;
import me.davidml16.acubelets.utils.XSeries.XMaterial;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class EditRewardItemsMenu
extends Menu {
    public EditRewardItemsMenu(Main main, Player player) {
        super(main, player);
    }

    @Override
    public void OnPageOpened(int n) {
        int n2;
        Reward reward = (Reward)this.getAttribute(Menu.AttrType.REWARD_ATTR);
        List<ItemObject> list = reward.getItems();
        if (n > 0 && list.size() < n * 21 + 1) {
            this.openPage(this.getPage() - 1);
            return;
        }
        Inventory inventory = this.createInventory(45, "%reward% | Items".replaceAll("%reward%", reward.getId()));
        ItemStack itemStack = new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack();
        ItemStack itemStack2 = new ItemBuilder(XMaterial.ARROW.parseItem()).setName(Utils.translate("&aBack to config")).toItemStack();
        this.fillBorders(itemStack);
        for (n2 = 10; n2 <= 16; ++n2) {
            inventory.setItem(n2, null);
        }
        for (n2 = 19; n2 <= 25; ++n2) {
            inventory.setItem(n2, null);
        }
        for (n2 = 28; n2 <= 34; ++n2) {
            inventory.setItem(n2, null);
        }
        if (n > 0) {
            inventory.setItem(18, new ItemBuilder(XMaterial.ENDER_PEARL.parseItem()).setName(Utils.translate("&aPrevious page")).toItemStack());
        } else {
            inventory.setItem(18, new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack());
        }
        if (list.size() > (n + 1) * 21) {
            inventory.setItem(26, new ItemBuilder(XMaterial.ENDER_PEARL.parseItem()).setName(Utils.translate("&aNext page")).toItemStack());
        } else {
            inventory.setItem(26, new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack());
        }
        inventory.setItem(40, itemStack2);
        if (list.size() > 21) {
            list = list.subList(n * 21, n * 21 + 21 > list.size() ? list.size() : n * 21 + 21);
        }
        if (list.size() > 0) {
            for (ItemObject itemObject : list) {
                inventory.addItem(new ItemStack[]{new ItemBuilder(itemObject.getItemStack().clone()).setName(Utils.translate("&a" + itemObject.getId())).setLore("", Utils.translate("&eLeft-Click \u00bb &aRemove item ")).toItemStack()});
            }
        } else {
            inventory.setItem(22, new ItemBuilder(XMaterial.RED_STAINED_GLASS_PANE.parseItem()).setName(Utils.translate("&cAny items added")).setLore("", Utils.translate(" &7You dont have any "), Utils.translate(" &7items added. "), "", Utils.translate(" &7Click items of your. "), Utils.translate(" &7inventory to add it. "), "").toItemStack());
        }
        this.openInventory();
    }

    @Override
    public void OnMenuClick(InventoryClickEvent inventoryClickEvent) {
        inventoryClickEvent.setCancelled(true);
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        if (inventoryClickEvent.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        int n = inventoryClickEvent.getRawSlot();
        Reward reward = (Reward)this.getAttribute(Menu.AttrType.REWARD_ATTR);
        CubeletType cubeletType = reward.getParentCubelet();
        Player player = this.getOwner();
        if (n == 18 && inventoryClickEvent.getCurrentItem().getType() == XMaterial.ENDER_PEARL.parseMaterial()) {
            this.previousPage();
        } else if (n == 26 && inventoryClickEvent.getCurrentItem().getType() == XMaterial.ENDER_PEARL.parseMaterial()) {
            this.nextPage();
        } else if (n == 40) {
            RewardsMenu rewardsMenu = new RewardsMenu(this.getMain(), player);
            rewardsMenu.setAttribute(Menu.AttrType.CUSTOM_ID_ATTR, cubeletType.getId());
            rewardsMenu.open();
        } else if (n >= 10 && n <= 16 || n >= 19 && n <= 25 || n >= 28 && n <= 34) {
            if (reward.getItems().size() == 0) {
                return;
            }
            String string = ChatColor.stripColor((String)inventoryClickEvent.getCurrentItem().getItemMeta().getDisplayName());
            ItemObject itemObject = reward.getItem(string);
            if (inventoryClickEvent.getClick() == ClickType.LEFT || inventoryClickEvent.getClick() == ClickType.SHIFT_LEFT) {
                reward.getItems().remove(itemObject);
                reward.recreateItems();
                player.sendMessage(Utils.translate(this.getMain().getLanguageHandler().getPrefix() + " &aYou removed item &e" + itemObject.getId() + " &afrom items of reward &e" + reward.getId()));
                this.reloadMenu();
            }
        } else if (n >= 45 && n <= 80) {
            ItemStack itemStack = inventoryClickEvent.getCurrentItem();
            ItemObject itemObject = new ItemObject("item-" + reward.getItems().size(), itemStack);
            reward.getItems().add(itemObject);
            player.sendMessage(Utils.translate(this.getMain().getLanguageHandler().getPrefix() + " &aYou added item &e" + itemObject.getId() + " &ato items of reward &e" + reward.getId()));
            this.reloadMenu();
        }
    }

    @Override
    public void OnMenuClosed() {
        Reward reward = (Reward)this.getAttribute(Menu.AttrType.REWARD_ATTR);
        reward.getParentCubelet().saveType();
    }
}

