/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.menus.admin.rewards;

import java.util.List;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.conversation.rewards.EditPermissionObjectRewardConversation;
import me.davidml16.acubelets.conversation.rewards.PermissionObjectRewardConversation;
import me.davidml16.acubelets.menus.admin.rewards.RewardsMenu;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.objects.rewards.PermissionObject;
import me.davidml16.acubelets.objects.rewards.Reward;
import me.davidml16.acubelets.utils.ItemBuilder;
import me.davidml16.acubelets.utils.Utils;
import me.davidml16.acubelets.utils.XSeries.XMaterial;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class EditRewardPermissionsMenu
extends Menu {
    public EditRewardPermissionsMenu(Main main, Player player) {
        super(main, player);
    }

    @Override
    public void OnPageOpened(int n) {
        int n2;
        Reward reward = (Reward)this.getAttribute(Menu.AttrType.REWARD_ATTR);
        List<PermissionObject> list = reward.getPermissions();
        if (n > 0 && list.size() < n * 21 + 1) {
            this.openPage(this.getPage() - 1);
            return;
        }
        Inventory inventory = this.createInventory(45, "%reward% | Permissions".replaceAll("%reward%", reward.getId()));
        ItemStack itemStack = new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack();
        ItemStack itemStack2 = new ItemBuilder(XMaterial.ARROW.parseItem()).setName(Utils.translate("&aBack to config")).toItemStack();
        ItemStack itemStack3 = new ItemBuilder(XMaterial.SUNFLOWER.parseItem()).setName(Utils.translate("&aCreate new permission")).toItemStack();
        this.fillBorders(itemStack);
        for (n2 = 10; n2 <= 16; ++n2) {
            inventory.setItem(n2, null);
        }
        for (n2 = 19; n2 <= 25; ++n2) {
            inventory.setItem(n2, null);
        }
        for (n2 = 28; n2 <= 34; ++n2) {
            inventory.setItem(n2, null);
        }
        if (n > 0) {
            inventory.setItem(18, new ItemBuilder(XMaterial.ENDER_PEARL.parseItem()).setName(Utils.translate("&aPrevious page")).toItemStack());
        } else {
            inventory.setItem(18, new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack());
        }
        if (list.size() > (n + 1) * 21) {
            inventory.setItem(26, new ItemBuilder(XMaterial.ENDER_PEARL.parseItem()).setName(Utils.translate("&aNext page")).toItemStack());
        } else {
            inventory.setItem(26, new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack());
        }
        inventory.setItem(39, itemStack3);
        inventory.setItem(41, itemStack2);
        if (list.size() > 21) {
            list = list.subList(n * 21, n * 21 + 21 > list.size() ? list.size() : n * 21 + 21);
        }
        if (list.size() > 0) {
            for (PermissionObject permissionObject : list) {
                inventory.addItem(new ItemStack[]{new ItemBuilder(XMaterial.PAPER.parseItem()).setName(Utils.translate("&a" + permissionObject.getId())).setLore("", Utils.translate(" &7Permission: &6" + permissionObject.getPermission()), "", Utils.translate("&eLeft-Click \u00bb &aRemove permission "), Utils.translate("&eRight-Click \u00bb &aEdit permission ")).toItemStack()});
            }
        } else {
            inventory.setItem(22, new ItemBuilder(XMaterial.RED_STAINED_GLASS_PANE.parseItem()).setName(Utils.translate("&cAny permissions added")).setLore("", Utils.translate(" &7You dont have any "), Utils.translate(" &7permissions added. "), "").toItemStack());
        }
        this.openInventory();
    }

    @Override
    public void OnMenuClick(InventoryClickEvent inventoryClickEvent) {
        inventoryClickEvent.setCancelled(true);
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        if (inventoryClickEvent.getCurrentItem().getType() == Material.AIR) {
            return;
        }
        int n = inventoryClickEvent.getRawSlot();
        Reward reward = (Reward)this.getAttribute(Menu.AttrType.REWARD_ATTR);
        CubeletType cubeletType = reward.getParentCubelet();
        Player player = this.getOwner();
        if (n == 18 && inventoryClickEvent.getCurrentItem().getType() == XMaterial.ENDER_PEARL.parseMaterial()) {
            this.previousPage();
        } else if (n == 26 && inventoryClickEvent.getCurrentItem().getType() == XMaterial.ENDER_PEARL.parseMaterial()) {
            this.nextPage();
        } else if (n == 39) {
            player.closeInventory();
            new PermissionObjectRewardConversation(this.getMain()).getConversation(player, cubeletType, reward).begin();
            this.playSound(Menu.SoundType.ANVIL_USE);
        } else if (n == 41) {
            RewardsMenu rewardsMenu = new RewardsMenu(this.getMain(), player);
            rewardsMenu.setAttribute(Menu.AttrType.CUSTOM_ID_ATTR, cubeletType.getId());
            rewardsMenu.open();
        } else if (n >= 10 && n <= 16 || n >= 19 && n <= 25 || n >= 28 && n <= 34) {
            if (reward.getPermissions().size() == 0) {
                return;
            }
            String string = ChatColor.stripColor((String)inventoryClickEvent.getCurrentItem().getItemMeta().getDisplayName());
            PermissionObject permissionObject = reward.getPermission(string);
            if (inventoryClickEvent.getClick() == ClickType.LEFT || inventoryClickEvent.getClick() == ClickType.SHIFT_LEFT) {
                reward.getPermissions().remove(permissionObject);
                reward.recreatePermissions();
                player.sendMessage(Utils.translate(this.getMain().getLanguageHandler().getPrefix() + " &aYou removed &e" + permissionObject.getId() + " &afrom permissions of reward &e" + reward.getId()));
                this.reloadMenu();
            } else if (inventoryClickEvent.getClick() == ClickType.RIGHT || inventoryClickEvent.getClick() == ClickType.SHIFT_RIGHT) {
                player.closeInventory();
                new EditPermissionObjectRewardConversation(this.getMain()).getConversation(player, cubeletType, reward, permissionObject).begin();
                this.playSound(Menu.SoundType.ANVIL_USE);
            }
        }
    }

    @Override
    public void OnMenuClosed() {
        Reward reward = (Reward)this.getAttribute(Menu.AttrType.REWARD_ATTR);
        reward.getParentCubelet().saveType();
    }
}

