/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.menus.admin.type;

import java.util.ArrayList;
import java.util.List;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.menus.admin.type.TypeConfigMenu;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.utils.ItemBuilder;
import me.davidml16.acubelets.utils.TimeAPI.TimeUtils;
import me.davidml16.acubelets.utils.Utils;
import me.davidml16.acubelets.utils.XSeries.XMaterial;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class TypeListMenu
extends Menu {
    public TypeListMenu(Main main, Player player) {
        super(main, player);
    }

    @Override
    public void OnPageOpened(int n) {
        int n2;
        List<CubeletType> list = new ArrayList<CubeletType>(this.getMain().getCubeletTypesHandler().getTypes().values());
        if (n > 0 && list.size() < n * 21 + 1) {
            this.openPage(this.getPage() - 1);
            return;
        }
        Inventory inventory = this.createInventory(45, "Cubelet Types");
        ItemStack itemStack = new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack();
        ItemStack itemStack2 = new ItemBuilder(XMaterial.ARROW.parseItem()).setName(Utils.translate("&aClose")).toItemStack();
        inventory.setItem(40, itemStack2);
        this.fillBorders(itemStack);
        for (n2 = 10; n2 <= 16; ++n2) {
            inventory.setItem(n2, null);
        }
        for (n2 = 19; n2 <= 25; ++n2) {
            inventory.setItem(n2, null);
        }
        for (n2 = 28; n2 <= 34; ++n2) {
            inventory.setItem(n2, null);
        }
        if (n > 0) {
            inventory.setItem(18, new ItemBuilder(XMaterial.ENDER_PEARL.parseItem()).setName(Utils.translate("&aPrevious page")).toItemStack());
        } else {
            inventory.setItem(18, new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack());
        }
        if (list.size() > (n + 1) * 21) {
            inventory.setItem(26, new ItemBuilder(XMaterial.ENDER_PEARL.parseItem()).setName(Utils.translate("&aNext page")).toItemStack());
        } else {
            inventory.setItem(26, new ItemBuilder(XMaterial.GRAY_STAINED_GLASS_PANE.parseItem()).setName("").toItemStack());
        }
        if (list.size() > 21) {
            list = list.subList(n * 21, n * 21 + 21 > list.size() ? list.size() : n * 21 + 21);
        }
        if (list.size() > 0) {
            for (CubeletType cubeletType : list) {
                inventory.addItem(new ItemStack[]{new ItemBuilder(cubeletType.getIcon()).setName(Utils.translate("&a" + cubeletType.getId())).setLore("", Utils.translate(" &7Name: &6" + cubeletType.getName() + " "), Utils.translate(" &7Rarities: &6" + cubeletType.getRarities().size() + " "), Utils.translate(" &7Rewards: &6" + cubeletType.getAllRewards().size() + " "), "", Utils.translate(" &7Animation: &6" + cubeletType.getAnimation() + " "), Utils.translate(" &7Expiration: &6" + TimeUtils.millisToLongDHMS(cubeletType.getExpireTime()) + " "), "", Utils.translate("&eClick to setup " + cubeletType.getId() + " type ")).toItemStack()});
            }
        } else {
            inventory.setItem(22, new ItemBuilder(XMaterial.RED_STAINED_GLASS_PANE.parseItem()).setName(Utils.translate("&cAny type created")).setLore("", Utils.translate(" &7You dont have any "), Utils.translate(" &7type created. "), "").toItemStack());
        }
        this.openInventory();
    }

    @Override
    public void OnMenuClick(InventoryClickEvent inventoryClickEvent) {
        inventoryClickEvent.setCancelled(true);
        if (inventoryClickEvent.getCurrentItem() == null) {
            return;
        }
        Player player = this.getOwner();
        int n = inventoryClickEvent.getRawSlot();
        if (n == 18 && inventoryClickEvent.getCurrentItem().getType() == XMaterial.ENDER_PEARL.parseMaterial()) {
            this.previousPage();
            this.playSound(Menu.SoundType.CLICK);
        } else if (n == 26 && inventoryClickEvent.getCurrentItem().getType() == XMaterial.ENDER_PEARL.parseMaterial()) {
            this.nextPage();
            this.playSound(Menu.SoundType.CLICK);
        } else if (n >= 10 && n <= 16 || n >= 19 && n <= 25 || n >= 28 && n <= 34) {
            if (inventoryClickEvent.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            String string = ChatColor.stripColor((String)inventoryClickEvent.getCurrentItem().getItemMeta().getDisplayName());
            if (this.getMain().getCubeletTypesHandler().getTypes().size() == 0) {
                return;
            }
            if (this.getMain().getCubeletTypesHandler().getTypes().keySet().contains(string)) {
                TypeConfigMenu typeConfigMenu = new TypeConfigMenu(this.getMain(), player);
                typeConfigMenu.setAttribute(Menu.AttrType.CUSTOM_ID_ATTR, string);
                typeConfigMenu.open();
            } else {
                player.closeInventory();
            }
        } else if (n == 40) {
            player.closeInventory();
        }
    }

    @Override
    public void OnMenuClosed() {
    }
}

