/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.objects;

import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.interfaces.RarityComparator;
import me.davidml16.acubelets.interfaces.RewardComparator;
import me.davidml16.acubelets.interfaces.RewardIDComparator;
import me.davidml16.acubelets.objects.Rarity;
import me.davidml16.acubelets.objects.rewards.CommandObject;
import me.davidml16.acubelets.objects.rewards.ItemObject;
import me.davidml16.acubelets.objects.rewards.PermissionObject;
import me.davidml16.acubelets.objects.rewards.Reward;
import me.davidml16.acubelets.utils.XSeries.XItemStack;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;

public class CubeletType {
    private Main main;
    private String id;
    private String name;
    private Long expireTime;
    private ItemStack icon;
    private List<String> loreAvailable;
    private List<String> loreExpired;
    private List<String> description;
    private String animation;
    private Map<String, List<Reward>> rewards;
    private Map<String, Rarity> rarities;
    private ItemStack key;

    public CubeletType(Main main, String string, String string2) {
        this.main = main;
        this.id = string;
        this.name = string2;
        this.rewards = new HashMap<String, List<Reward>>();
        this.rarities = new HashMap<String, Rarity>();
        this.expireTime = 0L;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Map<String, List<Reward>> getRewards() {
        return this.rewards;
    }

    public List<Reward> getAllRewards() {
        ArrayList<Reward> arrayList = new ArrayList<Reward>();
        ArrayList<Rarity> arrayList2 = new ArrayList<Rarity>(this.getRarities().values());
        if (this.main.isRewardSorting()) {
            arrayList2.sort(new RarityComparator());
        }
        for (Rarity rarity : arrayList2) {
            ArrayList<Reward> arrayList3 = new ArrayList<Reward>(this.getRewards().getOrDefault(rarity.getId(), new ArrayList()));
            if (this.main.isRewardSorting()) {
                arrayList3.sort(new RewardComparator());
            }
            arrayList.addAll(arrayList3);
        }
        if (!this.main.isRewardSorting()) {
            arrayList.sort(new RewardIDComparator());
        }
        return arrayList;
    }

    public Reward getReward(String string) {
        for (Reward reward : this.getAllRewards()) {
            if (!reward.getId().equalsIgnoreCase(string)) continue;
            return reward;
        }
        return null;
    }

    public List<String> getRaritiesIDs() {
        ArrayList<Rarity> arrayList = new ArrayList<Rarity>(this.getRarities().values());
        arrayList.sort(new RarityComparator());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Rarity rarity : arrayList) {
            arrayList2.add(rarity.getId());
        }
        return arrayList2;
    }

    public void setRewards(Map<String, List<Reward>> map) {
        this.rewards = map;
    }

    public Map<String, Rarity> getRarities() {
        return this.rarities;
    }

    public void setRarities(Map<String, Rarity> map) {
        this.rarities = map;
    }

    public ItemStack getIcon() {
        return this.icon;
    }

    public void setIcon(ItemStack itemStack) {
        this.icon = itemStack;
    }

    public List<String> getLoreAvailable() {
        return this.loreAvailable;
    }

    public void setLoreAvailable(List<String> list) {
        this.loreAvailable = list;
    }

    public List<String> getLoreExpired() {
        return this.loreExpired;
    }

    public void setLoreExpired(List<String> list) {
        this.loreExpired = list;
    }

    public List<String> getDescription() {
        return this.description;
    }

    public void setDescription(List<String> list) {
        this.description = list;
    }

    public String getAnimation() {
        return this.animation;
    }

    public void setAnimation(String string) {
        this.animation = string;
    }

    public Long getExpireTime() {
        return this.expireTime;
    }

    public void setExpireTime(Long l) {
        this.expireTime = l;
    }

    public ItemStack getKey() {
        return this.key;
    }

    public void setKey(ItemStack itemStack) {
        this.key = itemStack;
    }

    public ItemStack getKeyNBT() {
        ItemStack itemStack = this.getKey().clone();
        itemStack = NBTEditor.set(itemStack, this.getId(), "keyType");
        return itemStack;
    }

    public void addReward(String string, Reward reward) {
        Map<String, List<Reward>> map = this.getRewards();
        List<Reward> list = this.getRewards().get(string) == null ? new ArrayList<Reward>() : this.getRewards().get(string);
        list.add(reward);
        map.put(reward.getRarity().getId(), list);
        this.setRewards(map);
    }

    public String toString() {
        return "CubeletType{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", icon=" + this.icon + ", rewards=" + this.rewards + ", rarities=" + this.rarities + '}';
    }

    public void saveType() {
        List<Object> list;
        FileConfiguration fileConfiguration = this.main.getCubeletTypesHandler().getConfig(this.id);
        fileConfiguration.set("type.key", null);
        if (!this.main.isSerializeBase64()) {
            XItemStack.serializeItem(this.key, fileConfiguration, "type.key");
        } else {
            fileConfiguration.set("type.key", (Object)XItemStack.itemStackToBase64(this.key));
        }
        fileConfiguration.set("type.rarities", new ArrayList());
        if (fileConfiguration.contains("type.rarities")) {
            list = new ArrayList<Rarity>(this.rarities.values());
            list.sort(new RarityComparator());
            for (Object object : list) {
                fileConfiguration.set("type.rarities." + ((Rarity)object).getId() + ".name", (Object)((Rarity)object).getName());
                fileConfiguration.set("type.rarities." + ((Rarity)object).getId() + ".chance", (Object)((Rarity)object).getChance());
                fileConfiguration.set("type.rarities." + ((Rarity)object).getId() + ".duplicatePointsRange", (Object)((Rarity)object).getDuplicatePointsRange());
            }
        }
        fileConfiguration.set("type.rewards", new ArrayList());
        if (fileConfiguration.contains("type.rewards")) {
            list = this.getAllRewards();
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                object = (Reward)list.get(i);
                fileConfiguration.set("type.rewards.reward_" + i + ".name", (Object)((Reward)object).getName());
                fileConfiguration.set("type.rewards.reward_" + i + ".rarity", (Object)((Reward)object).getRarity().getId());
                fileConfiguration.set("type.rewards.reward_" + i + ".rewardUUID", (Object)((Reward)object).getRewardUUID().toString());
                fileConfiguration.set("type.rewards.reward_" + i + ".bypassDuplicationSystem", (Object)((Reward)object).isBypassDuplicationSystem());
                ArrayList<String> arrayList = new ArrayList<String>();
                for (CommandObject commandObject : ((Reward)object).getCommands()) {
                    arrayList.add(commandObject.getCommand());
                }
                fileConfiguration.set("type.rewards.reward_" + i + ".command", arrayList);
                ArrayList arrayList2 = new ArrayList();
                for (PermissionObject permissionObject : ((Reward)object).getPermissions()) {
                    arrayList2.add(permissionObject.getPermission());
                }
                fileConfiguration.set("type.rewards.reward_" + i + ".permission", (Object)arrayList2);
                List<ItemObject> list22 = ((Reward)object).getItems();
                fileConfiguration.set("type.rewards.reward_" + i + ".item", new ArrayList());
                for (int j = 0; j < list22.size(); ++j) {
                    if (!this.main.isSerializeBase64()) {
                        XItemStack.serializeItem(list22.get(j).getItemStack(), fileConfiguration, "type.rewards.reward_" + i + ".item.item_" + j);
                        continue;
                    }
                    fileConfiguration.set("type.rewards.reward_" + i + ".item.item_" + j, (Object)XItemStack.itemStackToBase64(list22.get(j).getItemStack()));
                }
                if (!this.main.isSerializeBase64()) {
                    XItemStack.serializeIcon(((Reward)object).getIcon(), fileConfiguration, "type.rewards.reward_" + i + ".icon", true);
                    continue;
                }
                fileConfiguration.set("type.rewards.reward_" + i + ".icon", (Object)XItemStack.itemStackToBase64(((Reward)object).getIcon()));
            }
        }
        this.main.getCubeletTypesHandler().saveConfig(this.id);
    }
}

