/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.davidml16.acubelets.utils.XSeries.XMaterial;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemBuilder {
    private ItemStack is;

    public ItemBuilder(Material material) {
        this(material, 1);
    }

    public ItemBuilder(ItemStack itemStack) {
        this.is = itemStack;
    }

    public ItemBuilder(Material material, int n) {
        this.is = new ItemStack(material, n);
    }

    public ItemBuilder(Material material, int n, byte by) {
        this.is = new ItemStack(material, n, (short)by);
    }

    public ItemBuilder clone() {
        return new ItemBuilder(this.is);
    }

    public ItemBuilder setDurability(short s) {
        this.is.setDurability(s);
        return this;
    }

    public ItemBuilder setName(String string) {
        ItemMeta itemMeta = this.is.getItemMeta();
        itemMeta.setDisplayName(string);
        this.is.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder addUnsafeEnchantment(Enchantment enchantment, int n) {
        this.is.addUnsafeEnchantment(enchantment, n);
        return this;
    }

    public ItemBuilder removeEnchantment(Enchantment enchantment) {
        this.is.removeEnchantment(enchantment);
        return this;
    }

    public ItemBuilder setSkullOwner(String string) {
        try {
            SkullMeta skullMeta = (SkullMeta)this.is.getItemMeta();
            skullMeta.setOwner(string);
            this.is.setItemMeta((ItemMeta)skullMeta);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this;
    }

    public ItemBuilder addEnchant(Enchantment enchantment, int n) {
        ItemMeta itemMeta = this.is.getItemMeta();
        itemMeta.addEnchant(enchantment, n, true);
        this.is.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder addEnchantments(Map<Enchantment, Integer> map) {
        this.is.addEnchantments(map);
        return this;
    }

    public ItemBuilder setInfinityDurability() {
        this.is.setDurability((short)Short.MAX_VALUE);
        return this;
    }

    public ItemBuilder setLore(String ... stringArray) {
        ItemMeta itemMeta = this.is.getItemMeta();
        itemMeta.setLore(Arrays.asList(stringArray));
        this.is.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder setLore(List<String> list) {
        ItemMeta itemMeta = this.is.getItemMeta();
        itemMeta.setLore(list);
        this.is.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder removeLoreLine(String string) {
        ItemMeta itemMeta = this.is.getItemMeta();
        ArrayList arrayList = new ArrayList(itemMeta.getLore());
        if (!arrayList.contains(string)) {
            return this;
        }
        arrayList.remove(string);
        itemMeta.setLore(arrayList);
        this.is.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder removeLoreLine(int n) {
        ItemMeta itemMeta = this.is.getItemMeta();
        ArrayList arrayList = new ArrayList(itemMeta.getLore());
        if (n < 0 || n > arrayList.size()) {
            return this;
        }
        arrayList.remove(n);
        itemMeta.setLore(arrayList);
        this.is.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder addLoreLine(String string) {
        ItemMeta itemMeta = this.is.getItemMeta();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (itemMeta.hasLore()) {
            arrayList = new ArrayList(itemMeta.getLore());
        }
        arrayList.add(string);
        itemMeta.setLore(arrayList);
        this.is.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder addLoreLine(String string, int n) {
        ItemMeta itemMeta = this.is.getItemMeta();
        ArrayList<String> arrayList = new ArrayList<String>(itemMeta.getLore());
        arrayList.set(n, string);
        itemMeta.setLore(arrayList);
        this.is.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder setDyeColor(DyeColor dyeColor) {
        this.is.setDurability((short)dyeColor.getDyeData());
        return this;
    }

    @Deprecated
    public ItemBuilder setWoolColor(DyeColor dyeColor) {
        if (!this.is.getType().equals((Object)XMaterial.WHITE_WOOL.parseMaterial())) {
            return this;
        }
        this.is.setDurability((short)dyeColor.getDyeData());
        return this;
    }

    public ItemBuilder setLeatherArmorColor(Color color) {
        try {
            LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)this.is.getItemMeta();
            leatherArmorMeta.setColor(color);
            this.is.setItemMeta((ItemMeta)leatherArmorMeta);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return this;
    }

    public ItemBuilder hideAttributes() {
        ItemMeta itemMeta = this.is.getItemMeta();
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        this.is.setItemMeta(itemMeta);
        return this;
    }

    public ItemBuilder addGlow() {
        ItemMeta itemMeta = this.is.getItemMeta();
        itemMeta.addEnchant(Enchantment.DURABILITY, 1, true);
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        this.is.setItemMeta(itemMeta);
        return this;
    }

    public ItemStack toItemStack() {
        return this.is;
    }
}

