/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.helper.HttpConnection;
import org.jsoup.internal.StringUtil;

class CookieUtil {
    private static final Map<String, List<String>> EmptyRequestHeaders = Collections.unmodifiableMap(new HashMap());
    private static final String Sep = "; ";
    private static final String CookieName = "Cookie";
    private static final String Cookie2Name = "Cookie2";

    CookieUtil() {
    }

    static void applyCookiesToRequest(HttpConnection.Request request, HttpURLConnection httpURLConnection) {
        LinkedHashSet<String> linkedHashSet = CookieUtil.requestCookieSet(request);
        HashSet hashSet = null;
        Map<String, List<String>> map = request.cookieManager().get(CookieUtil.asUri(request.url), EmptyRequestHeaders);
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            HashSet hashSet2;
            List<String> list = entry.getValue();
            if (list == null || list.size() == 0) continue;
            String string = entry.getKey();
            if (CookieName.equals(string)) {
                hashSet2 = linkedHashSet;
            } else {
                if (!Cookie2Name.equals(string)) continue;
                hashSet = hashSet2 = new HashSet();
            }
            hashSet2.addAll(list);
        }
        if (linkedHashSet.size() > 0) {
            httpURLConnection.addRequestProperty(CookieName, StringUtil.join(linkedHashSet, Sep));
        }
        if (hashSet != null && hashSet.size() > 0) {
            httpURLConnection.addRequestProperty(Cookie2Name, StringUtil.join(hashSet, Sep));
        }
    }

    private static LinkedHashSet<String> requestCookieSet(Connection.Request request) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Map.Entry<String, String> entry : request.cookies().entrySet()) {
            linkedHashSet.add(entry.getKey() + "=" + entry.getValue());
        }
        return linkedHashSet;
    }

    static URI asUri(URL uRL) {
        try {
            return uRL.toURI();
        }
        catch (URISyntaxException uRISyntaxException) {
            MalformedURLException malformedURLException = new MalformedURLException(uRISyntaxException.getMessage());
            malformedURLException.initCause(uRISyntaxException);
            throw malformedURLException;
        }
    }

    static void storeCookies(HttpConnection.Request request, URL uRL, Map<String, List<String>> map) {
        request.cookieManager().put(CookieUtil.asUri(uRL), map);
    }
}

