/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.LeafNode;

public class DocumentType
extends LeafNode {
    public static final String PUBLIC_KEY = "PUBLIC";
    public static final String SYSTEM_KEY = "SYSTEM";
    private static final String NAME = "name";
    private static final String PUB_SYS_KEY = "pubSysKey";
    private static final String PUBLIC_ID = "publicId";
    private static final String SYSTEM_ID = "systemId";

    public DocumentType(String string, String string2, String string3) {
        Validate.notNull(string);
        Validate.notNull(string2);
        Validate.notNull(string3);
        this.attr(NAME, string);
        this.attr(PUBLIC_ID, string2);
        this.attr(SYSTEM_ID, string3);
        this.updatePubSyskey();
    }

    public void setPubSysKey(String string) {
        if (string != null) {
            this.attr(PUB_SYS_KEY, string);
        }
    }

    private void updatePubSyskey() {
        if (this.has(PUBLIC_ID)) {
            this.attr(PUB_SYS_KEY, PUBLIC_KEY);
        } else if (this.has(SYSTEM_ID)) {
            this.attr(PUB_SYS_KEY, SYSTEM_KEY);
        }
    }

    public String name() {
        return this.attr(NAME);
    }

    public String publicId() {
        return this.attr(PUBLIC_ID);
    }

    public String systemId() {
        return this.attr(SYSTEM_ID);
    }

    @Override
    public String nodeName() {
        return "#doctype";
    }

    @Override
    void outerHtmlHead(Appendable appendable, int n, Document.OutputSettings outputSettings) {
        if (this.siblingIndex > 0 && outputSettings.prettyPrint()) {
            appendable.append('\n');
        }
        if (outputSettings.syntax() == Document.OutputSettings.Syntax.html && !this.has(PUBLIC_ID) && !this.has(SYSTEM_ID)) {
            appendable.append("<!doctype");
        } else {
            appendable.append("<!DOCTYPE");
        }
        if (this.has(NAME)) {
            appendable.append(" ").append(this.attr(NAME));
        }
        if (this.has(PUB_SYS_KEY)) {
            appendable.append(" ").append(this.attr(PUB_SYS_KEY));
        }
        if (this.has(PUBLIC_ID)) {
            appendable.append(" \"").append(this.attr(PUBLIC_ID)).append('\"');
        }
        if (this.has(SYSTEM_ID)) {
            appendable.append(" \"").append(this.attr(SYSTEM_ID)).append('\"');
        }
        appendable.append('>');
    }

    @Override
    void outerHtmlTail(Appendable appendable, int n, Document.OutputSettings outputSettings) {
    }

    private boolean has(String string) {
        return !StringUtil.isBlank(this.attr(string));
    }
}

