/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import org.jsoup.parser.CharacterReader;

public class ParseError {
    private int pos;
    private String cursorPos;
    private String errorMsg;

    ParseError(CharacterReader characterReader, String string) {
        this.pos = characterReader.pos();
        this.cursorPos = characterReader.cursorPos();
        this.errorMsg = string;
    }

    ParseError(CharacterReader characterReader, String string, Object ... objectArray) {
        this.pos = characterReader.pos();
        this.cursorPos = characterReader.cursorPos();
        this.errorMsg = String.format(string, objectArray);
    }

    ParseError(int n, String string) {
        this.pos = n;
        this.cursorPos = String.valueOf(n);
        this.errorMsg = string;
    }

    ParseError(int n, String string, Object ... objectArray) {
        this.pos = n;
        this.cursorPos = String.valueOf(n);
        this.errorMsg = String.format(string, objectArray);
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public int getPosition() {
        return this.pos;
    }

    public String getCursorPos() {
        return this.cursorPos;
    }

    public String toString() {
        return "<" + this.cursorPos + ">: " + this.errorMsg;
    }
}

