/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.pool;

import com.zaxxer.hikari.pool.ProxyConnection;
import com.zaxxer.hikari.pool.ProxyFactory;
import com.zaxxer.hikari.pool.ProxyResultSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class ProxyStatement
implements Statement {
    protected final ProxyConnection connection;
    final Statement delegate;
    private boolean isClosed;
    private ResultSet proxyResultSet;

    ProxyStatement(ProxyConnection proxyConnection, Statement statement) {
        this.connection = proxyConnection;
        this.delegate = statement;
    }

    final SQLException checkException(SQLException sQLException) {
        return this.connection.checkException(sQLException);
    }

    public final String toString() {
        String string = this.delegate.toString();
        return this.getClass().getSimpleName() + '@' + System.identityHashCode(this) + " wrapping " + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        ProxyStatement proxyStatement = this;
        synchronized (proxyStatement) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
        }
        this.connection.untrackStatement(this.delegate);
        try {
            this.delegate.close();
        }
        catch (SQLException sQLException) {
            throw this.connection.checkException(sQLException);
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean execute(String string) {
        this.connection.markCommitStateDirty();
        return this.delegate.execute(string);
    }

    @Override
    public boolean execute(String string, int n) {
        this.connection.markCommitStateDirty();
        return this.delegate.execute(string, n);
    }

    @Override
    public ResultSet executeQuery(String string) {
        this.connection.markCommitStateDirty();
        ResultSet resultSet = this.delegate.executeQuery(string);
        return ProxyFactory.getProxyResultSet(this.connection, this, resultSet);
    }

    @Override
    public int executeUpdate(String string) {
        this.connection.markCommitStateDirty();
        return this.delegate.executeUpdate(string);
    }

    @Override
    public int[] executeBatch() {
        this.connection.markCommitStateDirty();
        return this.delegate.executeBatch();
    }

    @Override
    public int executeUpdate(String string, int n) {
        this.connection.markCommitStateDirty();
        return this.delegate.executeUpdate(string, n);
    }

    @Override
    public int executeUpdate(String string, int[] nArray) {
        this.connection.markCommitStateDirty();
        return this.delegate.executeUpdate(string, nArray);
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) {
        this.connection.markCommitStateDirty();
        return this.delegate.executeUpdate(string, stringArray);
    }

    @Override
    public boolean execute(String string, int[] nArray) {
        this.connection.markCommitStateDirty();
        return this.delegate.execute(string, nArray);
    }

    @Override
    public boolean execute(String string, String[] stringArray) {
        this.connection.markCommitStateDirty();
        return this.delegate.execute(string, stringArray);
    }

    @Override
    public long[] executeLargeBatch() {
        this.connection.markCommitStateDirty();
        return this.delegate.executeLargeBatch();
    }

    @Override
    public long executeLargeUpdate(String string) {
        this.connection.markCommitStateDirty();
        return this.delegate.executeLargeUpdate(string);
    }

    @Override
    public long executeLargeUpdate(String string, int n) {
        this.connection.markCommitStateDirty();
        return this.delegate.executeLargeUpdate(string, n);
    }

    @Override
    public long executeLargeUpdate(String string, int[] nArray) {
        this.connection.markCommitStateDirty();
        return this.delegate.executeLargeUpdate(string, nArray);
    }

    @Override
    public long executeLargeUpdate(String string, String[] stringArray) {
        this.connection.markCommitStateDirty();
        return this.delegate.executeLargeUpdate(string, stringArray);
    }

    @Override
    public ResultSet getResultSet() {
        ResultSet resultSet = this.delegate.getResultSet();
        if (resultSet != null) {
            if (this.proxyResultSet == null || ((ProxyResultSet)this.proxyResultSet).delegate != resultSet) {
                this.proxyResultSet = ProxyFactory.getProxyResultSet(this.connection, this, resultSet);
            }
        } else {
            this.proxyResultSet = null;
        }
        return this.proxyResultSet;
    }

    @Override
    public ResultSet getGeneratedKeys() {
        ResultSet resultSet = this.delegate.getGeneratedKeys();
        if (this.proxyResultSet == null || ((ProxyResultSet)this.proxyResultSet).delegate != resultSet) {
            this.proxyResultSet = ProxyFactory.getProxyResultSet(this.connection, this, resultSet);
        }
        return this.proxyResultSet;
    }

    @Override
    public final <T> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this.delegate)) {
            return (T)this.delegate;
        }
        if (this.delegate != null) {
            return this.delegate.unwrap(clazz);
        }
        throw new SQLException("Wrapped statement is not an instance of " + clazz);
    }
}

