/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.animations.animation.animation3;

import java.util.Objects;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.animations.ASSpawner;
import me.davidml16.acubelets.animations.Animation;
import me.davidml16.acubelets.animations.AnimationSettings;
import me.davidml16.acubelets.animations.animation.animation3.Animation3_Music;
import me.davidml16.acubelets.utils.ParticlesAPI.Particles;
import me.davidml16.acubelets.utils.ParticlesAPI.UtilParticles;
import me.davidml16.acubelets.utils.Sounds;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;

public class Animation3_Task
extends Animation {
    private ArmorStand armorStand;
    private Location armorStandLocation;

    public Animation3_Task(Main main, AnimationSettings animationSettings) {
        super(main, animationSettings);
    }

    @Override
    public void onTick(int n) {
        if (this.armorStand != null) {
            if (n <= 50) {
                this.armorStandLocation.add(0.0, 0.02, 0.0);
            }
            this.armorStand.teleport(this.armorStandLocation);
            this.armorStand.setHeadPose(this.armorStand.getHeadPose().add(0.0, 0.26, 0.0));
        }
        if (n == 60) {
            this.cancelRunnable("music");
            Sounds.playSound(this.getCubeletBox().getLocation(), Sounds.MySound.FIREWORK_LAUNCH, 0.5f, 0.0f);
        }
        if (n > 60 && n < 130) {
            Objects.requireNonNull(this.armorStand).setHeadPose(this.armorStand.getHeadPose().add(0.0, 0.26, 0.0));
            UtilParticles.display(Particles.FLAME, 0.1f, 0.25, 0.15f, this.armorStandLocation, 5);
        }
        if (n > 60 && n < 80) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, 0.45, 0.0);
        } else if (n > 80 && n < 90) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, 0.35, 0.0);
        } else if (n > 90 && n < 100) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, 0.25, 0.0);
        } else if (n > 100 && n < 110) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, 0.15, 0.0);
        } else if (n > 110 && n < 120) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, 0.05, 0.0);
        }
        if (n > 60 && n < 120) {
            this.armorStand.teleport(this.armorStandLocation);
        }
        if (n == 130) {
            Sounds.playSound(this.getCubeletBox().getLocation(), Sounds.MySound.IRONGOLEM_DEATH, 0.5f, 0.0f);
        } else if (n > 130 && n < 150) {
            Objects.requireNonNull(this.armorStandLocation).add(0.0, -0.85, 0.0);
            this.armorStand.teleport(this.armorStandLocation);
            this.armorStand.setHeadPose(this.armorStand.getHeadPose().add(0.0, 0.26, 0.0));
            UtilParticles.display(Particles.SMOKE_LARGE, 0.15f, 0.0, 0.15f, this.armorStandLocation.clone().add(0.0, 0.75, 0.0), 4);
        }
        if (n == 148) {
            this.doPreRewardReveal();
        }
    }

    @Override
    public void onStart() {
        this.armorStand = ASSpawner.spawn(this.getMain(), this.getCubeletBox(), this.getCubeletType(), true);
        this.armorStandLocation = this.armorStand.getLocation();
        this.getMain().getAnimationHandler().getEntities().add((Entity)this.armorStand);
        this.addRunnable("music", new Animation3_Music(this.getCubeletBox().getLocation()));
        this.startRunnable("music", 5L, 1L);
    }

    @Override
    public void onStop() {
        this.cancelRunnable("music");
        if (this.getMain().getAnimationHandler().getEntities().contains(this.armorStand)) {
            if (this.armorStand != null) {
                this.armorStand.remove();
            }
            this.getMain().getAnimationHandler().getEntities().remove(this.armorStand);
        }
    }

    @Override
    public void onPreRewardReveal() {
    }

    @Override
    public void onRewardReveal() {
        this.getMain().getFireworkUtil().spawn(this.getCubeletBox().getLocation().clone().add(0.5, 2.0, 0.5), FireworkEffect.Type.STAR, this.getColors().get(0), this.getColors().get(1));
        Sounds.playSound(this.getCubeletBox().getLocation(), Sounds.MySound.EXPLODE, 0.5f, 0.0f);
        this.armorStand.remove();
        this.armorStand = null;
    }
}

