/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.animations.animation.animation4;

import me.davidml16.acubelets.utils.ParticlesAPI.Particles;
import me.davidml16.acubelets.utils.ParticlesAPI.UtilParticles;
import org.bukkit.Location;
import org.bukkit.scheduler.BukkitRunnable;

public class Animation4_Arch
extends BukkitRunnable {
    private final Location location;
    private final double width = 4.25;
    private final double squareRoot2 = Math.sqrt(2.0);
    private final double radius;
    private int step;

    public Animation4_Arch(Location location) {
        this.location = location.clone().add(0.5, 0.25, 0.5);
        this.radius = 2.125;
        this.step = -90;
    }

    public void run() {
        this.step = this.step < 90 ? (this.step += 4) : 90;
        this.spawnArch(this.location.clone(), false);
        this.spawnArch(this.location.clone(), true);
    }

    public void spawnArch(Location location, boolean bl) {
        for (int i = -90; i <= this.step; ++i) {
            double d = Math.toRadians(i);
            location.setX(this.location.getX() + this.radius * Math.sin(d));
            location.setY(this.location.getY() + this.radius * Math.cos(d) * this.squareRoot2);
            if (!bl) {
                location.setZ(this.location.getZ() + this.radius * Math.sin(d));
            } else {
                location.setZ(this.location.getZ() - this.radius * Math.sin(d));
            }
            if (i % 4 != 0) continue;
            UtilParticles.display(Particles.REDSTONE, 255, 0, 0, location);
        }
    }
}

