/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.conversation;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.UUID;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.conversation.CommonPrompts;
import me.davidml16.acubelets.menus.admin.type.TypeConfigMenu;
import me.davidml16.acubelets.menus.admin.type.TypeSettingsMenu;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.utils.SkullCreator;
import me.davidml16.acubelets.utils.Sounds;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.FixedSetPrompt;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class TypeIconConversation
implements ConversationAbandonedListener,
CommonPrompts {
    private Main main;

    public TypeIconConversation(Main main) {
        this.main = main;
    }

    public Conversation getConversation(Player player, CubeletType cubeletType) {
        Conversation conversation = new ConversationFactory((Plugin)this.main).withModality(true).withLocalEcho(false).withFirstPrompt((Prompt)new RenameMenuOptions()).withTimeout(3600).thatExcludesNonPlayersWithMessage("").addConversationAbandonedListener((ConversationAbandonedListener)this).buildConversation((Conversable)player);
        conversation.getContext().setSessionData((Object)"player", (Object)player);
        conversation.getContext().setSessionData((Object)"type", (Object)cubeletType);
        conversation.getContext().setSessionData((Object)"texture", this.main.getCubeletTypesHandler().getConfig(cubeletType.getId()).get("type.icon.texture"));
        this.main.getConversationHandler().addConversation(player);
        return conversation;
    }

    public Conversation getConversation(Player player) {
        return this.getConversation(player, null);
    }

    public void conversationAbandoned(ConversationAbandonedEvent conversationAbandonedEvent) {
    }

    public class RenameMenuOptions
    extends FixedSetPrompt {
        RenameMenuOptions() {
            super(new String[]{"1", "2", "3", "4", "5", "6"});
        }

        protected Prompt acceptValidatedInput(ConversationContext conversationContext, String string) {
            CubeletType cubeletType = (CubeletType)conversationContext.getSessionData((Object)"type");
            Player player = (Player)conversationContext.getSessionData((Object)"player");
            switch (string) {
                case "1": {
                    conversationContext.setSessionData((Object)"method", (Object)"base64");
                    return new CommonPrompts.SkullStringPrompt(TypeIconConversation.this.main, (Prompt)this, false, ChatColor.YELLOW + "  Enter base64 texture string, \"cancel\" to return.\n\n ", "texture");
                }
                case "2": {
                    conversationContext.setSessionData((Object)"method", (Object)"uuid");
                    return new CommonPrompts.SkullStringPrompt(TypeIconConversation.this.main, (Prompt)this, false, ChatColor.YELLOW + "  Enter player uuid, \"cancel\" to return.\n\n ", "texture");
                }
                case "3": {
                    conversationContext.setSessionData((Object)"method", (Object)"name");
                    return new CommonPrompts.SkullStringPrompt(TypeIconConversation.this.main, (Prompt)this, false, ChatColor.YELLOW + "  Enter player name, \"cancel\" to return.\n\n ", "texture");
                }
                case "4": {
                    conversationContext.setSessionData((Object)"method", (Object)"url");
                    return new CommonPrompts.MineSkinStringPrompt(TypeIconConversation.this.main, (Prompt)this, false, ChatColor.YELLOW + "  Enter mineskin direct link, \"cancel\" to return.\n\n ", "texture");
                }
                case "5": {
                    String string2 = (String)conversationContext.getSessionData((Object)"method");
                    String string3 = (String)conversationContext.getSessionData((Object)"texture");
                    if (!string2.equalsIgnoreCase("url")) {
                        TypeIconConversation.this.main.getCubeletTypesHandler().getConfig(cubeletType.getId()).set("type.icon.texture", (Object)(string2 + ":" + string3));
                        switch (string2) {
                            case "base64": {
                                cubeletType.setIcon(SkullCreator.itemFromBase64(string3));
                                break;
                            }
                            case "uuid": {
                                cubeletType.setIcon(SkullCreator.itemFromUuid(UUID.fromString(string3)));
                                break;
                            }
                            case "name": {
                                cubeletType.setIcon(SkullCreator.itemFromName(string3));
                            }
                        }
                        TypeIconConversation.this.main.getCubeletTypesHandler().saveConfig(cubeletType.getId());
                        conversationContext.getForWhom().sendRawMessage("\n" + Utils.translate(TypeIconConversation.this.main.getLanguageHandler().getPrefix() + " &aSaved skull texture of cubelet type &e" + cubeletType.getId() + " &awithout errors!"));
                        Sounds.playSound(player, player.getLocation(), Sounds.MySound.ANVIL_USE, 10.0f, 3.0f);
                        TypeIconConversation.this.main.getMenuHandler().reloadAllMenus(TypeConfigMenu.class);
                        TypeIconConversation.this.main.getMenuHandler().reloadAllMenus(TypeSettingsMenu.class);
                        Object object = new TypeSettingsMenu(TypeIconConversation.this.main, player);
                        ((Menu)object).setAttribute(Menu.AttrType.CUSTOM_ID_ATTR, cubeletType.getId());
                        ((Menu)object).open();
                    } else {
                        Bukkit.getScheduler().runTaskAsynchronously((Plugin)TypeIconConversation.this.main, () -> {
                            FilterOutputStream filterOutputStream = null;
                            BufferedReader bufferedReader = null;
                            try {
                                URL uRL = new URL("https://api.mineskin.org/generate/url");
                                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                                httpURLConnection.setRequestMethod("POST");
                                httpURLConnection.setDoOutput(true);
                                httpURLConnection.setConnectTimeout(1000);
                                httpURLConnection.setReadTimeout(30000);
                                filterOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
                                ((DataOutputStream)filterOutputStream).writeBytes("url=" + URLEncoder.encode(string3, "UTF-8"));
                                filterOutputStream.close();
                                bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                                JSONObject jSONObject = (JSONObject)new JSONParser().parse(bufferedReader);
                                JSONObject jSONObject2 = (JSONObject)jSONObject.get("data");
                                JSONObject jSONObject3 = (JSONObject)jSONObject2.get("texture");
                                String string2 = (String)jSONObject3.get("value");
                                httpURLConnection.disconnect();
                                Bukkit.getScheduler().runTask((Plugin)TypeIconConversation.this.main, () -> {
                                    TypeIconConversation.this.main.getCubeletTypesHandler().getConfig(cubeletType.getId()).set("type.icon.texture", (Object)("base64:" + string2));
                                    cubeletType.setIcon(SkullCreator.itemFromBase64(string2));
                                    TypeIconConversation.this.main.getCubeletTypesHandler().saveConfig(cubeletType.getId());
                                    conversationContext.getForWhom().sendRawMessage("\n" + Utils.translate(TypeIconConversation.this.main.getLanguageHandler().getPrefix() + " &aSaved skull texture of cubelet type &e" + cubeletType.getId() + " &awithout errors!"));
                                    Sounds.playSound(player, player.getLocation(), Sounds.MySound.ANVIL_USE, 10.0f, 3.0f);
                                    TypeIconConversation.this.main.getMenuHandler().reloadAllMenus(TypeConfigMenu.class);
                                    TypeIconConversation.this.main.getMenuHandler().reloadAllMenus(TypeSettingsMenu.class);
                                    TypeSettingsMenu typeSettingsMenu = new TypeSettingsMenu(TypeIconConversation.this.main, player);
                                    typeSettingsMenu.setAttribute(Menu.AttrType.CUSTOM_ID_ATTR, cubeletType.getId());
                                    typeSettingsMenu.open();
                                });
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                            finally {
                                if (filterOutputStream != null) {
                                    try {
                                        filterOutputStream.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                if (bufferedReader != null) {
                                    try {
                                        bufferedReader.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                            }
                        });
                    }
                    TypeIconConversation.this.main.getConversationHandler().removeConversation(player);
                    return Prompt.END_OF_CONVERSATION;
                }
                case "6": {
                    return new CommonPrompts.ConfirmExitPrompt(TypeIconConversation.this.main, (Prompt)this);
                }
            }
            return null;
        }

        public String getPromptText(ConversationContext conversationContext) {
            String string = "";
            string = string + ChatColor.GOLD + "" + ChatColor.BOLD + "\n  CUBELET TYPE ICON MENU\n ";
            string = string + ChatColor.GREEN + " \n ";
            string = string + ChatColor.GREEN + "    1 " + ChatColor.GRAY + "- Base64 String\n ";
            string = string + ChatColor.GREEN + "    2 " + ChatColor.GRAY + "- Player UUID\n ";
            string = string + ChatColor.GREEN + "    3 " + ChatColor.GRAY + "- Player Name\n ";
            string = string + ChatColor.GREEN + "    4 " + ChatColor.GRAY + "- Mineskin Direct Link\n ";
            string = string + ChatColor.GREEN + " \n ";
            string = string + ChatColor.GOLD + "    5 " + ChatColor.GRAY + "- Save and exit\n ";
            string = string + ChatColor.GOLD + "    6 " + ChatColor.GRAY + "- Exit and discard\n ";
            string = string + ChatColor.GREEN + "\n ";
            string = string + ChatColor.GOLD + "" + ChatColor.YELLOW + "  Choose the option: \n ";
            return string;
        }
    }
}

