/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.conversation.rarities;

import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.conversation.CommonPrompts;
import me.davidml16.acubelets.menus.admin.rewards.RaritiesMenu;
import me.davidml16.acubelets.objects.CubeletType;
import me.davidml16.acubelets.objects.Menu;
import me.davidml16.acubelets.objects.Rarity;
import me.davidml16.acubelets.utils.Sounds;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.FixedSetPrompt;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class EditRarityConversation
implements ConversationAbandonedListener,
CommonPrompts {
    private Main main;

    public EditRarityConversation(Main main) {
        this.main = main;
    }

    public Conversation getConversation(Player player, CubeletType cubeletType, Rarity rarity) {
        Conversation conversation = new ConversationFactory((Plugin)this.main).withModality(true).withLocalEcho(false).withFirstPrompt((Prompt)new RewardMenuOptions()).withTimeout(3600).thatExcludesNonPlayersWithMessage("").addConversationAbandonedListener((ConversationAbandonedListener)this).buildConversation((Conversable)player);
        conversation.getContext().setSessionData((Object)"player", (Object)player);
        conversation.getContext().setSessionData((Object)"cubeletType", (Object)cubeletType);
        conversation.getContext().setSessionData((Object)"rarity", (Object)rarity);
        conversation.getContext().setSessionData((Object)"rarityID", (Object)rarity.getId());
        conversation.getContext().setSessionData((Object)"rarityName", (Object)rarity.getName());
        conversation.getContext().setSessionData((Object)"rarityChance", (Object)rarity.getChance());
        conversation.getContext().setSessionData((Object)"rarityDuplicate", (Object)rarity.getDuplicatePointsRange());
        this.main.getConversationHandler().addConversation(player);
        return conversation;
    }

    public Conversation getConversation(Player player) {
        return this.getConversation(player, null, null);
    }

    public void conversationAbandoned(ConversationAbandonedEvent conversationAbandonedEvent) {
    }

    private boolean rarityIdExist(CubeletType cubeletType, String string) {
        return cubeletType.getRarities().containsKey(string);
    }

    public class RewardMenuOptions
    extends FixedSetPrompt {
        RewardMenuOptions() {
            super(new String[]{"1", "2", "3", "4", "5"});
        }

        protected Prompt acceptValidatedInput(ConversationContext conversationContext, String string) {
            CubeletType cubeletType = (CubeletType)conversationContext.getSessionData((Object)"cubeletType");
            switch (string) {
                case "1": {
                    return new CommonPrompts.CommonStringPrompt(EditRarityConversation.this.main, (Prompt)this, true, ChatColor.YELLOW + "  Edit rarity name (You can use color codes), \"cancel\" to return.\n\n ", "rarityName");
                }
                case "2": {
                    return new CommonPrompts.NumericRangePrompt(EditRarityConversation.this.main, (Prompt)this, ChatColor.YELLOW + "  Edit rarity chance, \"cancel\" to return.\n  Range: 0 to 100\n\n ", "rarityChance", 0.0, 100.0);
                }
                case "3": {
                    return new CommonPrompts.DuplicateRangeStringPrompt(EditRarityConversation.this.main, (Prompt)this, false, ChatColor.YELLOW + "  Edit rarity duplicate points range, \"cancel\" to return.\n  Format: min-max. Example: 50-450\n\n ", "rarityDuplicate");
                }
                case "4": {
                    if (conversationContext.getSessionData((Object)"rarityID") != null && conversationContext.getSessionData((Object)"rarityName") != null && conversationContext.getSessionData((Object)"rarityChance") != null && conversationContext.getSessionData((Object)"rarityDuplicate") != null) {
                        if (EditRarityConversation.this.rarityIdExist(cubeletType, (String)conversationContext.getSessionData((Object)"rarityID"))) {
                            String string2 = (String)conversationContext.getSessionData((Object)"rarityID");
                            String string3 = (String)conversationContext.getSessionData((Object)"rarityName");
                            double d = (Double)conversationContext.getSessionData((Object)"rarityChance");
                            String string4 = (String)conversationContext.getSessionData((Object)"rarityDuplicate");
                            Rarity rarity = (Rarity)conversationContext.getSessionData((Object)"rarity");
                            rarity.setName(string3);
                            rarity.setChance(d);
                            rarity.setDuplicatePointsRange(string4);
                            cubeletType.saveType();
                            conversationContext.getForWhom().sendRawMessage("\n" + Utils.translate(EditRarityConversation.this.main.getLanguageHandler().getPrefix() + " &aYou edited rarity &e" + rarity.getId() + " &afrom rarities of cubelet type &e" + cubeletType.getId()));
                            Sounds.playSound((Player)conversationContext.getSessionData((Object)"player"), ((Player)conversationContext.getSessionData((Object)"player")).getLocation(), Sounds.MySound.ANVIL_USE, 10.0f, 3.0f);
                            EditRarityConversation.this.main.getMenuHandler().reloadAllMenus(RaritiesMenu.class);
                            Player player = (Player)conversationContext.getSessionData((Object)"player");
                            RaritiesMenu raritiesMenu = new RaritiesMenu(EditRarityConversation.this.main, player);
                            raritiesMenu.setAttribute(Menu.AttrType.CUSTOM_ID_ATTR, cubeletType.getId());
                            raritiesMenu.open();
                            EditRarityConversation.this.main.getConversationHandler().removeConversation(player);
                            return Prompt.END_OF_CONVERSATION;
                        }
                        EditRarityConversation.this.main.getConversationHandler().removeConversation((Player)conversationContext.getSessionData((Object)"player"));
                        return Prompt.END_OF_CONVERSATION;
                    }
                    return new CommonPrompts.ErrorPrompt(EditRarityConversation.this.main, (Prompt)this, "\n" + ChatColor.RED + "  You need to setup ID, NAME and CHANCE to save rarity!\n  Write anything to continue\n ");
                }
                case "5": {
                    return new CommonPrompts.ConfirmExitPrompt(EditRarityConversation.this.main, (Prompt)this);
                }
            }
            return null;
        }

        public String getPromptText(ConversationContext conversationContext) {
            String string = "";
            string = string + ChatColor.GOLD + "" + ChatColor.BOLD + "\n  CUBELET RARITY EDITOR MENU\n";
            string = string + ChatColor.GREEN + " \n";
            string = conversationContext.getSessionData((Object)"rarityName") == null ? string + ChatColor.RED + "    1 " + ChatColor.GRAY + "- Edit rarity name (" + ChatColor.RED + "none" + ChatColor.GRAY + ")\n" : string + ChatColor.GREEN + "    1 " + ChatColor.GRAY + "- Edit rarity name (" + ChatColor.YELLOW + conversationContext.getSessionData((Object)"rarityName") + ChatColor.GRAY + ")\n";
            string = conversationContext.getSessionData((Object)"rarityChance") == null ? string + ChatColor.RED + "    2 " + ChatColor.GRAY + "- Edit rarity chance (" + ChatColor.RED + "none" + ChatColor.GRAY + ")\n" : string + ChatColor.GREEN + "    2 " + ChatColor.GRAY + "- Edit rarity chance (" + ChatColor.YELLOW + ChatColor.translateAlternateColorCodes((char)'&', (String)String.valueOf((Double)conversationContext.getSessionData((Object)"rarityChance"))) + "%" + ChatColor.GRAY + ")\n";
            string = conversationContext.getSessionData((Object)"rarityDuplicate") == null ? string + ChatColor.RED + "    3 " + ChatColor.GRAY + "- Edit rarity duplicate points range (" + ChatColor.RED + "none" + ChatColor.GRAY + ")\n" : string + ChatColor.GREEN + "    3 " + ChatColor.GRAY + "- Edit rarity duplicate points range (" + ChatColor.YELLOW + ChatColor.translateAlternateColorCodes((char)'&', (String)String.valueOf(conversationContext.getSessionData((Object)"rarityDuplicate"))) + ChatColor.GRAY + ")\n";
            string = string + ChatColor.GREEN + "    4 " + ChatColor.GRAY + "- Save\n";
            string = string + ChatColor.GREEN + "    5 " + ChatColor.GRAY + "- Exit and discard\n";
            string = string + ChatColor.GREEN + " \n";
            string = string + ChatColor.GOLD + "" + ChatColor.YELLOW + "  Choose the option: \n";
            string = string + ChatColor.GREEN + " \n";
            return string;
        }
    }
}

