/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.database.types;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;
import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.database.types.DatabaseConnection;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.Bukkit;

public class SQLiteConnection
implements DatabaseConnection {
    private Main main;
    private Connection connection;

    public SQLiteConnection(Main main) {
        this.main = main;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        if (this.connection != null) {
            return;
        }
        File file = new File(this.main.getDataFolder(), "playerData.db");
        String string = "jdbc:sqlite:" + file;
        SQLiteConnection sQLiteConnection = this;
        synchronized (sQLiteConnection) {
            try {
                Class.forName("org.sqlite.JDBC");
                this.connection = DriverManager.getConnection(string);
                Main.log.sendMessage(Utils.translate("    &aSQLite has been enabled!"));
            }
            catch (ClassNotFoundException | SQLException exception) {
                Main.log.sendMessage(Utils.translate("    &cSQLite has an error on the conection! Plugin disabled : Database needed"));
                Bukkit.getPluginManager().disablePlugin(Objects.requireNonNull(Bukkit.getPluginManager().getPlugin("ACubelets")));
            }
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection != null ? this.connection : null;
    }

    @Override
    public void close(Connection connection) {
    }

    @Override
    public void stop() {
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
    }
}

