/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.effects;

import com.cryptomorin.xseries.XMaterial;
import me.davidml16.acubelets.utils.StringUtils;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleParticle {
    private final Particle particle;
    private final Object data;

    public SimpleParticle(@NotNull Particle particle, @Nullable Object object) {
        this.particle = particle;
        this.data = object;
    }

    @NotNull
    public static SimpleParticle of(@NotNull Particle particle) {
        return SimpleParticle.of(particle, null);
    }

    @NotNull
    public static SimpleParticle of(@NotNull Particle particle, @Nullable Object object) {
        return new SimpleParticle(particle, object);
    }

    @NotNull
    public static SimpleParticle itemCrack(@NotNull Material material) {
        return new SimpleParticle(Particle.ITEM_CRACK, new ItemStack(material));
    }

    @NotNull
    public static SimpleParticle blockCrack(@NotNull Material material) {
        return new SimpleParticle(Particle.BLOCK_CRACK, material.createBlockData());
    }

    @NotNull
    public static SimpleParticle blockDust(@NotNull Material material) {
        return new SimpleParticle(Particle.BLOCK_DUST, material.createBlockData());
    }

    @NotNull
    public static SimpleParticle fallingDust(@NotNull Material material) {
        return new SimpleParticle(Particle.FALLING_DUST, material.createBlockData());
    }

    @NotNull
    public static SimpleParticle redstone(@NotNull Color color, float f) {
        return new SimpleParticle(Particle.REDSTONE, new Particle.DustOptions(color, f));
    }

    @NotNull
    public Particle getParticle() {
        return this.particle;
    }

    @Nullable
    public Object getData() {
        return this.data;
    }

    public void play(@NotNull Location location, double d, int n) {
        this.play(location, 0.0, d, n);
    }

    public void play(@NotNull Location location, double d, double d2, int n) {
        this.play(location, d, d, d, d2, n);
    }

    public void play(@NotNull Location location, double d, double d2, double d3, double d4, int n) {
        this.play(null, location, d, d2, d3, d4, n);
    }

    public void play(@NotNull Player player, @NotNull Location location, double d, int n) {
        this.play(player, location, 0.0, d, n);
    }

    public void play(@NotNull Player player, @NotNull Location location, double d, double d2, int n) {
        this.play(player, location, d, d, d, d2, n);
    }

    public void play(@Nullable Player player, @NotNull Location location, double d, double d2, double d3, double d4, int n) {
        if (player == null) {
            World world = location.getWorld();
            if (world == null) {
                return;
            }
            try {
                world.spawnParticle(this.getParticle(), location, n, d, d2, d3, d4, this.getData());
            }
            catch (Exception exception) {}
        } else {
            try {
                player.spawnParticle(this.getParticle(), location, n, d, d2, d3, d4, this.getData());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @NotNull
    public SimpleParticle parseData(@NotNull String string) {
        String[] stringArray = string.split(" ");
        Class clazz = this.getParticle().getDataType();
        BlockData blockData = null;
        if (clazz == BlockData.class) {
            Material material = Material.getMaterial((String)string.toUpperCase());
            blockData = material != null ? material.createBlockData() : Material.STONE.createBlockData();
        } else if (clazz == Particle.DustOptions.class) {
            Color color = StringUtils.parseColor(stringArray[0]);
            double d = stringArray.length >= 2 ? StringUtils.getDouble(stringArray[1], 1.0) : 1.0;
            blockData = new Particle.DustOptions(color, (float)d);
        } else if (XMaterial.supports(17) && clazz == Particle.DustTransition.class) {
            Color color = StringUtils.parseColor(stringArray[0]);
            Color color2 = stringArray.length >= 2 ? StringUtils.parseColor(stringArray[1]) : color;
            float f = stringArray.length >= 3 ? StringUtils.getFloat(stringArray[2], 1.0f) : 1.0f;
            blockData = new Particle.DustTransition(color, color2, f);
        } else if (clazz == ItemStack.class) {
            Material material = Material.getMaterial((String)string.toUpperCase());
            blockData = material != null && !material.isAir() ? new ItemStack(material) : new ItemStack(Material.STONE);
        } else if (clazz != Void.class) {
            return SimpleParticle.redstone(Color.AQUA, 1.0f);
        }
        return SimpleParticle.of(this.getParticle(), blockData);
    }

    public boolean isClass(String string) {
        try {
            Class.forName(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public String toString() {
        return "SimpleParticle{particle=" + this.particle + ", data=" + this.data + '}';
    }
}

