/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.effects.implementations;

import me.davidml16.acubelets.effects.MachineEffect;
import me.davidml16.acubelets.effects.SimpleParticle;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public class MachineVortexEffect
extends MachineEffect {
    private static final int STRANDS = 2;
    private static final int PARTICLES = 34;
    private static final float RADIUS = 1.5f;
    private static final float CURVE = 2.0f;
    private static final double ROTATION = 0.7853981633974483;

    public MachineVortexEffect() {
        super(1L, 34, -10);
    }

    @Override
    public void doStep(@NotNull Location location, @NotNull SimpleParticle simpleParticle, int n) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 1; j <= 2; ++j) {
                float f = (float)n / 34.0f;
                double d = (double)(2.0f * f * 2.0f) * Math.PI / 2.0 + Math.PI * 2 * (double)j / 2.0 + 0.7853981633974483;
                double d2 = Math.cos(d) * (double)f * 1.5;
                double d3 = Math.sin(d) * (double)f * 1.5;
                double d4 = 3.5 - 0.1 * (double)n;
                Location location2 = location.clone().add(d2, d4, d3);
                simpleParticle.play(location2, 0.1f, 0.0, 1);
            }
        }
    }
}

