/*
 * Decompiled with CFR 0.152.
 */
package me.davidml16.acubelets.events;

import me.davidml16.acubelets.Main;
import me.davidml16.acubelets.menus.player.gifts.GiftPlayerMenu;
import me.davidml16.acubelets.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;

public class Event_JoinQuit
implements Listener {
    private Main main;

    public Event_JoinQuit(Main main) {
        this.main = main;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        this.main.getHologramImplementation().loadHolograms(player);
        this.main.getPlayerDataHandler().loadPlayerData(player);
        this.main.setPlayerCount(this.main.getPlayerCount() + 1);
        this.main.getPlayerDataHandler().getDisconnectCacheTime().remove(player.getUniqueId());
        this.main.getMenuHandler().reloadAllMenus(GiftPlayerMenu.class);
        if (player.getName().equalsIgnoreCase("DavidML16")) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.main, () -> {
                PluginDescriptionFile pluginDescriptionFile = this.main.getDescription();
                player.sendMessage(Utils.translate("&aServer using ACubelets. Version: &e" + pluginDescriptionFile.getVersion()));
            }, 40L);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        this.main.getMenuHandler().getOpenedMenus().remove(player);
        this.main.getHologramImplementation().removeHolograms(player);
        this.main.getDatabaseHandler().saveProfileAsync(this.main.getPlayerDataHandler().getData(player));
        this.main.setPlayerCount(this.main.getPlayerCount() - 1);
        this.main.getPlayerDataHandler().addDisconnectTime(player.getUniqueId(), System.currentTimeMillis());
        this.main.getDatabaseHandler().removeExpiredCubelets(player.getUniqueId());
        this.main.getMenuHandler().reloadAllMenus(GiftPlayerMenu.class);
    }

    @EventHandler
    public void worldChange(PlayerChangedWorldEvent playerChangedWorldEvent) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.main, () -> {
            this.main.getHologramImplementation().removeHolograms(playerChangedWorldEvent.getPlayer());
            this.main.getHologramImplementation().loadHolograms(playerChangedWorldEvent.getPlayer());
        }, 40L);
    }
}

